/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Bindery;
import com.icl.saxon.Binding;
import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.style.XSLGeneralVariable;
import com.icl.saxon.trace.TraceListener;
import javax.xml.transform.TransformerException;

public class VariableReference
extends Expression {
    int fingerprint;
    Binding binding;

    public VariableReference(int n, StaticContext staticContext) throws XPathException {
        this.fingerprint = n;
        this.binding = staticContext.bindVariable(n);
    }

    public int getDependencies() {
        return 1;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        if ((n & 1) != 0) {
            return this.evaluate(context);
        }
        return this;
    }

    public Value evaluate(Context context) throws XPathException {
        Bindery bindery = context.getBindery();
        Value value = bindery.getValue(this.binding);
        if (value == null) {
            if (!this.binding.isGlobal()) {
                throw new XPathException("Variable " + this.binding.getVariableName() + " is undefined");
            }
            try {
                bindery.setExecuting(this.binding, true);
                if (this.binding instanceof XSLGeneralVariable) {
                    if (context.getController().isTracing()) {
                        TraceListener traceListener = context.getController().getTraceListener();
                        traceListener.enter((XSLGeneralVariable)((Object)this.binding), context);
                        ((XSLGeneralVariable)((Object)this.binding)).process(context);
                        traceListener.leave((XSLGeneralVariable)((Object)this.binding), context);
                    } else {
                        ((XSLGeneralVariable)((Object)this.binding)).process(context);
                    }
                }
                bindery.setExecuting(this.binding, false);
                value = bindery.getValue(this.binding);
            }
            catch (TransformerException transformerException) {
                if (transformerException instanceof XPathException) {
                    throw (XPathException)transformerException;
                }
                throw new XPathException(transformerException);
            }
            if (value == null) {
                throw new XPathException("Variable " + this.binding.getVariableName() + " is undefined");
            }
        }
        return value;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public int getDataType() {
        return this.binding.getDataType();
    }

    public Expression simplify() {
        Value value = this.binding.constantValue();
        if (value == null) {
            return this;
        }
        return value;
    }

    public void display(int n) {
        System.err.println(Expression.indent(n) + "$" + this.binding.getVariableName());
    }
}

