/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class WWWFormURLEncode
extends DefaultStep
implements ProcessMatchingNodes {
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private Vector<Tuple> params = new Vector();
    private static final QName _match = new QName("", "match");
    private ProcessMatch matcher = null;
    private String encoded = "";

    public WWWFormURLEncode(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void setParameter(QName qName, RuntimeValue runtimeValue) {
        int n = -1;
        int n2 = -1;
        for (Tuple tuple : this.params) {
            ++n2;
            if (!qName.equals((Object)tuple.name)) continue;
            n = n2;
        }
        if (n >= 0) {
            this.params.remove(n);
        }
        this.params.add(new Tuple(qName, runtimeValue));
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        for (Tuple tuple : this.params) {
            if (!"".equals(this.encoded)) {
                this.encoded = this.encoded + "&";
            }
            this.encoded = this.encoded + tuple.name.getLocalName() + "=" + this.encode(tuple.value.getString());
        }
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.source.read(), this.getOption(_match));
        if (this.source.moreDocuments()) {
            throw XProcException.dynamicError(6);
        }
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode xdmNode) throws SaxonApiException {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode xdmNode) throws SaxonApiException {
    }

    @Override
    public boolean processStartElement(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addText(this.encoded);
        return false;
    }

    @Override
    public void processEndElement(XdmNode xdmNode) throws SaxonApiException {
    }

    @Override
    public void processText(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addText(this.encoded);
    }

    @Override
    public void processComment(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addComment(this.encoded);
    }

    @Override
    public void processPI(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addPI(xdmNode.getNodeName().getLocalName(), this.encoded);
    }

    @Override
    public void processAttribute(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addAttribute(xdmNode.getNodeName(), this.encoded);
    }

    private String encode(String string) {
        String string2 = ":/?#[]@";
        String string3 = "!$'()*+,;=";
        String string4 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._~";
        String string5 = string2 + string3 + string4;
        String string6 = "";
        try {
            byte[] byArray = string.getBytes("UTF-8");
            for (int i = 0; i < byArray.length; ++i) {
                string6 = string5.indexOf(byArray[i]) >= 0 ? string6 + (char)byArray[i] : string6 + String.format("%%%02X", byArray[i]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string6;
    }

    private class Tuple {
        public QName name;
        public RuntimeValue value;

        public Tuple(QName qName, RuntimeValue runtimeValue) {
            this.name = qName;
            this.value = runtimeValue;
        }
    }
}

