/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.renderx.xep.FOTarget;
import com.renderx.xep.FormatterImpl;
import com.renderx.xep.lib.ConfigurationException;
import com.renderx.xep.lib.Logger;
import com.xmlcalabash.config.FoProcessor;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.S9apiUtils;
import java.io.OutputStream;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;

public class FoXEP
implements FoProcessor {
    XProcRuntime runtime = null;
    FormatterImpl xep = null;
    XStep step = null;

    @Override
    public void initialize(XProcRuntime xProcRuntime, XStep xStep, Properties properties) {
        this.runtime = xProcRuntime;
        this.step = xStep;
        try {
            this.xep = new FormatterImpl(properties, (Logger)new FoLogger());
        }
        catch (ConfigurationException configurationException) {
            throw new XProcException("Failed to initialize XEP", (Throwable)configurationException);
        }
    }

    @Override
    public void format(XdmNode xdmNode, OutputStream outputStream, String string) {
        String string2 = null;
        if (string == null || "application/pdf".equals(string)) {
            string2 = "PDF";
        } else if ("application/PostScript".equals(string)) {
            string2 = "PostScript";
        } else if ("application/afp".equals(string)) {
            string2 = "AFP";
        } else {
            throw new XProcException(this.step.getNode(), "Unsupported content-type on p:xsl-formatter: " + string);
        }
        try {
            InputSource inputSource = S9apiUtils.xdmToInputSource(this.runtime, xdmNode);
            SAXSource sAXSource = new SAXSource(inputSource);
            this.xep.render((Source)sAXSource, new FOTarget(outputStream, string2));
        }
        catch (Exception exception) {
            throw new XProcException(this.step.getNode(), "Failed to process FO document with XEP", (Throwable)exception);
        }
        finally {
            this.xep.cleanup();
        }
    }

    private class FoLogger
    implements Logger {
        private FoLogger() {
        }

        public void openDocument() {
            FoXEP.this.step.fine(FoXEP.this.step.getNode(), "p:xsl-formatter document processing starts");
        }

        public void closeDocument() {
            FoXEP.this.step.fine(FoXEP.this.step.getNode(), "p:xsl-formatter document processing ends");
        }

        public void event(String string, String string2) {
            FoXEP.this.step.finer(FoXEP.this.step.getNode(), "p:xsl-formatter processing " + string + ": " + string2);
        }

        public void openState(String string) {
            FoXEP.this.step.finest(FoXEP.this.step.getNode(), "p:xsl-formatter process start: " + string);
        }

        public void closeState(String string) {
            FoXEP.this.step.finest(FoXEP.this.step.getNode(), "p:xsl-formatter process end: " + string);
        }

        public void info(String string) {
            FoXEP.this.step.info(FoXEP.this.step.getNode(), string);
        }

        public void warning(String string) {
            FoXEP.this.step.warning(FoXEP.this.step.getNode(), string);
        }

        public void error(String string) {
            FoXEP.this.step.error(FoXEP.this.step.getNode(), string, XProcConstants.stepError(1));
        }

        public void exception(String string, Exception exception) {
            throw new XProcException(string, (Throwable)exception);
        }
    }
}

