import { DetailedHTMLProps, FormHTMLAttributes, ForwardedRef, ReactNode } from "react";
import { useFormContext, FieldValues, UseFormProps, UseFormReturn, useWatch } from "react-hook-form";
import { ThandleSubmit } from "./types";
export type TuseFormProps<TFormData extends FieldValues> = Omit<DetailedHTMLProps<FormHTMLAttributes<HTMLFormElement>, HTMLFormElement>, "onSubmit" | "ref"> & {
    children?: ReactNode;
    onSubmit: ThandleSubmit<TFormData>;
    options?: UseFormProps<TFormData>;
};
export declare function FormProvider<TFormData extends FieldValues>({ form, children, }: {
    form: UseFormReturn<TFormData, any, undefined>;
    children: ReactNode;
}): import("react/jsx-runtime").JSX.Element;
export type TFormForwardRef<TFormData extends FieldValues> = {
    getForm: () => UseFormReturn<TFormData, any, undefined> | undefined;
};
declare function FormRaw<TFormData extends FieldValues>({ onSubmit, children, options, ...formProps }: Omit<TuseFormProps<TFormData>, "ref">, ref: ForwardedRef<TFormForwardRef<TFormData>>): import("react/jsx-runtime").JSX.Element;
declare const Form: <TFormFields extends FieldValues>(props: TuseFormProps<TFormFields> & {
    ref?: React.ForwardedRef<TFormForwardRef<TFormFields>>;
}) => ReturnType<typeof FormRaw>;
export { useWatch, useFormContext, Form };
//# sourceMappingURL=Form.d.ts.map