import{jsx as _jsx,jsxs as _jsxs,Fragment as _Fragment}from"react/jsx-runtime";import classes from"./SaveFilterMenu.module.css";import{Menu,Text}from"@mantine/core";import{SaveFilterModal}from"./SaveFilterModal";import{useState}from"react";import{ChevronDown}from"lucide-react";import{useTranslation}from"react-i18next";export const SaveFilterMenu=({filterState,handleSaveFilter,remotePersistentFilters,handleUpdateExistingFilter,selectedFilterId})=>{const[isModalOpen,setModalOpen]=useState(false);const[modalType,setModalType]=useState("Save");const{t}=useTranslation();const handleOpen=()=>setModalOpen(true);const handleClose=()=>setModalOpen(false);const getSavedFilterId=filterName=>{const found=remotePersistentFilters===null||remotePersistentFilters===void 0?void 0:remotePersistentFilters.find(filter=>filter.filterName===filterName);if(found){return found.id}return null};const handleSaveClick=()=>{const filter=remotePersistentFilters.find(filter=>filter.id===selectedFilterId);if(filter){handleUpdateExistingFilter({filterId:filter.id,filterName:filter.filterName,filter:filterState})}else{setModalType("Save");handleOpen()}};const handleSaveAsClick=()=>{if(filterState.fields.length>0){setModalType("SaveAs");handleOpen()}};const handleModalSubmit=({filterName,overwrite})=>{const filterId=getSavedFilterId(filterName);if(overwrite&&filterId){handleUpdateExistingFilter({filterId:filterId,filterName:filterName,filter:filterState})}else{handleSaveFilter({filterName,filter:filterState})}handleClose()};return _jsxs(_Fragment,{children:[filterState.fields.length>0&&_jsx("div",{className:classes["save-filter-menu"],children:_jsxs(Menu,{shadow:"md",width:"max-content",trigger:"hover",closeDelay:100,offset:5,children:[_jsx(Menu.Target,{children:_jsxs("div",{className:classes["save-filter-menu-target"],children:[_jsx(Text,{role:"button",onClick:handleSaveClick,size:"md",children:t("Save Filter")}),_jsx("div",{className:classes["save-filter-menu-chevron"],children:_jsx(ChevronDown,{color:"var(--filter-chevron-color)",size:16})})]})}),_jsx(Menu.Dropdown,{children:_jsx(Menu.Item,{disabled:!selectedFilterId,onClick:handleSaveAsClick,children:_jsx(Text,{size:"md",children:t("Save Filter As")})})})]})}),_jsx(SaveFilterModal,{modalType:modalType,isOpen:isModalOpen,onClose:handleClose,onSubmit:handleModalSubmit,getSavedFilterId:getSavedFilterId})]})};
//# sourceMappingURL=SaveFilterMenu.js.map