"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.subtract = exports.origin = exports.isEqual = exports.apply = exports.add = void 0;
// Source: https://github.com/atlassian/react-beautiful-dnd

var origin = exports.origin = {
  x: 0,
  y: 0
};

// used to apply any function to both values of a point
// eg: const floor = apply(Math.floor)(point);
var apply = exports.apply = function apply(fn) {
  return function (point) {
    return {
      x: fn(point.x),
      y: fn(point.y)
    };
  };
};
var isEqual = exports.isEqual = function isEqual(point1, point2) {
  return point1.x === point2.x && point1.y === point2.y;
};
var add = exports.add = function add(point1, point2) {
  return {
    x: point1.x + point2.x,
    y: point1.y + point2.y
  };
};
var subtract = exports.subtract = function subtract(point1, point2) {
  return {
    x: point1.x - point2.x,
    y: point1.y - point2.y
  };
};