export type EvaluationDetails = {
    time: number;
    reason: EvaluationReason;
};
export declare enum EvaluationReason {
    Error = "Error",
    LocalOverride = "LocalOverride",
    Unrecognized = "Unrecognized",
    Uninitialized = "Uninitialized",
    NetworkNotModified = "NetworkNotModified",
    Network = "Network",
    InvalidBootstrap = "InvalidBootstrap",
    Bootstrap = "Bootstrap",
    Cache = "Cache",
    Unknown = "Unknown"
}
export type StatsigOptions = {
    api?: string;
    disableCurrentPageLogging?: boolean;
    environment?: StatsigEnvironment;
    loggingIntervalMillis?: number;
    loggingBufferMaxSize?: number;
    disableNetworkKeepalive?: boolean;
    overrideStableID?: string;
    localMode?: boolean;
    initTimeoutMs?: number;
    disableErrorLogging?: boolean;
    disableAutoMetricsLogging?: boolean;
    initializeValues?: Record<string, any> | null;
    eventLoggingApi?: string;
    eventLoggingApiForRetries?: string;
    disableLocalStorage?: boolean;
    ignoreWindowUndefined?: boolean;
    updateUserCompletionCallback?: UpdateUserCompletionCallback;
    disableAllLogging?: boolean;
};
export type StatsigEnvironment = {
    tier?: 'production' | 'staging' | 'development' | string;
    [key: string]: string | undefined;
};
export type UpdateUserCompletionCallback = (durationMs: number, success: boolean, message: string | null) => void;
