// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TuneLuaOptions tune lua options
//
// swagger:model tune_lua_options
type TuneLuaOptions struct {
	// burst timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	BurstTimeout *int64 `json:"burst_timeout,omitempty"`

	// forced yield
	ForcedYield int64 `json:"forced_yield,omitempty"`

	// log loggers
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	LogLoggers string `json:"log_loggers,omitempty"`

	// log stderr
	// Enum: ["auto","enabled","disabled"]
	// +kubebuilder:validation:Enum=auto;enabled;disabled;
	LogStderr string `json:"log_stderr,omitempty"`

	// maxmem
	Maxmem *int64 `json:"maxmem,omitempty"`

	// service timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	ServiceTimeout *int64 `json:"service_timeout,omitempty"`

	// session timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	SessionTimeout *int64 `json:"session_timeout,omitempty"`

	// task timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	TaskTimeout *int64 `json:"task_timeout,omitempty"`
}

// Validate validates this tune lua options
func (m *TuneLuaOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBurstTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogLoggers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogStderr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServiceTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSessionTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTaskTimeout(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TuneLuaOptions) validateBurstTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.BurstTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("burst_timeout", "body", *m.BurstTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

var tuneLuaOptionsTypeLogLoggersPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tuneLuaOptionsTypeLogLoggersPropEnum = append(tuneLuaOptionsTypeLogLoggersPropEnum, v)
	}
}

const (

	// TuneLuaOptionsLogLoggersEnabled captures enum value "enabled"
	TuneLuaOptionsLogLoggersEnabled string = "enabled"

	// TuneLuaOptionsLogLoggersDisabled captures enum value "disabled"
	TuneLuaOptionsLogLoggersDisabled string = "disabled"
)

// prop value enum
func (m *TuneLuaOptions) validateLogLoggersEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tuneLuaOptionsTypeLogLoggersPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TuneLuaOptions) validateLogLoggers(formats strfmt.Registry) error {
	if swag.IsZero(m.LogLoggers) { // not required
		return nil
	}

	// value enum
	if err := m.validateLogLoggersEnum("log_loggers", "body", m.LogLoggers); err != nil {
		return err
	}

	return nil
}

var tuneLuaOptionsTypeLogStderrPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["auto","enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tuneLuaOptionsTypeLogStderrPropEnum = append(tuneLuaOptionsTypeLogStderrPropEnum, v)
	}
}

const (

	// TuneLuaOptionsLogStderrAuto captures enum value "auto"
	TuneLuaOptionsLogStderrAuto string = "auto"

	// TuneLuaOptionsLogStderrEnabled captures enum value "enabled"
	TuneLuaOptionsLogStderrEnabled string = "enabled"

	// TuneLuaOptionsLogStderrDisabled captures enum value "disabled"
	TuneLuaOptionsLogStderrDisabled string = "disabled"
)

// prop value enum
func (m *TuneLuaOptions) validateLogStderrEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tuneLuaOptionsTypeLogStderrPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TuneLuaOptions) validateLogStderr(formats strfmt.Registry) error {
	if swag.IsZero(m.LogStderr) { // not required
		return nil
	}

	// value enum
	if err := m.validateLogStderrEnum("log_stderr", "body", m.LogStderr); err != nil {
		return err
	}

	return nil
}

func (m *TuneLuaOptions) validateServiceTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.ServiceTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("service_timeout", "body", *m.ServiceTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *TuneLuaOptions) validateSessionTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.SessionTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("session_timeout", "body", *m.SessionTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *TuneLuaOptions) validateTaskTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.TaskTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("task_timeout", "body", *m.TaskTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this tune lua options based on context it is used
func (m *TuneLuaOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *TuneLuaOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TuneLuaOptions) UnmarshalBinary(b []byte) error {
	var res TuneLuaOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
