//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
use objc2_core_graphics::*;
#[cfg(feature = "objc2-core-video")]
use objc2_core_video::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-image-io")]
use objc2_image_io::*;
#[cfg(feature = "objc2-io-surface")]
use objc2_io_surface::*;
#[cfg(feature = "objc2-metal")]
use objc2_metal::*;
#[cfg(feature = "objc2-open-gl")]
#[cfg(target_os = "macos")]
use objc2_open_gl::*;

use crate::*;

/// An enum string type that your code can use to select different options when creating a Core Image context.
///
/// These option keys can be passed to `CIContext` creation APIs such as:
/// * ``/CIContext/contextWithOptions:``
/// * ``/CIContext/contextWithMTLDevice:options:``
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cicontextoption?language=objc)
// NS_TYPED_ENUM
pub type CIContextOption = NSString;

extern "C" {
    /// A Core Image context option key to specify the default destination color space for rendering.
    ///
    /// This option only affects how Core Image renders using the following methods:
    /// * ``/CIContext/createCGImage:fromRect:``
    /// * ``/CIContext/drawImage:atPoint:fromRect:``
    /// * ``/CIContext/drawImage:inRect:fromRect:``
    ///
    /// With all other render methods, the destination color space is either specified as a parameter
    /// or can be determined from the object being rendered to.
    ///
    /// The value of this option can be either:
    /// * A `CGColorSpace` instance with an RGB or monochrome color model that supports output.
    /// * An `NSNull` instance to indicate that the context should not match from the working space to the destination.
    ///
    /// If this option is not specified, then the default output space is sRGB.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicontextoutputcolorspace?language=objc)
    pub static kCIContextOutputColorSpace: &'static CIContextOption;
}

extern "C" {
    /// A Core Image context option key to specify the working color space for rendering.
    ///
    /// Contexts support automatic color management by performing all processing operations
    /// in a working color space. This means that unless told otherwise:
    /// * All input images are color matched from the input's color space to the working space.
    /// * All renders are color matched from the working space to the destination's color space.
    ///
    /// The default working space is the extended sRGB color space with linear gamma.
    /// On macOS before 10.10, the default is extended Generic RGB with linear gamma.
    ///
    /// The value of this option can be either:
    /// * A `CGColorSpace` instance with an RGB color model that supports output.
    /// * An `NSNull` instance to request that Core Image perform no color management.
    ///
    /// If this option is not specified, then the default working space is used.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicontextworkingcolorspace?language=objc)
    pub static kCIContextWorkingColorSpace: &'static CIContextOption;
}

extern "C" {
    /// A Core Image context option key to specify the pixel format to for intermediate results when rendering.
    ///
    /// The value for this key is an `NSNumber` instance containing a ``CIFormat`` value.
    ///
    /// The supported values for the working pixel format are:
    /// ``CIFormat``        | Notes
    /// ------------------- | --------------
    /// ``kCIFormatRGBA8``  | Uses less memory but has less precision an range
    /// ``kCIFormatRGBAh``  | Uses 8 bytes per pixel, supports HDR
    /// ``kCIFormatRGBAf``  | Only on macOS
    ///
    /// If this option is not specified, then the default is ``kCIFormatRGBAh``.
    ///
    /// (The default is ``kCIFormatRGBA8`` if your if app is linked against iOS 12 SDK or earlier.)
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicontextworkingformat?language=objc)
    pub static kCIContextWorkingFormat: &'static CIContextOption;
}

extern "C" {
    /// A Boolean value to control the quality of image downsampling operations performed by the
    /// Core Image context.
    ///
    /// The higher quality behavior performs downsampling operations in multiple passes
    /// in order to reduce aliasing artifacts.
    ///
    /// The lower quality behavior performs downsampling operations a single pass
    /// in order to improve performance.
    ///
    /// If the value for this option is:
    /// * True: The higher quality behavior will be used.
    /// * False: The lower quality behavior will be used.
    /// * Not specified: the default behavior is True on macOS and False on other platforms.
    ///
    /// > Note:
    /// > * This option does affect how ``/CIImage/imageByApplyingTransform:`` operations are performed by the context.
    /// > * This option does not affect how ``/CIImage/imageByApplyingTransform:highQualityDownsample:`` behaves.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicontexthighqualitydownsample?language=objc)
    pub static kCIContextHighQualityDownsample: &'static CIContextOption;
}

extern "C" {
    /// A Boolean value to control how a Core Image context render produces alpha-premultiplied pixels.
    ///
    /// This option only affects how a context is rendered when using methods where the destination's
    /// alpha mode cannot be determined such as:
    /// *  ``/CIContext/render:toBitmap:rowBytes:bounds:format:colorSpace:``
    /// *  ``/CIContext/render:toCVPixelBuffer:``
    /// *  ``/CIContext/render:toIOSurface:bounds:colorSpace:``
    /// *  ``/CIContext/render:toMTLTexture:commandBuffer:bounds:colorSpace:``
    /// *  ``/CIContext/createCGImage:fromRect:``
    ///
    /// If the value for this option is:
    /// * True: The output will produce alpha-premultiplied pixels.
    /// * False: The output will produce un-premultiplied pixels.
    /// * Not specified: the default behavior True.
    ///
    /// This option does not affect how a context is rendered to a ``CIRenderDestination`` because
    /// that API allows you to set or override the alpha behavior using ``/CIRenderDestination/alphaMode``.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicontextoutputpremultiplied?language=objc)
    pub static kCIContextOutputPremultiplied: &'static CIContextOption;
}

extern "C" {
    /// A Boolean value to control how a Core Image context caches the contents of any intermediate image buffers it uses during rendering.
    ///
    /// If a context caches intermediate buffers, then subsequent renders of a similar image using the same context
    /// may be able to render faster. If a context does not cache intermediate buffers, then it may use less memory.
    ///
    /// If the value for this option is:
    /// * True: The context will cache intermediate results for future renders using the same context.
    /// * False: The context will not cache intermediate results.
    /// * Not specified: the default behavior True.
    ///
    /// > Note:
    /// > * This option does affect how ``/CIImage/imageByInsertingIntermediate`` behaves.
    /// > * This option does not affect how ``/CIImage/imageByInsertingIntermediate:`` behaves.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicontextcacheintermediates?language=objc)
    pub static kCIContextCacheIntermediates: &'static CIContextOption;
}

extern "C" {
    /// A Boolean value to control if a Core Image context will use a software renderer.
    ///
    /// > Note: This option has no effect if the platform does not support OpenCL.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicontextusesoftwarerenderer?language=objc)
    pub static kCIContextUseSoftwareRenderer: &'static CIContextOption;
}

extern "C" {
    /// A Boolean value to control the priority Core Image context renders.
    ///
    /// If this value is True, then rendering with the context from a background thread takes lower priority
    /// than other GPU usage from the main thread. This allows your app to perform Core Image rendering without
    /// disturbing the frame rate of UI animations.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicontextpriorityrequestlow?language=objc)
    pub static kCIContextPriorityRequestLow: &'static CIContextOption;
}

extern "C" {
    /// A Boolean value to control the power level of Core Image context renders.
    ///
    /// This option only affects certain macOS devices with more than one available GPU device.
    ///
    /// If this value is True, then rendering with the context will use a use allow power GPU device
    /// if available and the high power device is not already in use.
    ///
    /// Otherwise, the context will use the highest power/performance GPU device.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicontextallowlowpower?language=objc)
    pub static kCIContextAllowLowPower: &'static CIContextOption;
}

extern "C" {
    /// A Boolean value to specify a client-provided name for a context.
    ///
    /// This name will be used in QuickLook graphs and the output of CI_PRINT_TREE.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicontextname?language=objc)
    pub static kCIContextName: &'static CIContextOption;
}

extern "C" {
    /// A Core Video Metal texture cache object to improve the performance of Core Image context
    /// renders that use Core Video pixel buffers.
    ///
    /// Creating a Core Image context with this optional `CVMetalTextureCache` can improve the
    /// performance of creating a Metal texture from a `CVPixelBuffer`. It is recommended
    /// to specify this option if the context renders to or from pixel buffers that come
    /// from a `CVPixelBufferPool`.
    ///
    /// It is the client's responsibility to flush the cache when appropriate.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicontextcvmetaltexturecache?language=objc)
    pub static kCIContextCVMetalTextureCache: &'static CIContextOption;
}

extern "C" {
    /// A number value to control the maximum memory in megabytes that the context allocates for render tasks.
    ///
    /// Larger values could increase memory  footprint while smaller values could reduce performance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicontextmemorylimit?language=objc)
    pub static kCIContextMemoryLimit: &'static CIContextOption;
}

extern_class!(
    /// The Core Image context class provides an evaluation context for Core Image processing with Metal, OpenGL, or OpenCL.
    ///
    /// You use a `CIContext` instance to render a ``CIImage`` instance which represents a graph of image processing operations
    /// which are built using other Core Image classes, such as ``CIFilter-class``, ``CIKernel``, ``CIColor`` and ``CIImage``.
    /// You can also use a `CIContext` with the ``CIDetector`` class to analyze images — for example, to detect faces
    /// or barcodes.
    ///
    /// Contexts support automatic color management by performing all processing operations in a working color space.
    /// This means that unless told otherwise:
    /// * All input images are color matched from the input's color space to the working space.
    /// * All renders are color matched from the working space to the destination space.
    /// (For more information on `CGColorSpace` see
    /// <doc
    /// ://com.apple.documentation/documentation/coregraphics/cgcolorspace>)
    ///
    /// `CIContext` and ``CIImage`` instances are immutable, so multiple threads can use the same ``CIContext`` instance
    /// to render ``CIImage`` instances. However, ``CIFilter-class`` instances are mutable and thus cannot be shared safely among
    /// threads. Each thread must take case not to access or modify a ``CIFilter-class`` instance while it is being used by
    /// another thread.
    ///
    /// The `CIContext` manages various internal state such as `MTLCommandQueue` and caches for compiled kernels
    /// and intermediate buffers.  For this reason it is not recommended to create many `CIContext` instances.  As a rule,
    /// it recommended that you create one `CIContext` instance for each view that renders ``CIImage`` or each background task.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cicontext?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIContext;
);

unsafe impl Send for CIContext {}

unsafe impl Sync for CIContext {}

extern_conformance!(
    unsafe impl NSObjectProtocol for CIContext {}
);

impl CIContext {
    extern_methods!(
        #[cfg(all(feature = "objc2-core-graphics", feature = "objc2-open-gl"))]
        #[cfg(target_os = "macos")]
        /// # Safety
        ///
        /// - `cglctx` must be a valid pointer.
        /// - `pixel_format` must be a valid pointer or null.
        /// - `options` generic should be of the correct type.
        #[deprecated = "Core Image OpenGL API deprecated. (Define CI_SILENCE_GL_DEPRECATION to silence these warnings)"]
        #[unsafe(method(contextWithCGLContext:pixelFormat:colorSpace:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn contextWithCGLContext_pixelFormat_colorSpace_options(
            cglctx: CGLContextObj,
            pixel_format: CGLPixelFormatObj,
            color_space: Option<&CGColorSpace>,
            options: Option<&NSDictionary<CIContextOption, AnyObject>>,
        ) -> Retained<CIContext>;

        #[cfg(feature = "objc2-open-gl")]
        #[cfg(target_os = "macos")]
        /// # Safety
        ///
        /// - `cglctx` must be a valid pointer.
        /// - `pixel_format` must be a valid pointer or null.
        /// - `options` generic should be of the correct type.
        #[deprecated = "Core Image OpenGL API deprecated. (Define CI_SILENCE_GL_DEPRECATION to silence these warnings)"]
        #[unsafe(method(contextWithCGLContext:pixelFormat:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn contextWithCGLContext_pixelFormat_options(
            cglctx: CGLContextObj,
            pixel_format: CGLPixelFormatObj,
            options: Option<&NSDictionary<CIContextOption, AnyObject>>,
        ) -> Retained<CIContext>;

        #[cfg(feature = "objc2-core-graphics")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(contextWithCGContext:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn contextWithCGContext_options(
            cgctx: &CGContext,
            options: Option<&NSDictionary<CIContextOption, AnyObject>>,
        ) -> Retained<CIContext>;

        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(contextWithOptions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn contextWithOptions(
            options: Option<&NSDictionary<CIContextOption, AnyObject>>,
        ) -> Retained<CIContext>;

        #[unsafe(method(context))]
        #[unsafe(method_family = none)]
        pub unsafe fn context() -> Retained<CIContext>;

        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(initWithOptions:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithOptions(
            this: Allocated<Self>,
            options: Option<&NSDictionary<CIContextOption, AnyObject>>,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "objc2-metal")]
        #[unsafe(method(contextWithMTLDevice:))]
        #[unsafe(method_family = none)]
        pub unsafe fn contextWithMTLDevice(
            device: &ProtocolObject<dyn MTLDevice>,
        ) -> Retained<CIContext>;

        #[cfg(feature = "objc2-metal")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(contextWithMTLDevice:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn contextWithMTLDevice_options(
            device: &ProtocolObject<dyn MTLDevice>,
            options: Option<&NSDictionary<CIContextOption, AnyObject>>,
        ) -> Retained<CIContext>;

        #[cfg(feature = "objc2-metal")]
        #[unsafe(method(contextWithMTLCommandQueue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn contextWithMTLCommandQueue(
            command_queue: &ProtocolObject<dyn MTLCommandQueue>,
        ) -> Retained<CIContext>;

        #[cfg(feature = "objc2-metal")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(contextWithMTLCommandQueue:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn contextWithMTLCommandQueue_options(
            command_queue: &ProtocolObject<dyn MTLCommandQueue>,
            options: Option<&NSDictionary<CIContextOption, AnyObject>>,
        ) -> Retained<CIContext>;

        #[cfg(feature = "objc2-core-graphics")]
        /// The working color space of the CIContext.
        ///
        /// The working color space determines the color space used when executing filter kernels.
        /// You specify a working color space using the ``kCIContextWorkingColorSpace`` option when creating a ``CIContext``.
        /// * All input images are color matched from the input's color space to the working space.
        /// * All renders are color matched from the working space to the destination space.
        ///
        /// The property will be `null` if the context was created with color management disabled.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(workingColorSpace))]
        #[unsafe(method_family = none)]
        pub unsafe fn workingColorSpace(&self) -> Option<Retained<CGColorSpace>>;

        #[cfg(feature = "CIImage")]
        /// The working pixel format that the CIContext uses for intermediate buffers.
        ///
        /// The working format determines the pixel format that Core Image uses to create intermediate buffers for rendering images.
        /// You specify a working pixel format using the ``kCIContextWorkingFormat`` option when creating a ``CIContext``.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(workingFormat))]
        #[unsafe(method_family = none)]
        pub unsafe fn workingFormat(&self) -> CIFormat;

        #[cfg(all(feature = "CIImage", feature = "objc2-core-foundation"))]
        #[deprecated]
        #[unsafe(method(drawImage:atPoint:fromRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawImage_atPoint_fromRect(
            &self,
            image: &CIImage,
            at_point: CGPoint,
            from_rect: CGRect,
        );

        #[cfg(all(feature = "CIImage", feature = "objc2-core-foundation"))]
        #[unsafe(method(drawImage:inRect:fromRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawImage_inRect_fromRect(
            &self,
            image: &CIImage,
            in_rect: CGRect,
            from_rect: CGRect,
        );

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-core-graphics"))]
        /// # Safety
        ///
        /// `info` generics must be of the correct type.
        #[deprecated]
        #[unsafe(method(createCGLayerWithSize:info:))]
        // required for soundness, method has `returns_retained` attribute.
        #[unsafe(method_family = copy)]
        pub unsafe fn createCGLayerWithSize_info(
            &self,
            size: CGSize,
            info: Option<&CFDictionary>,
        ) -> Option<Retained<CGLayer>>;

        #[cfg(all(
            feature = "CIImage",
            feature = "objc2-core-foundation",
            feature = "objc2-core-graphics"
        ))]
        /// # Safety
        ///
        /// `data` must be a valid pointer.
        #[unsafe(method(render:toBitmap:rowBytes:bounds:format:colorSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn render_toBitmap_rowBytes_bounds_format_colorSpace(
            &self,
            image: &CIImage,
            data: NonNull<c_void>,
            row_bytes: isize,
            bounds: CGRect,
            format: CIFormat,
            color_space: Option<&CGColorSpace>,
        );

        #[cfg(all(
            feature = "CIImage",
            feature = "objc2-core-foundation",
            feature = "objc2-core-graphics",
            feature = "objc2-io-surface"
        ))]
        #[unsafe(method(render:toIOSurface:bounds:colorSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn render_toIOSurface_bounds_colorSpace(
            &self,
            image: &CIImage,
            surface: &IOSurfaceRef,
            bounds: CGRect,
            color_space: Option<&CGColorSpace>,
        );

        #[cfg(all(feature = "CIImage", feature = "objc2-core-video"))]
        #[unsafe(method(render:toCVPixelBuffer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn render_toCVPixelBuffer(&self, image: &CIImage, buffer: &CVPixelBuffer);

        #[cfg(all(
            feature = "CIImage",
            feature = "objc2-core-foundation",
            feature = "objc2-core-graphics",
            feature = "objc2-core-video"
        ))]
        #[unsafe(method(render:toCVPixelBuffer:bounds:colorSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn render_toCVPixelBuffer_bounds_colorSpace(
            &self,
            image: &CIImage,
            buffer: &CVPixelBuffer,
            bounds: CGRect,
            color_space: Option<&CGColorSpace>,
        );

        #[cfg(all(
            feature = "CIImage",
            feature = "objc2-core-foundation",
            feature = "objc2-core-graphics",
            feature = "objc2-metal"
        ))]
        /// # Safety
        ///
        /// - `texture` may need to be synchronized.
        /// - `texture` may be unretained, you must ensure it is kept alive while in use.
        #[unsafe(method(render:toMTLTexture:commandBuffer:bounds:colorSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn render_toMTLTexture_commandBuffer_bounds_colorSpace(
            &self,
            image: &CIImage,
            texture: &ProtocolObject<dyn MTLTexture>,
            command_buffer: Option<&ProtocolObject<dyn MTLCommandBuffer>>,
            bounds: CGRect,
            color_space: &CGColorSpace,
        );

        #[unsafe(method(reclaimResources))]
        #[unsafe(method_family = none)]
        pub unsafe fn reclaimResources(&self);

        #[unsafe(method(clearCaches))]
        #[unsafe(method_family = none)]
        pub unsafe fn clearCaches(&self);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(inputImageMaximumSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn inputImageMaximumSize(&self) -> CGSize;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(outputImageMaximumSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn outputImageMaximumSize(&self) -> CGSize;
    );
}

/// Methods declared on superclass `NSObject`.
impl CIContext {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// createCGImage.
impl CIContext {
    extern_methods!(
        #[cfg(all(
            feature = "CIImage",
            feature = "objc2-core-foundation",
            feature = "objc2-core-graphics"
        ))]
        /// Creates a Core Graphics image from a region of a Core Image image instance.
        ///
        /// The color space of the created `CGImage` will be sRGB unless the receiving ``CIContext``
        /// was created with a `kCIContextOutputColorSpace` option.
        ///
        /// Normally the pixel format of the created CGImage will be 8 bits-per-component.
        /// It will be 16 bits-per-component float if the above color space is HDR.
        ///
        /// - Parameters:
        /// - image: A ``CIImage`` image instance for which to create a `CGImage`.
        /// - fromRect: The `CGRect` region of the `image` to use.
        /// This region relative to the cartesean coordinate system of `image`.
        /// This region will be intersected with integralized and intersected with `image.extent`.
        ///
        /// - Returns:
        /// Returns a new `CGImage` instance.
        /// You are responsible for releasing the returned image when you no longer need it.
        /// The returned value will be `null` if the extent is empty or too big.
        #[unsafe(method(createCGImage:fromRect:))]
        // required for soundness, method has `returns_retained` attribute.
        #[unsafe(method_family = copy)]
        pub unsafe fn createCGImage_fromRect(
            &self,
            image: &CIImage,
            from_rect: CGRect,
        ) -> Option<Retained<CGImage>>;

        #[cfg(all(
            feature = "CIImage",
            feature = "objc2-core-foundation",
            feature = "objc2-core-graphics"
        ))]
        /// Creates a Core Graphics image from a region of a Core Image image instance
        /// with an option for controlling the pixel format and color space of the `CGImage`.
        ///
        /// - Parameters:
        /// - image: A ``CIImage`` image instance for which to create a `CGImage`.
        /// - fromRect: The `CGRect` region of the `image` to use.
        /// This region relative to the cartesean coordinate system of `image`.
        /// This region will be intersected with integralized and intersected with `image.extent`.
        /// - format: A ``CIFormat`` to specify the pixel format of the created `CGImage`.
        /// For example, if `kCIFormatRGBX16` is specified, then the created `CGImage` will
        /// be 16 bits-per-component and opaque.
        /// - colorSpace: The `CGColorSpace` for the output image.
        /// This color space must have either `CGColorSpaceModel.rgb` or `CGColorSpaceModel.monochrome`
        /// and be compatible with the specified pixel format.
        ///
        /// - Returns:
        /// Returns a new `CGImage` instance.
        /// You are responsible for releasing the returned image when you no longer need it.
        /// The returned value will be `null` if the extent is empty or too big.
        #[unsafe(method(createCGImage:fromRect:format:colorSpace:))]
        // required for soundness, method has `returns_retained` attribute.
        #[unsafe(method_family = copy)]
        pub unsafe fn createCGImage_fromRect_format_colorSpace(
            &self,
            image: &CIImage,
            from_rect: CGRect,
            format: CIFormat,
            color_space: Option<&CGColorSpace>,
        ) -> Option<Retained<CGImage>>;

        #[cfg(all(
            feature = "CIImage",
            feature = "objc2-core-foundation",
            feature = "objc2-core-graphics"
        ))]
        /// Creates a Core Graphics image from a region of a Core Image image instance
        /// with an option for controlling when the image is rendered.
        ///
        /// - Parameters:
        /// - image: A ``CIImage`` image instance for which to create a `CGImage`.
        /// - fromRect: The `CGRect` region of the `image` to use.
        /// This region relative to the cartesean coordinate system of `image`.
        /// This region will be intersected with integralized and intersected with `image.extent`.
        /// - format: A ``CIFormat`` to specify the pixel format of the created `CGImage`.
        /// For example, if `kCIFormatRGBX16` is specified, then the created `CGImage` will
        /// be 16 bits-per-component and opaque.
        /// - colorSpace: The `CGColorSpace` for the output image.
        /// This color space must have either `CGColorSpaceModel.rgb` or `CGColorSpaceModel.monochrome`
        /// and be compatible with the specified pixel format.
        /// - deferred: Controls when Core Image renders `image`.
        /// * True: rendering of `image` is deferred until the created `CGImage` rendered.
        /// * False: the `image` is rendered immediately.
        ///
        /// - Returns:
        /// Returns a new `CGImage` instance.
        /// You are responsible for releasing the returned image when you no longer need it.
        /// The returned value will be `null` if the extent is empty or too big.
        #[unsafe(method(createCGImage:fromRect:format:colorSpace:deferred:))]
        // required for soundness, method has `returns_retained` attribute.
        #[unsafe(method_family = copy)]
        pub unsafe fn createCGImage_fromRect_format_colorSpace_deferred(
            &self,
            image: &CIImage,
            from_rect: CGRect,
            format: CIFormat,
            color_space: Option<&CGColorSpace>,
            deferred: bool,
        ) -> Option<Retained<CGImage>>;

        #[cfg(all(
            feature = "CIImage",
            feature = "objc2-core-foundation",
            feature = "objc2-core-graphics"
        ))]
        /// Creates a Core Graphics image from a region of a Core Image image instance
        /// with an option for calculating HDR statistics.
        ///
        /// - Parameters:
        /// - image: A ``CIImage`` image instance for which to create a `CGImage`.
        /// - fromRect: The `CGRect` region of the `image` to use.
        /// This region relative to the cartesean coordinate system of `image`.
        /// This region will be intersected with integralized and intersected with `image.extent`.
        /// - format: A ``CIFormat`` to specify the pixel format of the created `CGImage`.
        /// For example, if `kCIFormatRGBX16` is specified, then the created `CGImage` will
        /// be 16 bits-per-component and opaque.
        /// - colorSpace: The `CGColorSpace` for the output image.
        /// This color space must have either `CGColorSpaceModel.rgb` or `CGColorSpaceModel.monochrome`
        /// and be compatible with the specified pixel format.
        /// - deferred: Controls when Core Image renders `image`.
        /// * True: rendering of `image` is deferred until the created `CGImage` rendered.
        /// * False: the `image` is rendered immediately.
        /// - calculateHDRStats: Controls if Core Image calculates HDR statistics.
        /// * True: Core Image will immediately render `image`, calculate the HDR statistics
        /// and create a `CGImage` that has the calculated values.
        /// * False:  the created `CGImage` will not have any HDR statistics.
        ///
        /// - Returns:
        /// Returns a new `CGImage` instance.
        /// You are responsible for releasing the returned image when you no longer need it.
        /// The returned value will be `null` if the extent is empty or too big.
        #[unsafe(method(createCGImage:fromRect:format:colorSpace:deferred:calculateHDRStats:))]
        // required for soundness, method has `returns_retained` attribute.
        #[unsafe(method_family = copy)]
        pub unsafe fn createCGImage_fromRect_format_colorSpace_deferred_calculateHDRStats(
            &self,
            image: &CIImage,
            from_rect: CGRect,
            format: CIFormat,
            color_space: Option<&CGColorSpace>,
            deferred: bool,
            calculate_hdr_stats: bool,
        ) -> Option<Retained<CGImage>>;
    );
}

/// CalculateHDRStats.
impl CIContext {
    extern_methods!(
        #[cfg(feature = "objc2-io-surface")]
        /// Given an IOSurface, use the receiving Core Image context to calculate its
        /// HDR statistics (content headroom and content average light level)
        /// and then update the surface's attachments to store the values.
        ///
        /// If the `IOSurface` has a Clean Aperture rectangle then only pixels within
        /// that rectangle are considered.
        ///
        /// - Parameters:
        /// - surface: A mutable `IOSurfaceRef` for which to calculate and attach statistics.
        #[unsafe(method(calculateHDRStatsForIOSurface:))]
        #[unsafe(method_family = none)]
        pub unsafe fn calculateHDRStatsForIOSurface(&self, surface: &IOSurfaceRef);

        #[cfg(feature = "objc2-core-video")]
        /// Given a CVPixelBuffer, use the receiving Core Image context to calculate its
        /// HDR statistics (content headroom and content average light level)
        /// and then update the buffers's attachments to store the values.
        ///
        /// If the `CVPixelBuffer` has a Clean Aperture rectangle then only pixels within
        /// that rectangle are considered.
        ///
        /// - Parameters:
        /// - buffer: A mutable `CVPixelBuffer` for which to calculate and attach statistics.
        #[unsafe(method(calculateHDRStatsForCVPixelBuffer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn calculateHDRStatsForCVPixelBuffer(&self, buffer: &CVPixelBuffer);

        #[cfg(feature = "objc2-core-graphics")]
        /// Given a Core Graphics image, use the receiving Core Image context to calculate its
        /// HDR statistics (content headroom and content average light level)
        /// and then return a new Core Graphics image that has the calculated values.
        ///
        /// - Parameters:
        /// - cgimage: An immutable `CGImage` for which to calculate statistics.
        /// - Returns:
        /// Returns a new `CGImage` instance that has the calculated statistics attached.
        #[unsafe(method(calculateHDRStatsForCGImage:))]
        // required for soundness, method has `returns_retained` attribute.
        #[unsafe(method_family = copy)]
        pub unsafe fn calculateHDRStatsForCGImage(&self, cgimage: &CGImage) -> Retained<CGImage>;

        #[cfg(feature = "CIImage")]
        /// Given a Core Image image, use the receiving Core Image context to calculate its
        /// HDR statistics (content headroom and content average light level)
        /// and then return a new Core Image image that has the calculated values.
        ///
        /// If the image extent is not finite, then nil will be returned.
        ///
        /// - Parameters:
        /// - image: An immutable ``CIImage`` for which to calculate statistics.
        /// - Returns:
        /// Returns a new ``CIImage`` instance that has the calculated statistics attached.
        #[unsafe(method(calculateHDRStatsForImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn calculateHDRStatsForImage(
            &self,
            image: &CIImage,
        ) -> Option<Retained<CIImage>>;
    );
}

/// OfflineGPUSupport.
impl CIContext {
    extern_methods!(
        #[unsafe(method(offlineGPUCount))]
        #[unsafe(method_family = none)]
        pub unsafe fn offlineGPUCount() -> c_uint;

        #[deprecated = "Core Image OpenGL API deprecated. (Define CI_SILENCE_GL_DEPRECATION to silence these warnings)"]
        #[unsafe(method(contextForOfflineGPUAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn contextForOfflineGPUAtIndex(index: c_uint) -> Option<Retained<CIContext>>;

        #[cfg(all(feature = "objc2-core-graphics", feature = "objc2-open-gl"))]
        #[cfg(target_os = "macos")]
        /// # Safety
        ///
        /// - `options` generic should be of the correct type.
        /// - `shared_context` must be a valid pointer or null.
        #[deprecated = "Core Image OpenGL API deprecated. (Define CI_SILENCE_GL_DEPRECATION to silence these warnings)"]
        #[unsafe(method(contextForOfflineGPUAtIndex:colorSpace:options:sharedContext:))]
        #[unsafe(method_family = none)]
        pub unsafe fn contextForOfflineGPUAtIndex_colorSpace_options_sharedContext(
            index: c_uint,
            color_space: Option<&CGColorSpace>,
            options: Option<&NSDictionary<CIContextOption, AnyObject>>,
            shared_context: CGLContextObj,
        ) -> Option<Retained<CIContext>>;
    );
}

/// An enum string type that your code can use to select different options when saving to image representations such as JPEG and HEIF.
///
/// Some of the methods that support these options are:
/// * ``/CIContext/JPEGRepresentationOfImage:colorSpace:options:``
/// * ``/CIContext/HEIFRepresentationOfImage:format:colorSpace:options:``
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/ciimagerepresentationoption?language=objc)
// NS_TYPED_ENUM
pub type CIImageRepresentationOption = NSString;

extern "C" {
    /// An optional key and value to save additional depth channel information to a JPEG or HEIF representations.
    ///
    /// The value for this key needs to be an `AVDepthData` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagerepresentationavdepthdata?language=objc)
    pub static kCIImageRepresentationAVDepthData: &'static CIImageRepresentationOption;
}

extern "C" {
    /// An optional key and value to save additional depth channel information to a JPEG or HEIF.
    ///
    /// The value for this key needs to be a monochrome depth ``CIImage`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagerepresentationdepthimage?language=objc)
    pub static kCIImageRepresentationDepthImage: &'static CIImageRepresentationOption;
}

extern "C" {
    /// An optional key and value to save additional depth channel information to a JPEG or HEIF.
    ///
    /// The value for this key needs to be a monochrome disparity ``CIImage`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagerepresentationdisparityimage?language=objc)
    pub static kCIImageRepresentationDisparityImage: &'static CIImageRepresentationOption;
}

extern "C" {
    /// An optional key and value to save a portrait matte channel information to a JPEG or HEIF.
    ///
    /// The value for this key needs to be a an `AVPortraitEffectsMatte` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagerepresentationavportraiteffectsmatte?language=objc)
    pub static kCIImageRepresentationAVPortraitEffectsMatte: &'static CIImageRepresentationOption;
}

extern "C" {
    /// An optional key and value to save a portrait matte channel to a JPEG or HEIF.
    ///
    /// The value for this key needs to be a portrait matte ``CIImage`` instance where black pixels
    /// represent the background region and white pixels represent the primary people in the image.
    /// The image will be converted to monochrome before it is saved to the JPEG or HEIF.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagerepresentationportraiteffectsmatteimage?language=objc)
    pub static kCIImageRepresentationPortraitEffectsMatteImage:
        &'static CIImageRepresentationOption;
}

extern "C" {
    /// An optional key and value to save one or more segmentation matte channels to a JPEG or HEIF.
    ///
    /// The value for this key needs to be an array of AVSemanticSegmentationMatte instances.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagerepresentationavsemanticsegmentationmattes?language=objc)
    pub static kCIImageRepresentationAVSemanticSegmentationMattes:
        &'static CIImageRepresentationOption;
}

extern "C" {
    /// An optional key and value to save a skin segmentation channel to a JPEG or HEIF.
    ///
    /// The value for this key needs to be a ``CIImage`` instance where white pixels
    /// represent the areas of person's skin are found in the image.
    /// The image will be converted to monochrome before it is saved to the JPEG or HEIF.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagerepresentationsemanticsegmentationskinmatteimage?language=objc)
    pub static kCIImageRepresentationSemanticSegmentationSkinMatteImage:
        &'static CIImageRepresentationOption;
}

extern "C" {
    /// An optional key and value to save a skin segmentation channel to a JPEG or HEIF.
    ///
    /// The value for this key needs to be a ``CIImage`` instance where white pixels
    /// represent the areas of person's head and facial hair are found in the image.
    /// The image will be converted to monochrome before it is saved to the JPEG or HEIF.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagerepresentationsemanticsegmentationhairmatteimage?language=objc)
    pub static kCIImageRepresentationSemanticSegmentationHairMatteImage:
        &'static CIImageRepresentationOption;
}

extern "C" {
    /// An optional key and value to save a skin segmentation channel to a JPEG or HEIF.
    ///
    /// The value for this key needs to be a ``CIImage`` instance where white pixels
    /// represent the areas where a person's teeth are found in the image.
    /// The image will be converted to monochrome before it is saved to the JPEG or HEIF.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagerepresentationsemanticsegmentationteethmatteimage?language=objc)
    pub static kCIImageRepresentationSemanticSegmentationTeethMatteImage:
        &'static CIImageRepresentationOption;
}

extern "C" {
    /// An optional key and value to save a skin segmentation channel to a JPEG or HEIF.
    ///
    /// The value for this key needs to be a ``CIImage`` instance where white pixels
    /// represent the areas where a person's glasses are found in the image.
    /// The image will be converted to monochrome before it is saved to the JPEG or HEIF.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagerepresentationsemanticsegmentationglassesmatteimage?language=objc)
    pub static kCIImageRepresentationSemanticSegmentationGlassesMatteImage:
        &'static CIImageRepresentationOption;
}

extern "C" {
    /// An optional key and value to save a skin segmentation channel to a JPEG or HEIF.
    ///
    /// The value for this key needs to be a ``CIImage`` instance where white pixels
    /// represent the areas where a person's skin are found in the image.
    /// The image will be converted to monochrome before it is saved to the JPEG or HEIF.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagerepresentationsemanticsegmentationskymatteimage?language=objc)
    pub static kCIImageRepresentationSemanticSegmentationSkyMatteImage:
        &'static CIImageRepresentationOption;
}

extern "C" {
    /// An optional key and value to save a HDR image using the gain map channel to a JPEG or HEIF.
    ///
    /// The value for this key needs to be a HDR CIImage instance.
    ///
    /// When provided, Core Image will calculate a gain map auxiliary image
    /// from the ratio of the HDR image to the primary SDR image.
    ///
    /// If the the HDR ``CIImage`` instance has a ``/CIImage/contentHeadroom`` property,
    /// then that will be used when calculating the HDRGainMap image and metadata.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagerepresentationhdrimage?language=objc)
    pub static kCIImageRepresentationHDRImage: &'static CIImageRepresentationOption;
}

extern "C" {
    /// An optional key and value to save a gain map channel to a JPEG or HEIF.
    ///
    /// The value for this key needs to be a monochrome ``CIImage`` instance.
    ///
    /// If the ``kCIImageRepresentationHDRGainMapAsRGB`` option it true, then it needs to
    /// be an RGB ``CIImage`` instance.
    ///
    /// The ``/CIImage/properties`` should contain metadata information equivalent to what is returned when
    /// initializing an image using ``kCIImageAuxiliaryHDRGainMap``.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagerepresentationhdrgainmapimage?language=objc)
    pub static kCIImageRepresentationHDRGainMapImage: &'static CIImageRepresentationOption;
}

extern "C" {
    /// An optional key and value to request the gain map channel to be color instead of monochrome.
    ///
    /// This key affects how the gain map image is calculated from the SDR receiver and
    /// the ``kCIImageRepresentationHDRImage`` image value.
    ///
    /// The value for this is a Boolean where:
    /// * True: the gain map is created as a color ratio between the HDR and SDR images.
    /// * False: the gain map is created as a brightness ratio between the HDR and SDR images.
    /// * Not specified: the default behavior False.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimagerepresentationhdrgainmapasrgb?language=objc)
    pub static kCIImageRepresentationHDRGainMapAsRGB: &'static CIImageRepresentationOption;
}

/// ImageRepresentation.
impl CIContext {
    extern_methods!(
        #[cfg(all(feature = "CIImage", feature = "objc2-core-graphics"))]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(TIFFRepresentationOfImage:format:colorSpace:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn TIFFRepresentationOfImage_format_colorSpace_options(
            &self,
            image: &CIImage,
            format: CIFormat,
            color_space: &CGColorSpace,
            options: &NSDictionary<CIImageRepresentationOption, AnyObject>,
        ) -> Option<Retained<NSData>>;

        #[cfg(all(feature = "CIImage", feature = "objc2-core-graphics"))]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(JPEGRepresentationOfImage:colorSpace:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn JPEGRepresentationOfImage_colorSpace_options(
            &self,
            image: &CIImage,
            color_space: &CGColorSpace,
            options: &NSDictionary<CIImageRepresentationOption, AnyObject>,
        ) -> Option<Retained<NSData>>;

        #[cfg(all(feature = "CIImage", feature = "objc2-core-graphics"))]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(HEIFRepresentationOfImage:format:colorSpace:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn HEIFRepresentationOfImage_format_colorSpace_options(
            &self,
            image: &CIImage,
            format: CIFormat,
            color_space: &CGColorSpace,
            options: &NSDictionary<CIImageRepresentationOption, AnyObject>,
        ) -> Option<Retained<NSData>>;

        #[cfg(all(feature = "CIImage", feature = "objc2-core-graphics"))]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(HEIF10RepresentationOfImage:colorSpace:options:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn HEIF10RepresentationOfImage_colorSpace_options_error(
            &self,
            image: &CIImage,
            color_space: &CGColorSpace,
            options: &NSDictionary<CIImageRepresentationOption, AnyObject>,
        ) -> Result<Retained<NSData>, Retained<NSError>>;

        #[cfg(all(feature = "CIImage", feature = "objc2-core-graphics"))]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(PNGRepresentationOfImage:format:colorSpace:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn PNGRepresentationOfImage_format_colorSpace_options(
            &self,
            image: &CIImage,
            format: CIFormat,
            color_space: &CGColorSpace,
            options: &NSDictionary<CIImageRepresentationOption, AnyObject>,
        ) -> Option<Retained<NSData>>;

        #[cfg(feature = "CIImage")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(OpenEXRRepresentationOfImage:options:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn OpenEXRRepresentationOfImage_options_error(
            &self,
            image: &CIImage,
            options: &NSDictionary<CIImageRepresentationOption, AnyObject>,
        ) -> Result<Retained<NSData>, Retained<NSError>>;

        #[cfg(all(feature = "CIImage", feature = "objc2-core-graphics"))]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(writeTIFFRepresentationOfImage:toURL:format:colorSpace:options:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeTIFFRepresentationOfImage_toURL_format_colorSpace_options_error(
            &self,
            image: &CIImage,
            url: &NSURL,
            format: CIFormat,
            color_space: &CGColorSpace,
            options: &NSDictionary<CIImageRepresentationOption, AnyObject>,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "CIImage", feature = "objc2-core-graphics"))]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(writePNGRepresentationOfImage:toURL:format:colorSpace:options:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn writePNGRepresentationOfImage_toURL_format_colorSpace_options_error(
            &self,
            image: &CIImage,
            url: &NSURL,
            format: CIFormat,
            color_space: &CGColorSpace,
            options: &NSDictionary<CIImageRepresentationOption, AnyObject>,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "CIImage", feature = "objc2-core-graphics"))]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(writeJPEGRepresentationOfImage:toURL:colorSpace:options:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeJPEGRepresentationOfImage_toURL_colorSpace_options_error(
            &self,
            image: &CIImage,
            url: &NSURL,
            color_space: &CGColorSpace,
            options: &NSDictionary<CIImageRepresentationOption, AnyObject>,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "CIImage", feature = "objc2-core-graphics"))]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(writeHEIFRepresentationOfImage:toURL:format:colorSpace:options:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeHEIFRepresentationOfImage_toURL_format_colorSpace_options_error(
            &self,
            image: &CIImage,
            url: &NSURL,
            format: CIFormat,
            color_space: &CGColorSpace,
            options: &NSDictionary<CIImageRepresentationOption, AnyObject>,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "CIImage", feature = "objc2-core-graphics"))]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(writeHEIF10RepresentationOfImage:toURL:colorSpace:options:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeHEIF10RepresentationOfImage_toURL_colorSpace_options_error(
            &self,
            image: &CIImage,
            url: &NSURL,
            color_space: &CGColorSpace,
            options: &NSDictionary<CIImageRepresentationOption, AnyObject>,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(feature = "CIImage")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(writeOpenEXRRepresentationOfImage:toURL:options:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeOpenEXRRepresentationOfImage_toURL_options_error(
            &self,
            image: &CIImage,
            url: &NSURL,
            options: &NSDictionary<CIImageRepresentationOption, AnyObject>,
        ) -> Result<(), Retained<NSError>>;
    );
}

/// CIDepthBlurEffect.
impl CIContext {
    extern_methods!(
        #[cfg(feature = "CIFilter")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(depthBlurEffectFilterForImageURL:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn depthBlurEffectFilterForImageURL_options(
            &self,
            url: &NSURL,
            options: Option<&NSDictionary>,
        ) -> Option<Retained<CIFilter>>;

        #[cfg(feature = "CIFilter")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(depthBlurEffectFilterForImageData:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn depthBlurEffectFilterForImageData_options(
            &self,
            data: &NSData,
            options: Option<&NSDictionary>,
        ) -> Option<Retained<CIFilter>>;

        #[cfg(all(feature = "CIFilter", feature = "CIImage", feature = "objc2-image-io"))]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(depthBlurEffectFilterForImage:disparityImage:portraitEffectsMatte:orientation:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn depthBlurEffectFilterForImage_disparityImage_portraitEffectsMatte_orientation_options(
            &self,
            image: &CIImage,
            disparity_image: &CIImage,
            portrait_effects_matte: Option<&CIImage>,
            orientation: CGImagePropertyOrientation,
            options: Option<&NSDictionary>,
        ) -> Option<Retained<CIFilter>>;

        #[cfg(all(feature = "CIFilter", feature = "CIImage", feature = "objc2-image-io"))]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(depthBlurEffectFilterForImage:disparityImage:portraitEffectsMatte:hairSemanticSegmentation:orientation:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn depthBlurEffectFilterForImage_disparityImage_portraitEffectsMatte_hairSemanticSegmentation_orientation_options(
            &self,
            image: &CIImage,
            disparity_image: &CIImage,
            portrait_effects_matte: Option<&CIImage>,
            hair_semantic_segmentation: Option<&CIImage>,
            orientation: CGImagePropertyOrientation,
            options: Option<&NSDictionary>,
        ) -> Option<Retained<CIFilter>>;

        #[cfg(all(feature = "CIFilter", feature = "CIImage", feature = "objc2-image-io"))]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(depthBlurEffectFilterForImage:disparityImage:portraitEffectsMatte:hairSemanticSegmentation:glassesMatte:gainMap:orientation:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn depthBlurEffectFilterForImage_disparityImage_portraitEffectsMatte_hairSemanticSegmentation_glassesMatte_gainMap_orientation_options(
            &self,
            image: &CIImage,
            disparity_image: &CIImage,
            portrait_effects_matte: Option<&CIImage>,
            hair_semantic_segmentation: Option<&CIImage>,
            glasses_matte: Option<&CIImage>,
            gain_map: Option<&CIImage>,
            orientation: CGImagePropertyOrientation,
            options: Option<&NSDictionary>,
        ) -> Option<Retained<CIFilter>>;
    );
}
