/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.groovy.tools.Utilities;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.testing.Test;
import org.gradle.util.GradleVersion;
import org.javamodularity.moduleplugin.TestEngine;
import org.javamodularity.moduleplugin.extensions.PatchModuleContainer;
import org.javamodularity.moduleplugin.extensions.TestModuleOptions;
import org.javamodularity.moduleplugin.internal.TaskOption;
import org.javamodularity.moduleplugin.tasks.AbstractModulePluginTask;
import org.javamodularity.moduleplugin.tasks.ModuleInfoTestHelper;

public class TestTask
extends AbstractModulePluginTask {
    private static final Logger LOGGER = Logging.getLogger(TestTask.class);
    private static final Pattern CLASS_FILE_SPLITTER = Pattern.compile("[./\\\\]");

    public TestTask(Project project) {
        super(project);
    }

    public void configureTestJava() {
        this.helper().findTask("test", Test.class).ifPresent(this::configureTestJava);
    }

    private void configureTestJava(final Test testJava) {
        final TestModuleOptions testModuleOptions = (TestModuleOptions)testJava.getExtensions().create("moduleOptions", TestModuleOptions.class, new Object[]{this.project});
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) >= 0) {
            testJava.getModularity().getInferModulePath().set((Object)false);
        }
        testJava.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                if (testModuleOptions.getRunOnClasspath()) {
                    LOGGER.lifecycle("Running tests on classpath");
                    return;
                }
                List<String> args = TestTask.this.buildJvmArgs(testJava, testModuleOptions);
                testJava.setJvmArgs(args);
                LOGGER.info("jvmArgs for task {}: {}", (Object)task.getName(), args);
                testJava.setClasspath((FileCollection)TestTask.this.project.files(new Object[0]));
            }
        });
    }

    private List<String> buildJvmArgs(Test testJava, TestModuleOptions testModuleOptions) {
        ArrayList<String> jvmArgs = new ArrayList<String>(testJava.getJvmArgs());
        FileCollection classpath = this.mergeClassesHelper().getMergeAdjustedClasspath(testJava.getClasspath());
        PatchModuleContainer patchModuleContainer = PatchModuleContainer.copyOf(this.helper().modularityExtension().optionContainer().getPatchModuleContainer());
        String moduleName = this.helper().moduleName();
        this.buildPatchModulePathStream().forEach(path -> patchModuleContainer.addDir(moduleName, path.toString()));
        patchModuleContainer.buildModulePathOption(classpath).ifPresent(option -> option.mutateArgs(jvmArgs));
        patchModuleContainer.mutator(classpath).mutateArgs(jvmArgs);
        new TaskOption("--add-modules", "ALL-MODULE-PATH").mutateArgs(jvmArgs);
        testModuleOptions.mutateArgs(jvmArgs);
        TestEngine.selectMultiple(this.project, classpath.getFiles()).forEach(testEngine -> {
            this.buildAddReadsOption((TestEngine)((Object)testEngine)).mutateArgs(jvmArgs);
            this.buildAddOpensOptionStream((TestEngine)((Object)testEngine)).forEach(option -> option.mutateArgs(jvmArgs));
            testEngine.additionalTaskOptions.forEach(option -> option.mutateArgs(jvmArgs));
        });
        ModuleInfoTestHelper.mutateArgs(this.project, false, jvmArgs::add);
        return jvmArgs;
    }

    private Stream<Path> buildPatchModulePathStream() {
        SourceSet mainSourceSet = this.helper().mainSourceSet();
        SourceSet testSourceSet = this.helper().testSourceSet();
        Optional<SourceSet> testFixturesSourceSet = this.helper().findTestFixturesSourceSet();
        ArrayList<SourceSet> classesSourceSets = new ArrayList<SourceSet>();
        classesSourceSets.add(testSourceSet);
        testFixturesSourceSet.ifPresent(classesSourceSets::add);
        ArrayList<SourceSet> sourceSets = new ArrayList<SourceSet>();
        sourceSets.add(mainSourceSet);
        sourceSets.addAll(classesSourceSets);
        Stream<Path> classesFileStream = classesSourceSets.stream().flatMap(sourceSet -> sourceSet.getOutput().getClassesDirs().getFiles().stream()).map(File::toPath);
        Stream<Path> resourceFileStream = sourceSets.stream().map(sourceSet -> sourceSet.getOutput().getResourcesDir()).filter(Objects::nonNull).map(File::toPath).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
        Stream<Path> additionalResourceFileStream = sourceSets.stream().flatMap(sourceSet -> sourceSet.getOutput().getDirs().getFiles().stream()).map(File::toPath).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
        return Stream.concat(Stream.concat(classesFileStream, resourceFileStream), additionalResourceFileStream);
    }

    private TaskOption buildAddReadsOption(TestEngine testEngine) {
        String moduleName = this.helper().moduleName();
        return new TaskOption("--add-reads", moduleName + "=" + testEngine.moduleName);
    }

    private Stream<TaskOption> buildAddOpensOptionStream(TestEngine testEngine) {
        String moduleName = this.helper().moduleName();
        Set testDirs = this.helper().testSourceSet().getOutput().getClassesDirs().getFiles();
        return TestTask.getPackages(testDirs).stream().map(packageName -> String.format("%s/%s=%s", moduleName, packageName, testEngine.addOpens)).map(value -> new TaskOption("--add-opens", (String)value));
    }

    private static Set<String> getPackages(Collection<File> dirs) {
        Set packages = dirs.stream().peek(dir -> LOGGER.debug("Scanning packages in " + dir)).map(File::toPath).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(TestTask::buildRelativePathStream).map(relPath -> relPath.toString().replace(File.separatorChar, '.')).collect(Collectors.toCollection(TreeSet::new));
        LOGGER.debug("Found packages: " + packages);
        return packages;
    }

    private static Stream<Path> buildRelativePathStream(Path dir) {
        try {
            return Files.walk(dir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> TestTask.isValidClassFileReference(path.toString())).map(path -> dir.relativize(path.getParent()));
        }
        catch (IOException e) {
            throw new GradleException("Failed to scan " + dir, (Throwable)e);
        }
    }

    private static boolean isValidClassFileReference(String path) {
        if (!path.endsWith(".class")) {
            return false;
        }
        String name = path.substring(0, path.length() - ".class".length());
        String[] tokens = CLASS_FILE_SPLITTER.split(name);
        if (tokens.length == 0) {
            return false;
        }
        return Utilities.isJavaIdentifier((String)tokens[tokens.length - 1]);
    }
}

