/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.skins.StripViewSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import javafx.util.Duration;

public class StripView<T>
extends Control {
    private static final int DEFAULT_FADING_SIZE = 120;
    private final BooleanProperty alwaysCenter = new SimpleBooleanProperty((Object)this, "alwaysCenter", true);
    private DoubleProperty fadingSize;
    private final BooleanProperty autoScrolling = new SimpleBooleanProperty((Object)this, "autoScrolling", true);
    private final BooleanProperty animateScrolling = new SimpleBooleanProperty((Object)this, "animateScrolling", true);
    private final ObjectProperty<Duration> animationDuration = new SimpleObjectProperty((Object)this, "animationDuration", (Object)Duration.millis((double)200.0));
    public final ObjectProperty<T> selectedItem = new SimpleObjectProperty((Object)this, "selectedItem");
    private final ListProperty<T> items = new SimpleListProperty((Object)this, "items", FXCollections.observableArrayList());
    private final ObjectProperty<Callback<StripView<T>, StripCell<T>>> cellFactory = new SimpleObjectProperty((Object)this, "cellFactory");
    private final BooleanProperty loopSelection = new SimpleBooleanProperty((Object)this, "loopSelection", true);

    public StripView() {
        this.getStyleClass().add((Object)"strip-view");
        this.setPrefWidth(400.0);
        this.setPrefHeight(50.0);
        this.setFocusTraversable(false);
        this.setCellFactory(strip -> new StripCell());
        this.selectedItemProperty().addListener(it -> {
            if (this.getSelectedItem() != null && this.isAutoScrolling()) {
                this.scrollTo(this.getSelectedItem());
                this.requestLayout();
            }
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new StripViewSkin(this);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(StripView.class.getResource("strip-view.css")).toExternalForm();
    }

    public final boolean isAlwaysCenter() {
        return this.alwaysCenter.get();
    }

    public final BooleanProperty alwaysCenterProperty() {
        return this.alwaysCenter;
    }

    public final void setAlwaysCenter(boolean alwaysCenter) {
        this.alwaysCenter.set(alwaysCenter);
    }

    public final double getFadingSize() {
        return this.fadingSize == null ? 120.0 : this.fadingSize.get();
    }

    public final DoubleProperty fadingSizeProperty() {
        if (this.fadingSize == null) {
            this.fadingSize = new StyleableDoubleProperty(120.0){

                public Object getBean() {
                    return StripView.this;
                }

                public String getName() {
                    return "fadingSize";
                }

                public CssMetaData<? extends Styleable, Number> getCssMetaData() {
                    return StyleableProperties.FADING_SIZE;
                }
            };
        }
        return this.fadingSize;
    }

    public final void setFadingSize(double fadingSize) {
        this.fadingSizeProperty().set(fadingSize);
    }

    public final BooleanProperty autoScrollingProperty() {
        return this.autoScrolling;
    }

    public final boolean isAutoScrolling() {
        return this.autoScrolling.get();
    }

    public final void setAutoScrolling(boolean autoScrolling) {
        this.autoScrolling.set(autoScrolling);
    }

    public final BooleanProperty animateScrollingProperty() {
        return this.animateScrolling;
    }

    public final boolean isAnimateScrolling() {
        return this.animateScrolling.get();
    }

    public final void setAnimateScrolling(boolean animateScrolling) {
        this.animateScrolling.set(animateScrolling);
    }

    public final ObjectProperty<Duration> animationDurationProperty() {
        return this.animationDuration;
    }

    public final Duration getAnimationDuration() {
        return (Duration)this.animationDuration.get();
    }

    public final void setAnimationDuration(Duration animationDuration) {
        this.animationDuration.set((Object)animationDuration);
    }

    public final ObjectProperty<T> selectedItemProperty() {
        return this.selectedItem;
    }

    public final T getSelectedItem() {
        return (T)this.selectedItemProperty().get();
    }

    public final void setSelectedItem(T selectedItem) {
        this.selectedItemProperty().set(selectedItem);
    }

    public final ListProperty<T> itemsProperty() {
        return this.items;
    }

    public final ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    public final void setItems(ObservableList<T> items) {
        this.items.set(items);
    }

    public final Callback<StripView<T>, StripCell<T>> getCellFactory() {
        return (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<StripView<T>, StripCell<T>>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final void setCellFactory(Callback<StripView<T>, StripCell<T>> cellFactory) {
        this.cellFactory.set(cellFactory);
    }

    public void scrollTo(T item) {
        this.getProperties().put((Object)"scroll.to", item);
    }

    public final boolean isLoopSelection() {
        return this.loopSelection.get();
    }

    public final void setLoopSelection(boolean value) {
        this.loopSelection.set(value);
    }

    public final BooleanProperty loopSelectionProperty() {
        return this.loopSelection;
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return StripView.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<StripView, Number> FADING_SIZE = new CssMetaData<StripView, Number>("-fx-fading-size", SizeConverter.getInstance(), (Number)120){

            public StyleableProperty<Number> getStyleableProperty(StripView control) {
                return (StyleableProperty)control.fadingSizeProperty();
            }

            public boolean isSettable(StripView control) {
                return control.fadingSize == null || !control.fadingSize.isBound();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<StripView, Number>> styleables = new ArrayList<CssMetaData<StripView, Number>>(Control.getClassCssMetaData());
            styleables.add(FADING_SIZE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static class StripCell<T>
    extends Label {
        private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass((String)"selected");
        private final InvalidationListener selectionListener = it -> this.updateSelection();
        private final WeakInvalidationListener weakSelectionListener = new WeakInvalidationListener(this.selectionListener);
        private final ObjectProperty<StripView<T>> stripView = new SimpleObjectProperty((Object)this, "stripView");
        private BooleanProperty selected;
        private final ObjectProperty<T> item = new SimpleObjectProperty((Object)this, "item");

        public StripCell() {
            this.getStyleClass().add((Object)"strip-cell");
            this.setMaxWidth(Double.MAX_VALUE);
            this.setMaxHeight(Double.MAX_VALUE);
            this.stripViewProperty().addListener((it, oldStrip, newStrip) -> {
                if (oldStrip != null) {
                    oldStrip.selectedItemProperty().removeListener((InvalidationListener)this.weakSelectionListener);
                }
                if (newStrip != null) {
                    newStrip.selectedItemProperty().addListener((InvalidationListener)this.weakSelectionListener);
                    this.updateSelection();
                }
            });
            this.itemProperty().addListener(it -> {
                this.setText(this.getItem() == null ? "" : this.getItem().toString());
                this.updateSelection();
            });
        }

        private void updateSelection() {
            T selectedItem = this.getStripView().getSelectedItem();
            this.setSelected(selectedItem == this.getItem());
        }

        public final ObjectProperty<StripView<T>> stripViewProperty() {
            return this.stripView;
        }

        public final StripView<T> getStripView() {
            return (StripView)((Object)this.stripView.get());
        }

        public final void setStripView(StripView<T> stripView) {
            this.stripView.set(stripView);
        }

        public final void setSelected(boolean value) {
            this.selectedProperty().set(value);
        }

        public final boolean isSelected() {
            return this.selected != null && this.selected.get();
        }

        public final BooleanProperty selectedProperty() {
            if (this.selected == null) {
                this.selected = new BooleanPropertyBase(){

                    protected void invalidated() {
                        boolean selected = this.get();
                        this.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, selected);
                        this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTED);
                    }

                    public Object getBean() {
                        return this;
                    }

                    public String getName() {
                        return "selected";
                    }
                };
            }
            return this.selected;
        }

        public final T getItem() {
            return (T)this.item.get();
        }

        public final ObjectProperty<T> itemProperty() {
            return this.item;
        }

        public final void setItem(T item) {
            this.item.set(item);
        }
    }
}

