mark_as_advanced(TLEXPECTED_INCLUDE_DIR)

if(DEP_TLEXPECTED STREQUAL "BUNDLED")
  message(STATUS "Using bundled TlExpected as requested")
else()
  find_path(TLEXPECTED_INCLUDE_DIR tl/expected.hpp)
  if(TLEXPECTED_INCLUDE_DIR)
    file(READ "${TLEXPECTED_INCLUDE_DIR}/tl/expected.hpp" _tlexpected_h)
    string(REGEX MATCH "#define TL_EXPECTED_VERSION_MAJOR ([0-9]+).*#define TL_EXPECTED_VERSION_MINOR ([0-9]+).*#define TL_EXPECTED_VERSION_PATCH ([0-9]+)" _ "${_tlexpected_h}")
    set(_tlexpected_version_string "${CMAKE_MATCH_1}.${CMAKE_MATCH_2}.${CMAKE_MATCH_3}")
    if(NOT "${CMAKE_MATCH_0}" STREQUAL "" AND "${_tlexpected_version_string}" VERSION_GREATER_EQUAL "${TlExpected_FIND_VERSION}")
      message(STATUS "Using system TlExpected (${TLEXPECTED_INCLUDE_DIR}/tl/expected.hpp)")
      add_library(dep_tlexpected INTERFACE IMPORTED)
      target_include_directories(dep_tlexpected INTERFACE "${TLEXPECTED_INCLUDE_DIR}")
      register_dependency(TlExpected "SYSTEM (${TLEXPECTED_INCLUDE_DIR}/tl/expected.hpp)" "${_tlexpected_version_string}")
    endif()
  endif()
  if(NOT TARGET dep_tlexpected)
    message(STATUS "Using bundled TlExpected since TlExpected>=${TlExpected_FIND_VERSION} was not found locally")
  endif()
endif()
