package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAccountConfig invokes the sgw.DescribeAccountConfig API synchronously
func (client *Client) DescribeAccountConfig(request *DescribeAccountConfigRequest) (response *DescribeAccountConfigResponse, err error) {
	response = CreateDescribeAccountConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAccountConfigWithChan invokes the sgw.DescribeAccountConfig API asynchronously
func (client *Client) DescribeAccountConfigWithChan(request *DescribeAccountConfigRequest) (<-chan *DescribeAccountConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeAccountConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAccountConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAccountConfigWithCallback invokes the sgw.DescribeAccountConfig API asynchronously
func (client *Client) DescribeAccountConfigWithCallback(request *DescribeAccountConfigRequest, callback func(response *DescribeAccountConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAccountConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeAccountConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAccountConfigRequest is the request struct for api DescribeAccountConfig
type DescribeAccountConfigRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// DescribeAccountConfigResponse is the response struct for api DescribeAccountConfig
type DescribeAccountConfigResponse struct {
	*responses.BaseResponse
	RequestId                     string `json:"RequestId" xml:"RequestId"`
	Success                       bool   `json:"Success" xml:"Success"`
	Code                          string `json:"Code" xml:"Code"`
	Message                       string `json:"Message" xml:"Message"`
	IsSupportServerSideEncryption bool   `json:"IsSupportServerSideEncryption" xml:"IsSupportServerSideEncryption"`
	IsSupportClientSideEncryption bool   `json:"IsSupportClientSideEncryption" xml:"IsSupportClientSideEncryption"`
	IsSupportGatewayLogging       bool   `json:"IsSupportGatewayLogging" xml:"IsSupportGatewayLogging"`
	IsSupportElasticGatewayBeta   bool   `json:"IsSupportElasticGatewayBeta" xml:"IsSupportElasticGatewayBeta"`
}

// CreateDescribeAccountConfigRequest creates a request to invoke DescribeAccountConfig API
func CreateDescribeAccountConfigRequest() (request *DescribeAccountConfigRequest) {
	request = &DescribeAccountConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeAccountConfig", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAccountConfigResponse creates a response to parse from DescribeAccountConfig response
func CreateDescribeAccountConfigResponse() (response *DescribeAccountConfigResponse) {
	response = &DescribeAccountConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
