package schedulerx2

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchDisableJobs invokes the schedulerx2.BatchDisableJobs API synchronously
func (client *Client) BatchDisableJobs(request *BatchDisableJobsRequest) (response *BatchDisableJobsResponse, err error) {
	response = CreateBatchDisableJobsResponse()
	err = client.DoAction(request, response)
	return
}

// BatchDisableJobsWithChan invokes the schedulerx2.BatchDisableJobs API asynchronously
func (client *Client) BatchDisableJobsWithChan(request *BatchDisableJobsRequest) (<-chan *BatchDisableJobsResponse, <-chan error) {
	responseChan := make(chan *BatchDisableJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchDisableJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchDisableJobsWithCallback invokes the schedulerx2.BatchDisableJobs API asynchronously
func (client *Client) BatchDisableJobsWithCallback(request *BatchDisableJobsRequest, callback func(response *BatchDisableJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchDisableJobsResponse
		var err error
		defer close(result)
		response, err = client.BatchDisableJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchDisableJobsRequest is the request struct for api BatchDisableJobs
type BatchDisableJobsRequest struct {
	*requests.RpcRequest
	NamespaceSource string    `position:"Query" name:"NamespaceSource"`
	GroupId         string    `position:"Query" name:"GroupId"`
	JobIdList       *[]string `position:"Body" name:"JobIdList"  type:"Repeated"`
	Namespace       string    `position:"Query" name:"Namespace"`
}

// BatchDisableJobsResponse is the response struct for api BatchDisableJobs
type BatchDisableJobsResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateBatchDisableJobsRequest creates a request to invoke BatchDisableJobs API
func CreateBatchDisableJobsRequest() (request *BatchDisableJobsRequest) {
	request = &BatchDisableJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("schedulerx2", "2019-04-30", "BatchDisableJobs", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchDisableJobsResponse creates a response to parse from BatchDisableJobs response
func CreateBatchDisableJobsResponse() (response *BatchDisableJobsResponse) {
	response = &BatchDisableJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
