package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDomainPvUvData invokes the live.DescribeLiveDomainPvUvData API synchronously
func (client *Client) DescribeLiveDomainPvUvData(request *DescribeLiveDomainPvUvDataRequest) (response *DescribeLiveDomainPvUvDataResponse, err error) {
	response = CreateDescribeLiveDomainPvUvDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDomainPvUvDataWithChan invokes the live.DescribeLiveDomainPvUvData API asynchronously
func (client *Client) DescribeLiveDomainPvUvDataWithChan(request *DescribeLiveDomainPvUvDataRequest) (<-chan *DescribeLiveDomainPvUvDataResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDomainPvUvDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDomainPvUvData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDomainPvUvDataWithCallback invokes the live.DescribeLiveDomainPvUvData API asynchronously
func (client *Client) DescribeLiveDomainPvUvDataWithCallback(request *DescribeLiveDomainPvUvDataRequest, callback func(response *DescribeLiveDomainPvUvDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDomainPvUvDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDomainPvUvData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDomainPvUvDataRequest is the request struct for api DescribeLiveDomainPvUvData
type DescribeLiveDomainPvUvDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveDomainPvUvDataResponse is the response struct for api DescribeLiveDomainPvUvData
type DescribeLiveDomainPvUvDataResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	DomainName    string        `json:"DomainName" xml:"DomainName"`
	StartTime     string        `json:"StartTime" xml:"StartTime"`
	EndTime       string        `json:"EndTime" xml:"EndTime"`
	DataInterval  string        `json:"DataInterval" xml:"DataInterval"`
	PvUvDataInfos PvUvDataInfos `json:"PvUvDataInfos" xml:"PvUvDataInfos"`
}

// CreateDescribeLiveDomainPvUvDataRequest creates a request to invoke DescribeLiveDomainPvUvData API
func CreateDescribeLiveDomainPvUvDataRequest() (request *DescribeLiveDomainPvUvDataRequest) {
	request = &DescribeLiveDomainPvUvDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDomainPvUvData", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveDomainPvUvDataResponse creates a response to parse from DescribeLiveDomainPvUvData response
func CreateDescribeLiveDomainPvUvDataResponse() (response *DescribeLiveDomainPvUvDataResponse) {
	response = &DescribeLiveDomainPvUvDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
