package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchGetDeviceBindStatus invokes the iot.BatchGetDeviceBindStatus API synchronously
func (client *Client) BatchGetDeviceBindStatus(request *BatchGetDeviceBindStatusRequest) (response *BatchGetDeviceBindStatusResponse, err error) {
	response = CreateBatchGetDeviceBindStatusResponse()
	err = client.DoAction(request, response)
	return
}

// BatchGetDeviceBindStatusWithChan invokes the iot.BatchGetDeviceBindStatus API asynchronously
func (client *Client) BatchGetDeviceBindStatusWithChan(request *BatchGetDeviceBindStatusRequest) (<-chan *BatchGetDeviceBindStatusResponse, <-chan error) {
	responseChan := make(chan *BatchGetDeviceBindStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchGetDeviceBindStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchGetDeviceBindStatusWithCallback invokes the iot.BatchGetDeviceBindStatus API asynchronously
func (client *Client) BatchGetDeviceBindStatusWithCallback(request *BatchGetDeviceBindStatusRequest, callback func(response *BatchGetDeviceBindStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchGetDeviceBindStatusResponse
		var err error
		defer close(result)
		response, err = client.BatchGetDeviceBindStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchGetDeviceBindStatusRequest is the request struct for api BatchGetDeviceBindStatus
type BatchGetDeviceBindStatusRequest struct {
	*requests.RpcRequest
	IotIds        *[]string `position:"Query" name:"IotIds"  type:"Repeated"`
	IotInstanceId string    `position:"Query" name:"IotInstanceId"`
	ApiProduct    string    `position:"Body" name:"ApiProduct"`
	ApiRevision   string    `position:"Body" name:"ApiRevision"`
}

// BatchGetDeviceBindStatusResponse is the response struct for api BatchGetDeviceBindStatus
type BatchGetDeviceBindStatusResponse struct {
	*responses.BaseResponse
	RequestId    string         `json:"RequestId" xml:"RequestId"`
	Success      bool           `json:"Success" xml:"Success"`
	Code         string         `json:"Code" xml:"Code"`
	ErrorMessage string         `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         []DeviceStatus `json:"Data" xml:"Data"`
}

// CreateBatchGetDeviceBindStatusRequest creates a request to invoke BatchGetDeviceBindStatus API
func CreateBatchGetDeviceBindStatusRequest() (request *BatchGetDeviceBindStatusRequest) {
	request = &BatchGetDeviceBindStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchGetDeviceBindStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchGetDeviceBindStatusResponse creates a response to parse from BatchGetDeviceBindStatus response
func CreateBatchGetDeviceBindStatusResponse() (response *BatchGetDeviceBindStatusResponse) {
	response = &BatchGetDeviceBindStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
