package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableSqlAudit invokes the drds.EnableSqlAudit API synchronously
func (client *Client) EnableSqlAudit(request *EnableSqlAuditRequest) (response *EnableSqlAuditResponse, err error) {
	response = CreateEnableSqlAuditResponse()
	err = client.DoAction(request, response)
	return
}

// EnableSqlAuditWithChan invokes the drds.EnableSqlAudit API asynchronously
func (client *Client) EnableSqlAuditWithChan(request *EnableSqlAuditRequest) (<-chan *EnableSqlAuditResponse, <-chan error) {
	responseChan := make(chan *EnableSqlAuditResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableSqlAudit(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableSqlAuditWithCallback invokes the drds.EnableSqlAudit API asynchronously
func (client *Client) EnableSqlAuditWithCallback(request *EnableSqlAuditRequest, callback func(response *EnableSqlAuditResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableSqlAuditResponse
		var err error
		defer close(result)
		response, err = client.EnableSqlAudit(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableSqlAuditRequest is the request struct for api EnableSqlAudit
type EnableSqlAuditRequest struct {
	*requests.RpcRequest
	RecallStartTimestamp string           `position:"Query" name:"RecallStartTimestamp"`
	DrdsInstanceId       string           `position:"Query" name:"DrdsInstanceId"`
	DbName               string           `position:"Query" name:"DbName"`
	IsRecall             requests.Boolean `position:"Query" name:"IsRecall"`
	RecallEndTimestamp   string           `position:"Query" name:"RecallEndTimestamp"`
}

// EnableSqlAuditResponse is the response struct for api EnableSqlAudit
type EnableSqlAuditResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateEnableSqlAuditRequest creates a request to invoke EnableSqlAudit API
func CreateEnableSqlAuditRequest() (request *EnableSqlAuditRequest) {
	request = &EnableSqlAuditRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "EnableSqlAudit", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableSqlAuditResponse creates a response to parse from EnableSqlAudit response
func CreateEnableSqlAuditResponse() (response *EnableSqlAuditResponse) {
	response = &EnableSqlAuditResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
