package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSimpleDomains invokes the ddoscoo.DescribeSimpleDomains API synchronously
func (client *Client) DescribeSimpleDomains(request *DescribeSimpleDomainsRequest) (response *DescribeSimpleDomainsResponse, err error) {
	response = CreateDescribeSimpleDomainsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSimpleDomainsWithChan invokes the ddoscoo.DescribeSimpleDomains API asynchronously
func (client *Client) DescribeSimpleDomainsWithChan(request *DescribeSimpleDomainsRequest) (<-chan *DescribeSimpleDomainsResponse, <-chan error) {
	responseChan := make(chan *DescribeSimpleDomainsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSimpleDomains(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSimpleDomainsWithCallback invokes the ddoscoo.DescribeSimpleDomains API asynchronously
func (client *Client) DescribeSimpleDomainsWithCallback(request *DescribeSimpleDomainsRequest, callback func(response *DescribeSimpleDomainsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSimpleDomainsResponse
		var err error
		defer close(result)
		response, err = client.DescribeSimpleDomains(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSimpleDomainsRequest is the request struct for api DescribeSimpleDomains
type DescribeSimpleDomainsRequest struct {
	*requests.RpcRequest
	ResourceGroupId string    `position:"Query" name:"ResourceGroupId"`
	SourceIp        string    `position:"Query" name:"SourceIp"`
	InstanceIds     *[]string `position:"Query" name:"InstanceIds"  type:"Repeated"`
	Lang            string    `position:"Query" name:"Lang"`
}

// DescribeSimpleDomainsResponse is the response struct for api DescribeSimpleDomains
type DescribeSimpleDomainsResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	DomainList []string `json:"DomainList" xml:"DomainList"`
}

// CreateDescribeSimpleDomainsRequest creates a request to invoke DescribeSimpleDomains API
func CreateDescribeSimpleDomainsRequest() (request *DescribeSimpleDomainsRequest) {
	request = &DescribeSimpleDomainsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "DescribeSimpleDomains", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeSimpleDomainsResponse creates a response to parse from DescribeSimpleDomains response
func CreateDescribeSimpleDomainsResponse() (response *DescribeSimpleDomainsResponse) {
	response = &DescribeSimpleDomainsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
