package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainQps invokes the ddoscoo.DescribeDomainQps API synchronously
func (client *Client) DescribeDomainQps(request *DescribeDomainQpsRequest) (response *DescribeDomainQpsResponse, err error) {
	response = CreateDescribeDomainQpsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainQpsWithChan invokes the ddoscoo.DescribeDomainQps API asynchronously
func (client *Client) DescribeDomainQpsWithChan(request *DescribeDomainQpsRequest) (<-chan *DescribeDomainQpsResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainQpsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainQps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainQpsWithCallback invokes the ddoscoo.DescribeDomainQps API asynchronously
func (client *Client) DescribeDomainQpsWithCallback(request *DescribeDomainQpsRequest, callback func(response *DescribeDomainQpsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainQpsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainQps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainQpsRequest is the request struct for api DescribeDomainQps
type DescribeDomainQpsRequest struct {
	*requests.RpcRequest
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Domain          string           `position:"Query" name:"Domain"`
}

// DescribeDomainQpsResponse is the response struct for api DescribeDomainQps
type DescribeDomainQpsResponse struct {
	*responses.BaseResponse
	RequestId     string   `json:"RequestId" xml:"RequestId"`
	Interval      int      `json:"Interval" xml:"Interval"`
	StartTime     int64    `json:"StartTime" xml:"StartTime"`
	Totals        []string `json:"Totals" xml:"Totals"`
	Blocks        []string `json:"Blocks" xml:"Blocks"`
	CacheHits     []string `json:"CacheHits" xml:"CacheHits"`
	PreciseBlocks []string `json:"PreciseBlocks" xml:"PreciseBlocks"`
	RegionBlocks  []string `json:"RegionBlocks" xml:"RegionBlocks"`
	IpBlockQps    []string `json:"IpBlockQps" xml:"IpBlockQps"`
	CcJsQps       []string `json:"CcJsQps" xml:"CcJsQps"`
	PreciseJsQps  []string `json:"PreciseJsQps" xml:"PreciseJsQps"`
	CcBlockQps    []string `json:"CcBlockQps" xml:"CcBlockQps"`
}

// CreateDescribeDomainQpsRequest creates a request to invoke DescribeDomainQps API
func CreateDescribeDomainQpsRequest() (request *DescribeDomainQpsRequest) {
	request = &DescribeDomainQpsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "DescribeDomainQps", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainQpsResponse creates a response to parse from DescribeDomainQps response
func CreateDescribeDomainQpsResponse() (response *DescribeDomainQpsResponse) {
	response = &DescribeDomainQpsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
