package security

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// SQLVulnerabilityAssessmentBaselineRulesClient is the API spec for Microsoft.Security (Azure Security Center)
// resource provider
type SQLVulnerabilityAssessmentBaselineRulesClient struct {
	BaseClient
}

// NewSQLVulnerabilityAssessmentBaselineRulesClient creates an instance of the
// SQLVulnerabilityAssessmentBaselineRulesClient client.
func NewSQLVulnerabilityAssessmentBaselineRulesClient(subscriptionID string, ascLocation string) SQLVulnerabilityAssessmentBaselineRulesClient {
	return NewSQLVulnerabilityAssessmentBaselineRulesClientWithBaseURI(DefaultBaseURI, subscriptionID, ascLocation)
}

// NewSQLVulnerabilityAssessmentBaselineRulesClientWithBaseURI creates an instance of the
// SQLVulnerabilityAssessmentBaselineRulesClient client using a custom endpoint.  Use this when interacting with an
// Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewSQLVulnerabilityAssessmentBaselineRulesClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) SQLVulnerabilityAssessmentBaselineRulesClient {
	return SQLVulnerabilityAssessmentBaselineRulesClient{NewWithBaseURI(baseURI, subscriptionID, ascLocation)}
}

// Add sends the add request.
// Parameters:
// workspaceID - the workspace Id.
// APIVersion - the api version.
// resourceID - the identifier of the resource.
// body - the baseline rules.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) Add(ctx context.Context, workspaceID string, APIVersion string, resourceID string, body *RulesResultsInput) (result RulesResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLVulnerabilityAssessmentBaselineRulesClient.Add")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddPreparer(ctx, workspaceID, APIVersion, resourceID, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentBaselineRulesClient", "Add", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentBaselineRulesClient", "Add", resp, "Failure sending request")
		return
	}

	result, err = client.AddResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentBaselineRulesClient", "Add", resp, "Failure responding to request")
		return
	}

	return
}

// AddPreparer prepares the Add request.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) AddPreparer(ctx context.Context, workspaceID string, APIVersion string, resourceID string, body *RulesResultsInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceId": resourceID,
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"workspaceId": autorest.Encode("query", workspaceID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if body != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(body))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddSender sends the Add request. The method will close the
// http.Response Body if it receives an error.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) AddSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddResponder handles the response to the Add request. The method always
// closes the http.Response Body.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) AddResponder(resp *http.Response) (result RulesResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate sends the create or update request.
// Parameters:
// ruleID - the rule Id.
// workspaceID - the workspace Id.
// APIVersion - the api version.
// resourceID - the identifier of the resource.
// body - the baseline results for this rule.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) CreateOrUpdate(ctx context.Context, ruleID string, workspaceID string, APIVersion string, resourceID string, body *RuleResultsInput) (result RuleResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLVulnerabilityAssessmentBaselineRulesClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdatePreparer(ctx, ruleID, workspaceID, APIVersion, resourceID, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentBaselineRulesClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentBaselineRulesClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentBaselineRulesClient", "CreateOrUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) CreateOrUpdatePreparer(ctx context.Context, ruleID string, workspaceID string, APIVersion string, resourceID string, body *RuleResultsInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceId": resourceID,
		"ruleId":     autorest.Encode("path", ruleID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"workspaceId": autorest.Encode("query", workspaceID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if body != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(body))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) CreateOrUpdateResponder(resp *http.Response) (result RuleResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete sends the delete request.
// Parameters:
// ruleID - the rule Id.
// workspaceID - the workspace Id.
// APIVersion - the api version.
// resourceID - the identifier of the resource.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) Delete(ctx context.Context, ruleID string, workspaceID string, APIVersion string, resourceID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLVulnerabilityAssessmentBaselineRulesClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, ruleID, workspaceID, APIVersion, resourceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentBaselineRulesClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentBaselineRulesClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentBaselineRulesClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) DeletePreparer(ctx context.Context, ruleID string, workspaceID string, APIVersion string, resourceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceId": resourceID,
		"ruleId":     autorest.Encode("path", ruleID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"workspaceId": autorest.Encode("query", workspaceID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get sends the get request.
// Parameters:
// ruleID - the rule Id.
// workspaceID - the workspace Id.
// APIVersion - the api version.
// resourceID - the identifier of the resource.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) Get(ctx context.Context, ruleID string, workspaceID string, APIVersion string, resourceID string) (result RuleResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLVulnerabilityAssessmentBaselineRulesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, ruleID, workspaceID, APIVersion, resourceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentBaselineRulesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentBaselineRulesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentBaselineRulesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) GetPreparer(ctx context.Context, ruleID string, workspaceID string, APIVersion string, resourceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceId": resourceID,
		"ruleId":     autorest.Encode("path", ruleID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"workspaceId": autorest.Encode("query", workspaceID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) GetResponder(resp *http.Response) (result RuleResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List sends the list request.
// Parameters:
// workspaceID - the workspace Id.
// APIVersion - the api version.
// resourceID - the identifier of the resource.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) List(ctx context.Context, workspaceID string, APIVersion string, resourceID string) (result RulesResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLVulnerabilityAssessmentBaselineRulesClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListPreparer(ctx, workspaceID, APIVersion, resourceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentBaselineRulesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentBaselineRulesClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentBaselineRulesClient", "List", resp, "Failure responding to request")
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) ListPreparer(ctx context.Context, workspaceID string, APIVersion string, resourceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceId": resourceID,
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"workspaceId": autorest.Encode("query", workspaceID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client SQLVulnerabilityAssessmentBaselineRulesClient) ListResponder(resp *http.Response) (result RulesResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
