//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicontextmenuconfigurationelementorder?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIContextMenuConfigurationElementOrder(pub NSInteger);
impl UIContextMenuConfigurationElementOrder {
    #[doc(alias = "UIContextMenuConfigurationElementOrderAutomatic")]
    pub const Automatic: Self = Self(0);
    /// Allows the system to choose the appropriate ordering strategy for the current context.
    #[doc(alias = "UIContextMenuConfigurationElementOrderPriority")]
    pub const Priority: Self = Self(1);
    /// Order menu elements according to priority. Keeping the first element in the UIMenu closest to user's interaction point.
    #[doc(alias = "UIContextMenuConfigurationElementOrderFixed")]
    pub const Fixed: Self = Self(2);
}

unsafe impl Encode for UIContextMenuConfigurationElementOrder {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIContextMenuConfigurationElementOrder {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Return a UIAction-based UIMenu describing the desired action hierarchy.
///
///
/// Parameter `suggestedActions`: An array of suggested actions gathered from the UIResponder chain. You may choose to include
/// some of these actions in the hierarchy returned from this block to display them in the resulting menu.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicontextmenuactionprovider?language=objc)
#[cfg(all(feature = "UIMenu", feature = "UIMenuElement", feature = "block2"))]
pub type UIContextMenuActionProvider =
    *mut block2::DynBlock<dyn Fn(NonNull<NSArray<UIMenuElement>>) -> *mut UIMenu>;

/// Return a UIViewController to be displayed as this menu's preview component.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicontextmenucontentpreviewprovider?language=objc)
#[cfg(all(
    feature = "UIResponder",
    feature = "UIViewController",
    feature = "block2"
))]
pub type UIContextMenuContentPreviewProvider =
    *mut block2::DynBlock<dyn Fn() -> *mut UIViewController>;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicontextmenuconfiguration?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIContextMenuConfiguration;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIContextMenuConfiguration {}
);

impl UIContextMenuConfiguration {
    extern_methods!(
        /// This configuration's identifier. When representing multiple items in your app, this identifier
        /// corresponds to the primary item (i.e. the one with which the user interacted when invoking the menu).
        #[unsafe(method(identifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn identifier(&self) -> Retained<ProtocolObject<dyn NSCopying>>;

        /// When this menu acts on multiple items, you may include the identifiers of secondary items to display a multi-item menu.
        #[unsafe(method(secondaryItemIdentifiers))]
        #[unsafe(method_family = none)]
        pub unsafe fn secondaryItemIdentifiers(
            &self,
        ) -> Retained<NSSet<ProtocolObject<dyn NSCopying>>>;

        /// Setter for [`secondaryItemIdentifiers`][Self::secondaryItemIdentifiers].
        #[unsafe(method(setSecondaryItemIdentifiers:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSecondaryItemIdentifiers(
            &self,
            secondary_item_identifiers: &NSSet<ProtocolObject<dyn NSCopying>>,
        );

        /// Number of items on which this menu acts. Used to badge a multi-item menu's preview stack.
        /// When unset, this value is determined automatically by the system. Values lower than 2 hide the badge.
        #[unsafe(method(badgeCount))]
        #[unsafe(method_family = none)]
        pub unsafe fn badgeCount(&self) -> NSInteger;

        /// Setter for [`badgeCount`][Self::badgeCount].
        #[unsafe(method(setBadgeCount:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBadgeCount(&self, badge_count: NSInteger);

        /// Preferred menu element ordering strategy for this menu.
        #[unsafe(method(preferredMenuElementOrder))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredMenuElementOrder(&self) -> UIContextMenuConfigurationElementOrder;

        /// Setter for [`preferredMenuElementOrder`][Self::preferredMenuElementOrder].
        #[unsafe(method(setPreferredMenuElementOrder:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreferredMenuElementOrder(
            &self,
            preferred_menu_element_order: UIContextMenuConfigurationElementOrder,
        );

        #[cfg(all(
            feature = "UIMenu",
            feature = "UIMenuElement",
            feature = "UIResponder",
            feature = "UIViewController",
            feature = "block2"
        ))]
        /// Returns a UIContextMenuConfiguration.
        ///
        ///
        /// Parameter `identifier`: Optional unique identifier. If omitted, an NSUUID will be generated. May be used to
        /// identify this configuration throughout the interaction's lifecycle.
        ///
        /// Parameter `previewProvider`: Optional preview view controller provider block, called when the menu is about to be presented.
        ///
        /// Parameter `actionProvider`: Optional action provider block, called when the menu is about to be presented.
        #[unsafe(method(configurationWithIdentifier:previewProvider:actionProvider:))]
        #[unsafe(method_family = none)]
        pub unsafe fn configurationWithIdentifier_previewProvider_actionProvider(
            identifier: Option<&ProtocolObject<dyn NSCopying>>,
            preview_provider: UIContextMenuContentPreviewProvider,
            action_provider: UIContextMenuActionProvider,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UIContextMenuConfiguration {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
