#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 149
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 47
#define ALIAS_COUNT 0
#define TOKEN_COUNT 21
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 1

enum {
  sym_raw_string_literal = 1,
  anon_sym_DQUOTE = 2,
  aux_sym_interpreted_string_literal_token1 = 3,
  sym_escape_sequence = 4,
  sym__identifier = 5,
  anon_sym_module = 6,
  anon_sym_LPAREN = 7,
  anon_sym_LF = 8,
  anon_sym_RPAREN = 9,
  anon_sym_go = 10,
  anon_sym_require = 11,
  anon_sym_exclude = 12,
  anon_sym_replace = 13,
  anon_sym_EQ_GT = 14,
  anon_sym_retract = 15,
  anon_sym_LBRACK = 16,
  anon_sym_COMMA = 17,
  anon_sym_RBRACK = 18,
  anon_sym_SLASH_SLASH = 19,
  aux_sym_comment_token1 = 20,
  sym_source_file = 21,
  sym__directive = 22,
  sym__string_literal = 23,
  sym_interpreted_string_literal = 24,
  sym__string_or_ident = 25,
  sym_module_path = 26,
  sym_go_version = 27,
  sym_version = 28,
  sym_module_directive = 29,
  sym_go_directive = 30,
  sym_require_directive = 31,
  sym_require_spec = 32,
  sym_exclude_directive = 33,
  sym_exclude_spec = 34,
  sym_replace_directive = 35,
  sym_replace_spec = 36,
  sym_file_path = 37,
  sym_retract_directive = 38,
  sym_retract_spec = 39,
  sym_comment = 40,
  aux_sym_source_file_repeat1 = 41,
  aux_sym_interpreted_string_literal_repeat1 = 42,
  aux_sym_require_directive_repeat1 = 43,
  aux_sym_exclude_directive_repeat1 = 44,
  aux_sym_replace_directive_repeat1 = 45,
  aux_sym_retract_directive_repeat1 = 46,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_raw_string_literal] = "raw_string_literal",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_interpreted_string_literal_token1] = "interpreted_string_literal_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym__identifier] = "_identifier",
  [anon_sym_module] = "module",
  [anon_sym_LPAREN] = "(",
  [anon_sym_LF] = "\n",
  [anon_sym_RPAREN] = ")",
  [anon_sym_go] = "go",
  [anon_sym_require] = "require",
  [anon_sym_exclude] = "exclude",
  [anon_sym_replace] = "replace",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_retract] = "retract",
  [anon_sym_LBRACK] = "[",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACK] = "]",
  [anon_sym_SLASH_SLASH] = "//",
  [aux_sym_comment_token1] = "comment_token1",
  [sym_source_file] = "source_file",
  [sym__directive] = "_directive",
  [sym__string_literal] = "_string_literal",
  [sym_interpreted_string_literal] = "interpreted_string_literal",
  [sym__string_or_ident] = "_string_or_ident",
  [sym_module_path] = "module_path",
  [sym_go_version] = "go_version",
  [sym_version] = "version",
  [sym_module_directive] = "module_directive",
  [sym_go_directive] = "go_directive",
  [sym_require_directive] = "require_directive",
  [sym_require_spec] = "require_spec",
  [sym_exclude_directive] = "exclude_directive",
  [sym_exclude_spec] = "exclude_spec",
  [sym_replace_directive] = "replace_directive",
  [sym_replace_spec] = "replace_spec",
  [sym_file_path] = "file_path",
  [sym_retract_directive] = "retract_directive",
  [sym_retract_spec] = "retract_spec",
  [sym_comment] = "comment",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_interpreted_string_literal_repeat1] = "interpreted_string_literal_repeat1",
  [aux_sym_require_directive_repeat1] = "require_directive_repeat1",
  [aux_sym_exclude_directive_repeat1] = "exclude_directive_repeat1",
  [aux_sym_replace_directive_repeat1] = "replace_directive_repeat1",
  [aux_sym_retract_directive_repeat1] = "retract_directive_repeat1",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_raw_string_literal] = sym_raw_string_literal,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_interpreted_string_literal_token1] = aux_sym_interpreted_string_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__identifier] = sym__identifier,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_go] = anon_sym_go,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_exclude] = anon_sym_exclude,
  [anon_sym_replace] = anon_sym_replace,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_retract] = anon_sym_retract,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [sym_source_file] = sym_source_file,
  [sym__directive] = sym__directive,
  [sym__string_literal] = sym__string_literal,
  [sym_interpreted_string_literal] = sym_interpreted_string_literal,
  [sym__string_or_ident] = sym__string_or_ident,
  [sym_module_path] = sym_module_path,
  [sym_go_version] = sym_go_version,
  [sym_version] = sym_version,
  [sym_module_directive] = sym_module_directive,
  [sym_go_directive] = sym_go_directive,
  [sym_require_directive] = sym_require_directive,
  [sym_require_spec] = sym_require_spec,
  [sym_exclude_directive] = sym_exclude_directive,
  [sym_exclude_spec] = sym_exclude_spec,
  [sym_replace_directive] = sym_replace_directive,
  [sym_replace_spec] = sym_replace_spec,
  [sym_file_path] = sym_file_path,
  [sym_retract_directive] = sym_retract_directive,
  [sym_retract_spec] = sym_retract_spec,
  [sym_comment] = sym_comment,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_interpreted_string_literal_repeat1] = aux_sym_interpreted_string_literal_repeat1,
  [aux_sym_require_directive_repeat1] = aux_sym_require_directive_repeat1,
  [aux_sym_exclude_directive_repeat1] = aux_sym_exclude_directive_repeat1,
  [aux_sym_replace_directive_repeat1] = aux_sym_replace_directive_repeat1,
  [aux_sym_retract_directive_repeat1] = aux_sym_retract_directive_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_string_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_go] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exclude] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_replace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_retract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__directive] = {
    .visible = false,
    .named = true,
  },
  [sym__string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_interpreted_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__string_or_ident] = {
    .visible = false,
    .named = true,
  },
  [sym_module_path] = {
    .visible = true,
    .named = true,
  },
  [sym_go_version] = {
    .visible = true,
    .named = true,
  },
  [sym_version] = {
    .visible = true,
    .named = true,
  },
  [sym_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_go_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_require_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_require_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_exclude_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_exclude_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_replace_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_replace_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_file_path] = {
    .visible = true,
    .named = true,
  },
  [sym_retract_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_retract_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_require_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_exclude_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_replace_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_retract_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(48);
      if (lookahead == '"') ADVANCE(51);
      if (lookahead == '(') ADVANCE(64);
      if (lookahead == ')') ADVANCE(67);
      if (lookahead == ',') ADVANCE(77);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '=') ADVANCE(10);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == ']') ADVANCE(78);
      if (lookahead == '`') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(38);
      if (lookahead == 'g') ADVANCE(29);
      if (lookahead == 'm') ADVANCE(30);
      if (lookahead == 'r') ADVANCE(20);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(47)
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(66);
      if (lookahead == '"') ADVANCE(52);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == '`') ADVANCE(61);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(62);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(66);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(4)
      if (lookahead == '"') ADVANCE(51);
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(53);
      if (lookahead != 0) ADVANCE(55);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(51);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(52);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '`') ADVANCE(61);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != ']') ADVANCE(62);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(52);
      if (lookahead == ')') ADVANCE(68);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '`') ADVANCE(61);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != ']') ADVANCE(62);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(52);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == '=') ADVANCE(60);
      if (lookahead == '`') ADVANCE(61);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(62);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(52);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == '`') ADVANCE(61);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(62);
      END_STATE();
    case 9:
      if (lookahead == '/') ADVANCE(79);
      END_STATE();
    case 10:
      if (lookahead == '>') ADVANCE(73);
      END_STATE();
    case 11:
      if (lookahead == 'U') ADVANCE(46);
      if (lookahead == 'u') ADVANCE(42);
      if (lookahead == 'x') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      if (lookahead != 0) ADVANCE(56);
      END_STATE();
    case 12:
      if (lookahead == '`') ADVANCE(49);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(17);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(16);
      END_STATE();
    case 15:
      if (lookahead == 'c') ADVANCE(28);
      END_STATE();
    case 16:
      if (lookahead == 'c') ADVANCE(34);
      END_STATE();
    case 17:
      if (lookahead == 'c') ADVANCE(23);
      END_STATE();
    case 18:
      if (lookahead == 'd') ADVANCE(37);
      END_STATE();
    case 19:
      if (lookahead == 'd') ADVANCE(22);
      END_STATE();
    case 20:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(63);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(71);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 25:
      if (lookahead == 'i') ADVANCE(32);
      END_STATE();
    case 26:
      if (lookahead == 'l') ADVANCE(13);
      END_STATE();
    case 27:
      if (lookahead == 'l') ADVANCE(21);
      END_STATE();
    case 28:
      if (lookahead == 'l') ADVANCE(36);
      END_STATE();
    case 29:
      if (lookahead == 'o') ADVANCE(69);
      END_STATE();
    case 30:
      if (lookahead == 'o') ADVANCE(18);
      END_STATE();
    case 31:
      if (lookahead == 'p') ADVANCE(26);
      if (lookahead == 'q') ADVANCE(35);
      if (lookahead == 't') ADVANCE(33);
      END_STATE();
    case 32:
      if (lookahead == 'r') ADVANCE(24);
      END_STATE();
    case 33:
      if (lookahead == 'r') ADVANCE(14);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(25);
      END_STATE();
    case 36:
      if (lookahead == 'u') ADVANCE(19);
      END_STATE();
    case 37:
      if (lookahead == 'u') ADVANCE(27);
      END_STATE();
    case 38:
      if (lookahead == 'x') ADVANCE(15);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(41);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 47:
      if (eof) ADVANCE(48);
      if (lookahead == '"') ADVANCE(51);
      if (lookahead == '(') ADVANCE(64);
      if (lookahead == ')') ADVANCE(67);
      if (lookahead == ',') ADVANCE(77);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '=') ADVANCE(10);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(78);
      if (lookahead == '`') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(38);
      if (lookahead == 'g') ADVANCE(29);
      if (lookahead == 'm') ADVANCE(30);
      if (lookahead == 'r') ADVANCE(20);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(47)
      END_STATE();
    case 48:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_raw_string_literal);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_raw_string_literal);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(62);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(62);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(53);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(55);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead == '/') ADVANCE(55);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(55);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(55);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(56);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(57);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '/') ADVANCE(80);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(62);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '>') ADVANCE(74);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(62);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '`') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == ',' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(12);
      if (lookahead != 0) ADVANCE(61);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(62);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(62);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(62);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_go);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_require);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_exclude);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_replace);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(62);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_retract);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(62);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(84);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '/') ADVANCE(83);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(82);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(84);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(84);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(84);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 6},
  [5] = {.lex_state = 6},
  [6] = {.lex_state = 6},
  [7] = {.lex_state = 6},
  [8] = {.lex_state = 6},
  [9] = {.lex_state = 6},
  [10] = {.lex_state = 5},
  [11] = {.lex_state = 6},
  [12] = {.lex_state = 6},
  [13] = {.lex_state = 6},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 6},
  [16] = {.lex_state = 0},
  [17] = {.lex_state = 0},
  [18] = {.lex_state = 0},
  [19] = {.lex_state = 6},
  [20] = {.lex_state = 6},
  [21] = {.lex_state = 5},
  [22] = {.lex_state = 5},
  [23] = {.lex_state = 5},
  [24] = {.lex_state = 8},
  [25] = {.lex_state = 8},
  [26] = {.lex_state = 7},
  [27] = {.lex_state = 8},
  [28] = {.lex_state = 8},
  [29] = {.lex_state = 7},
  [30] = {.lex_state = 5},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 8},
  [35] = {.lex_state = 8},
  [36] = {.lex_state = 8},
  [37] = {.lex_state = 8},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 8},
  [40] = {.lex_state = 8},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 8},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 8},
  [46] = {.lex_state = 8},
  [47] = {.lex_state = 8},
  [48] = {.lex_state = 0},
  [49] = {.lex_state = 0},
  [50] = {.lex_state = 0},
  [51] = {.lex_state = 8},
  [52] = {.lex_state = 8},
  [53] = {.lex_state = 0},
  [54] = {.lex_state = 0},
  [55] = {.lex_state = 0},
  [56] = {.lex_state = 0},
  [57] = {.lex_state = 0},
  [58] = {.lex_state = 0},
  [59] = {.lex_state = 0},
  [60] = {.lex_state = 0},
  [61] = {.lex_state = 0},
  [62] = {.lex_state = 0},
  [63] = {.lex_state = 0},
  [64] = {.lex_state = 0},
  [65] = {.lex_state = 0},
  [66] = {.lex_state = 0},
  [67] = {.lex_state = 8},
  [68] = {.lex_state = 0},
  [69] = {.lex_state = 8},
  [70] = {.lex_state = 6},
  [71] = {.lex_state = 6},
  [72] = {.lex_state = 6},
  [73] = {.lex_state = 6},
  [74] = {.lex_state = 7},
  [75] = {.lex_state = 6},
  [76] = {.lex_state = 6},
  [77] = {.lex_state = 1},
  [78] = {.lex_state = 3},
  [79] = {.lex_state = 3},
  [80] = {.lex_state = 3},
  [81] = {.lex_state = 3},
  [82] = {.lex_state = 3},
  [83] = {.lex_state = 3},
  [84] = {.lex_state = 7},
  [85] = {.lex_state = 3},
  [86] = {.lex_state = 7},
  [87] = {.lex_state = 7},
  [88] = {.lex_state = 6},
  [89] = {.lex_state = 6},
  [90] = {.lex_state = 6},
  [91] = {.lex_state = 7},
  [92] = {.lex_state = 6},
  [93] = {.lex_state = 6},
  [94] = {.lex_state = 3},
  [95] = {.lex_state = 3},
  [96] = {.lex_state = 8},
  [97] = {.lex_state = 8},
  [98] = {.lex_state = 8},
  [99] = {.lex_state = 8},
  [100] = {.lex_state = 8},
  [101] = {.lex_state = 3},
  [102] = {.lex_state = 0},
  [103] = {.lex_state = 2},
  [104] = {.lex_state = 2},
  [105] = {.lex_state = 2},
  [106] = {.lex_state = 2},
  [107] = {.lex_state = 2},
  [108] = {.lex_state = 2},
  [109] = {.lex_state = 2},
  [110] = {.lex_state = 2},
  [111] = {.lex_state = 0},
  [112] = {.lex_state = 2},
  [113] = {.lex_state = 0},
  [114] = {.lex_state = 2},
  [115] = {.lex_state = 2},
  [116] = {.lex_state = 2},
  [117] = {.lex_state = 2},
  [118] = {.lex_state = 0},
  [119] = {.lex_state = 2},
  [120] = {.lex_state = 2},
  [121] = {.lex_state = 2},
  [122] = {.lex_state = 2},
  [123] = {.lex_state = 2},
  [124] = {.lex_state = 2},
  [125] = {.lex_state = 2},
  [126] = {.lex_state = 2},
  [127] = {.lex_state = 2},
  [128] = {.lex_state = 2},
  [129] = {.lex_state = 2},
  [130] = {.lex_state = 2},
  [131] = {.lex_state = 2},
  [132] = {.lex_state = 2},
  [133] = {.lex_state = 2},
  [134] = {.lex_state = 82},
  [135] = {.lex_state = 0},
  [136] = {.lex_state = 2},
  [137] = {.lex_state = 2},
  [138] = {.lex_state = 2},
  [139] = {.lex_state = 2},
  [140] = {.lex_state = 2},
  [141] = {.lex_state = 0},
  [142] = {.lex_state = 2},
  [143] = {.lex_state = 0},
  [144] = {.lex_state = 2},
  [145] = {.lex_state = 0},
  [146] = {.lex_state = 2},
  [147] = {.lex_state = 0},
  [148] = {(TSStateId)(-1)},
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_raw_string_literal] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_go] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_exclude] = ACTIONS(1),
    [anon_sym_replace] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_retract] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(141),
    [sym__directive] = STATE(44),
    [sym_module_directive] = STATE(49),
    [sym_go_directive] = STATE(49),
    [sym_require_directive] = STATE(49),
    [sym_exclude_directive] = STATE(49),
    [sym_replace_directive] = STATE(49),
    [sym_retract_directive] = STATE(49),
    [sym_comment] = STATE(1),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(7),
    [anon_sym_go] = ACTIONS(9),
    [anon_sym_require] = ACTIONS(11),
    [anon_sym_exclude] = ACTIONS(13),
    [anon_sym_replace] = ACTIONS(15),
    [anon_sym_retract] = ACTIONS(17),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 11,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(19), 1,
      ts_builtin_sym_end,
    ACTIONS(21), 1,
      anon_sym_module,
    ACTIONS(24), 1,
      anon_sym_go,
    ACTIONS(27), 1,
      anon_sym_require,
    ACTIONS(30), 1,
      anon_sym_exclude,
    ACTIONS(33), 1,
      anon_sym_replace,
    ACTIONS(36), 1,
      anon_sym_retract,
    STATE(44), 1,
      sym__directive,
    STATE(2), 2,
      sym_comment,
      aux_sym_source_file_repeat1,
    STATE(49), 6,
      sym_module_directive,
      sym_go_directive,
      sym_require_directive,
      sym_exclude_directive,
      sym_replace_directive,
      sym_retract_directive,
  [40] = 12,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(7), 1,
      anon_sym_module,
    ACTIONS(9), 1,
      anon_sym_go,
    ACTIONS(11), 1,
      anon_sym_require,
    ACTIONS(13), 1,
      anon_sym_exclude,
    ACTIONS(15), 1,
      anon_sym_replace,
    ACTIONS(17), 1,
      anon_sym_retract,
    ACTIONS(39), 1,
      ts_builtin_sym_end,
    STATE(2), 1,
      aux_sym_source_file_repeat1,
    STATE(3), 1,
      sym_comment,
    STATE(44), 1,
      sym__directive,
    STATE(49), 6,
      sym_module_directive,
      sym_go_directive,
      sym_require_directive,
      sym_exclude_directive,
      sym_replace_directive,
      sym_retract_directive,
  [82] = 13,
    ACTIONS(41), 1,
      sym_raw_string_literal,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      sym__identifier,
    ACTIONS(47), 1,
      anon_sym_RPAREN,
    ACTIONS(49), 1,
      anon_sym_LBRACK,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(4), 1,
      sym_comment,
    STATE(5), 1,
      aux_sym_retract_directive_repeat1,
    STATE(72), 1,
      sym_retract_spec,
    STATE(109), 1,
      sym_interpreted_string_literal,
    STATE(125), 1,
      sym_version,
    STATE(126), 1,
      sym__string_literal,
    STATE(139), 1,
      sym__string_or_ident,
  [122] = 13,
    ACTIONS(41), 1,
      sym_raw_string_literal,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      sym__identifier,
    ACTIONS(49), 1,
      anon_sym_LBRACK,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(53), 1,
      anon_sym_RPAREN,
    STATE(5), 1,
      sym_comment,
    STATE(6), 1,
      aux_sym_retract_directive_repeat1,
    STATE(72), 1,
      sym_retract_spec,
    STATE(109), 1,
      sym_interpreted_string_literal,
    STATE(125), 1,
      sym_version,
    STATE(126), 1,
      sym__string_literal,
    STATE(139), 1,
      sym__string_or_ident,
  [162] = 12,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(55), 1,
      sym_raw_string_literal,
    ACTIONS(58), 1,
      anon_sym_DQUOTE,
    ACTIONS(61), 1,
      sym__identifier,
    ACTIONS(64), 1,
      anon_sym_RPAREN,
    ACTIONS(66), 1,
      anon_sym_LBRACK,
    STATE(72), 1,
      sym_retract_spec,
    STATE(109), 1,
      sym_interpreted_string_literal,
    STATE(125), 1,
      sym_version,
    STATE(126), 1,
      sym__string_literal,
    STATE(139), 1,
      sym__string_or_ident,
    STATE(6), 2,
      sym_comment,
      aux_sym_retract_directive_repeat1,
  [200] = 12,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(69), 1,
      sym_raw_string_literal,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      sym__identifier,
    ACTIONS(75), 1,
      anon_sym_RPAREN,
    STATE(7), 1,
      sym_comment,
    STATE(15), 1,
      aux_sym_require_directive_repeat1,
    STATE(47), 1,
      sym_module_path,
    STATE(73), 1,
      sym_require_spec,
    STATE(96), 1,
      sym_interpreted_string_literal,
    STATE(97), 1,
      sym__string_literal,
    STATE(100), 1,
      sym__string_or_ident,
  [237] = 12,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(69), 1,
      sym_raw_string_literal,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      sym__identifier,
    ACTIONS(77), 1,
      anon_sym_RPAREN,
    STATE(8), 1,
      sym_comment,
    STATE(13), 1,
      aux_sym_exclude_directive_repeat1,
    STATE(46), 1,
      sym_module_path,
    STATE(92), 1,
      sym_exclude_spec,
    STATE(96), 1,
      sym_interpreted_string_literal,
    STATE(97), 1,
      sym__string_literal,
    STATE(100), 1,
      sym__string_or_ident,
  [274] = 12,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(69), 1,
      sym_raw_string_literal,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      sym__identifier,
    ACTIONS(79), 1,
      anon_sym_RPAREN,
    STATE(8), 1,
      aux_sym_exclude_directive_repeat1,
    STATE(9), 1,
      sym_comment,
    STATE(46), 1,
      sym_module_path,
    STATE(92), 1,
      sym_exclude_spec,
    STATE(96), 1,
      sym_interpreted_string_literal,
    STATE(97), 1,
      sym__string_literal,
    STATE(100), 1,
      sym__string_or_ident,
  [311] = 12,
    ACTIONS(41), 1,
      sym_raw_string_literal,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      sym__identifier,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_LBRACK,
    STATE(10), 1,
      sym_comment,
    STATE(48), 1,
      sym_retract_spec,
    STATE(109), 1,
      sym_interpreted_string_literal,
    STATE(126), 1,
      sym__string_literal,
    STATE(138), 1,
      sym_version,
    STATE(139), 1,
      sym__string_or_ident,
  [348] = 11,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(85), 1,
      sym_raw_string_literal,
    ACTIONS(88), 1,
      anon_sym_DQUOTE,
    ACTIONS(91), 1,
      sym__identifier,
    ACTIONS(94), 1,
      anon_sym_RPAREN,
    STATE(26), 1,
      sym_module_path,
    STATE(74), 1,
      sym_interpreted_string_literal,
    STATE(76), 1,
      sym_replace_spec,
    STATE(87), 1,
      sym__string_literal,
    STATE(91), 1,
      sym__string_or_ident,
    STATE(11), 2,
      sym_comment,
      aux_sym_replace_directive_repeat1,
  [383] = 12,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(96), 1,
      sym_raw_string_literal,
    ACTIONS(98), 1,
      anon_sym_DQUOTE,
    ACTIONS(100), 1,
      sym__identifier,
    ACTIONS(102), 1,
      anon_sym_RPAREN,
    STATE(11), 1,
      aux_sym_replace_directive_repeat1,
    STATE(12), 1,
      sym_comment,
    STATE(26), 1,
      sym_module_path,
    STATE(74), 1,
      sym_interpreted_string_literal,
    STATE(76), 1,
      sym_replace_spec,
    STATE(87), 1,
      sym__string_literal,
    STATE(91), 1,
      sym__string_or_ident,
  [420] = 11,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(104), 1,
      sym_raw_string_literal,
    ACTIONS(107), 1,
      anon_sym_DQUOTE,
    ACTIONS(110), 1,
      sym__identifier,
    ACTIONS(113), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym_module_path,
    STATE(92), 1,
      sym_exclude_spec,
    STATE(96), 1,
      sym_interpreted_string_literal,
    STATE(97), 1,
      sym__string_literal,
    STATE(100), 1,
      sym__string_or_ident,
    STATE(13), 2,
      sym_comment,
      aux_sym_exclude_directive_repeat1,
  [455] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(14), 1,
      sym_comment,
    ACTIONS(115), 10,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_EQ_GT,
      anon_sym_retract,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [474] = 11,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(117), 1,
      sym_raw_string_literal,
    ACTIONS(120), 1,
      anon_sym_DQUOTE,
    ACTIONS(123), 1,
      sym__identifier,
    ACTIONS(126), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym_module_path,
    STATE(73), 1,
      sym_require_spec,
    STATE(96), 1,
      sym_interpreted_string_literal,
    STATE(97), 1,
      sym__string_literal,
    STATE(100), 1,
      sym__string_or_ident,
    STATE(15), 2,
      sym_comment,
      aux_sym_require_directive_repeat1,
  [509] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(16), 1,
      sym_comment,
    ACTIONS(128), 10,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_EQ_GT,
      anon_sym_retract,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [528] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(17), 1,
      sym_comment,
    ACTIONS(130), 10,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_EQ_GT,
      anon_sym_retract,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [547] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(18), 1,
      sym_comment,
    ACTIONS(132), 10,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_EQ_GT,
      anon_sym_retract,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [566] = 12,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(96), 1,
      sym_raw_string_literal,
    ACTIONS(98), 1,
      anon_sym_DQUOTE,
    ACTIONS(100), 1,
      sym__identifier,
    ACTIONS(134), 1,
      anon_sym_RPAREN,
    STATE(12), 1,
      aux_sym_replace_directive_repeat1,
    STATE(19), 1,
      sym_comment,
    STATE(26), 1,
      sym_module_path,
    STATE(74), 1,
      sym_interpreted_string_literal,
    STATE(76), 1,
      sym_replace_spec,
    STATE(87), 1,
      sym__string_literal,
    STATE(91), 1,
      sym__string_or_ident,
  [603] = 12,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(69), 1,
      sym_raw_string_literal,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      sym__identifier,
    ACTIONS(136), 1,
      anon_sym_RPAREN,
    STATE(7), 1,
      aux_sym_require_directive_repeat1,
    STATE(20), 1,
      sym_comment,
    STATE(47), 1,
      sym_module_path,
    STATE(73), 1,
      sym_require_spec,
    STATE(96), 1,
      sym_interpreted_string_literal,
    STATE(97), 1,
      sym__string_literal,
    STATE(100), 1,
      sym__string_or_ident,
  [640] = 11,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(96), 1,
      sym_raw_string_literal,
    ACTIONS(98), 1,
      anon_sym_DQUOTE,
    ACTIONS(100), 1,
      sym__identifier,
    ACTIONS(138), 1,
      anon_sym_LPAREN,
    STATE(21), 1,
      sym_comment,
    STATE(29), 1,
      sym_module_path,
    STATE(43), 1,
      sym_replace_spec,
    STATE(74), 1,
      sym_interpreted_string_literal,
    STATE(87), 1,
      sym__string_literal,
    STATE(91), 1,
      sym__string_or_ident,
  [674] = 11,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(69), 1,
      sym_raw_string_literal,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      sym__identifier,
    ACTIONS(140), 1,
      anon_sym_LPAREN,
    STATE(22), 1,
      sym_comment,
    STATE(40), 1,
      sym_module_path,
    STATE(41), 1,
      sym_exclude_spec,
    STATE(96), 1,
      sym_interpreted_string_literal,
    STATE(97), 1,
      sym__string_literal,
    STATE(100), 1,
      sym__string_or_ident,
  [708] = 11,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(69), 1,
      sym_raw_string_literal,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(73), 1,
      sym__identifier,
    ACTIONS(142), 1,
      anon_sym_LPAREN,
    STATE(23), 1,
      sym_comment,
    STATE(37), 1,
      sym_module_path,
    STATE(38), 1,
      sym_require_spec,
    STATE(96), 1,
      sym_interpreted_string_literal,
    STATE(97), 1,
      sym__string_literal,
    STATE(100), 1,
      sym__string_or_ident,
  [742] = 10,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(69), 1,
      sym_raw_string_literal,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(144), 1,
      sym__identifier,
    STATE(24), 1,
      sym_comment,
    STATE(69), 1,
      sym_module_path,
    STATE(96), 1,
      sym_interpreted_string_literal,
    STATE(97), 1,
      sym__string_literal,
    STATE(100), 1,
      sym__string_or_ident,
    STATE(137), 1,
      sym_file_path,
  [773] = 10,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(69), 1,
      sym_raw_string_literal,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(144), 1,
      sym__identifier,
    STATE(25), 1,
      sym_comment,
    STATE(67), 1,
      sym_module_path,
    STATE(96), 1,
      sym_interpreted_string_literal,
    STATE(97), 1,
      sym__string_literal,
    STATE(100), 1,
      sym__string_or_ident,
    STATE(120), 1,
      sym_file_path,
  [804] = 10,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(146), 1,
      sym_raw_string_literal,
    ACTIONS(148), 1,
      anon_sym_DQUOTE,
    ACTIONS(150), 1,
      sym__identifier,
    ACTIONS(152), 1,
      anon_sym_EQ_GT,
    STATE(14), 1,
      sym_interpreted_string_literal,
    STATE(16), 1,
      sym__string_literal,
    STATE(26), 1,
      sym_comment,
    STATE(102), 1,
      sym__string_or_ident,
    STATE(145), 1,
      sym_version,
  [835] = 10,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(69), 1,
      sym_raw_string_literal,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(144), 1,
      sym__identifier,
    STATE(27), 1,
      sym_comment,
    STATE(42), 1,
      sym_module_path,
    STATE(96), 1,
      sym_interpreted_string_literal,
    STATE(97), 1,
      sym__string_literal,
    STATE(100), 1,
      sym__string_or_ident,
    STATE(129), 1,
      sym_file_path,
  [866] = 10,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(69), 1,
      sym_raw_string_literal,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(144), 1,
      sym__identifier,
    STATE(28), 1,
      sym_comment,
    STATE(39), 1,
      sym_module_path,
    STATE(96), 1,
      sym_interpreted_string_literal,
    STATE(97), 1,
      sym__string_literal,
    STATE(100), 1,
      sym__string_or_ident,
    STATE(130), 1,
      sym_file_path,
  [897] = 10,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(146), 1,
      sym_raw_string_literal,
    ACTIONS(148), 1,
      anon_sym_DQUOTE,
    ACTIONS(150), 1,
      sym__identifier,
    ACTIONS(154), 1,
      anon_sym_EQ_GT,
    STATE(14), 1,
      sym_interpreted_string_literal,
    STATE(16), 1,
      sym__string_literal,
    STATE(29), 1,
      sym_comment,
    STATE(102), 1,
      sym__string_or_ident,
    STATE(111), 1,
      sym_version,
  [928] = 10,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(146), 1,
      sym_raw_string_literal,
    ACTIONS(148), 1,
      anon_sym_DQUOTE,
    ACTIONS(150), 1,
      sym__identifier,
    ACTIONS(156), 1,
      anon_sym_LPAREN,
    STATE(14), 1,
      sym_interpreted_string_literal,
    STATE(16), 1,
      sym__string_literal,
    STATE(30), 1,
      sym_comment,
    STATE(33), 1,
      sym_module_path,
    STATE(61), 1,
      sym__string_or_ident,
  [959] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(31), 1,
      sym_comment,
    ACTIONS(158), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [975] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(32), 1,
      sym_comment,
    ACTIONS(160), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [991] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(33), 1,
      sym_comment,
    ACTIONS(162), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1007] = 9,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(146), 1,
      sym_raw_string_literal,
    ACTIONS(148), 1,
      anon_sym_DQUOTE,
    ACTIONS(150), 1,
      sym__identifier,
    STATE(14), 1,
      sym_interpreted_string_literal,
    STATE(16), 1,
      sym__string_literal,
    STATE(34), 1,
      sym_comment,
    STATE(102), 1,
      sym__string_or_ident,
    STATE(147), 1,
      sym_version,
  [1035] = 9,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(146), 1,
      sym_raw_string_literal,
    ACTIONS(148), 1,
      anon_sym_DQUOTE,
    ACTIONS(150), 1,
      sym__identifier,
    STATE(14), 1,
      sym_interpreted_string_literal,
    STATE(16), 1,
      sym__string_literal,
    STATE(35), 1,
      sym_comment,
    STATE(102), 1,
      sym__string_or_ident,
    STATE(143), 1,
      sym_version,
  [1063] = 9,
    ACTIONS(41), 1,
      sym_raw_string_literal,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      sym__identifier,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(36), 1,
      sym_comment,
    STATE(109), 1,
      sym_interpreted_string_literal,
    STATE(117), 1,
      sym__string_or_ident,
    STATE(122), 1,
      sym_go_version,
    STATE(126), 1,
      sym__string_literal,
  [1091] = 9,
    ACTIONS(41), 1,
      sym_raw_string_literal,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      sym__identifier,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(37), 1,
      sym_comment,
    STATE(106), 1,
      sym_version,
    STATE(109), 1,
      sym_interpreted_string_literal,
    STATE(126), 1,
      sym__string_literal,
    STATE(139), 1,
      sym__string_or_ident,
  [1119] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(38), 1,
      sym_comment,
    ACTIONS(164), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1135] = 9,
    ACTIONS(41), 1,
      sym_raw_string_literal,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      sym__identifier,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(39), 1,
      sym_comment,
    STATE(109), 1,
      sym_interpreted_string_literal,
    STATE(126), 1,
      sym__string_literal,
    STATE(131), 1,
      sym_version,
    STATE(139), 1,
      sym__string_or_ident,
  [1163] = 9,
    ACTIONS(41), 1,
      sym_raw_string_literal,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      sym__identifier,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(40), 1,
      sym_comment,
    STATE(109), 1,
      sym_interpreted_string_literal,
    STATE(110), 1,
      sym_version,
    STATE(126), 1,
      sym__string_literal,
    STATE(139), 1,
      sym__string_or_ident,
  [1191] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(41), 1,
      sym_comment,
    ACTIONS(166), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1207] = 9,
    ACTIONS(41), 1,
      sym_raw_string_literal,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      sym__identifier,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(42), 1,
      sym_comment,
    STATE(109), 1,
      sym_interpreted_string_literal,
    STATE(126), 1,
      sym__string_literal,
    STATE(130), 1,
      sym_version,
    STATE(139), 1,
      sym__string_or_ident,
  [1235] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(43), 1,
      sym_comment,
    ACTIONS(168), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1251] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(44), 1,
      sym_comment,
    ACTIONS(170), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1267] = 9,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(146), 1,
      sym_raw_string_literal,
    ACTIONS(148), 1,
      anon_sym_DQUOTE,
    ACTIONS(150), 1,
      sym__identifier,
    STATE(14), 1,
      sym_interpreted_string_literal,
    STATE(16), 1,
      sym__string_literal,
    STATE(45), 1,
      sym_comment,
    STATE(102), 1,
      sym__string_or_ident,
    STATE(113), 1,
      sym_version,
  [1295] = 9,
    ACTIONS(41), 1,
      sym_raw_string_literal,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      sym__identifier,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(46), 1,
      sym_comment,
    STATE(109), 1,
      sym_interpreted_string_literal,
    STATE(126), 1,
      sym__string_literal,
    STATE(128), 1,
      sym_version,
    STATE(139), 1,
      sym__string_or_ident,
  [1323] = 9,
    ACTIONS(41), 1,
      sym_raw_string_literal,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      sym__identifier,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(47), 1,
      sym_comment,
    STATE(109), 1,
      sym_interpreted_string_literal,
    STATE(126), 1,
      sym__string_literal,
    STATE(127), 1,
      sym_version,
    STATE(139), 1,
      sym__string_or_ident,
  [1351] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(48), 1,
      sym_comment,
    ACTIONS(172), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1367] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(49), 1,
      sym_comment,
    ACTIONS(174), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1383] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(50), 1,
      sym_comment,
    ACTIONS(176), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1399] = 9,
    ACTIONS(41), 1,
      sym_raw_string_literal,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      sym__identifier,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(51), 1,
      sym_comment,
    STATE(109), 1,
      sym_interpreted_string_literal,
    STATE(115), 1,
      sym_module_path,
    STATE(121), 1,
      sym__string_or_ident,
    STATE(126), 1,
      sym__string_literal,
  [1427] = 9,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(146), 1,
      sym_raw_string_literal,
    ACTIONS(148), 1,
      anon_sym_DQUOTE,
    ACTIONS(150), 1,
      sym__identifier,
    STATE(14), 1,
      sym_interpreted_string_literal,
    STATE(16), 1,
      sym__string_literal,
    STATE(52), 1,
      sym_comment,
    STATE(102), 1,
      sym__string_or_ident,
    STATE(118), 1,
      sym_version,
  [1455] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(53), 1,
      sym_comment,
    ACTIONS(178), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1471] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(54), 1,
      sym_comment,
    ACTIONS(180), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1487] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(55), 1,
      sym_comment,
    ACTIONS(182), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1503] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(56), 1,
      sym_comment,
    ACTIONS(184), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1519] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(57), 1,
      sym_comment,
    ACTIONS(186), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1535] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(58), 1,
      sym_comment,
    ACTIONS(188), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1551] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(59), 1,
      sym_comment,
    ACTIONS(190), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1567] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(60), 1,
      sym_comment,
    ACTIONS(192), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1583] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(61), 1,
      sym_comment,
    ACTIONS(194), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1599] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(62), 1,
      sym_comment,
    ACTIONS(196), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1615] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(63), 1,
      sym_comment,
    ACTIONS(198), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1631] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(64), 1,
      sym_comment,
    ACTIONS(200), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1647] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(65), 1,
      sym_comment,
    ACTIONS(202), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1663] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(66), 1,
      sym_comment,
    ACTIONS(204), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1679] = 9,
    ACTIONS(41), 1,
      sym_raw_string_literal,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      sym__identifier,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(67), 1,
      sym_comment,
    STATE(109), 1,
      sym_interpreted_string_literal,
    STATE(114), 1,
      sym_version,
    STATE(126), 1,
      sym__string_literal,
    STATE(139), 1,
      sym__string_or_ident,
  [1707] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(68), 1,
      sym_comment,
    ACTIONS(206), 7,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1723] = 9,
    ACTIONS(41), 1,
      sym_raw_string_literal,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      sym__identifier,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(69), 1,
      sym_comment,
    STATE(109), 1,
      sym_interpreted_string_literal,
    STATE(120), 1,
      sym_version,
    STATE(126), 1,
      sym__string_literal,
    STATE(139), 1,
      sym__string_or_ident,
  [1751] = 4,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(186), 1,
      anon_sym_LBRACK,
    STATE(70), 1,
      sym_comment,
    ACTIONS(208), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [1767] = 4,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    STATE(71), 1,
      sym_comment,
    ACTIONS(210), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [1783] = 4,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(214), 1,
      anon_sym_LBRACK,
    STATE(72), 1,
      sym_comment,
    ACTIONS(212), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [1799] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(73), 1,
      sym_comment,
    ACTIONS(216), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [1812] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(74), 1,
      sym_comment,
    ACTIONS(218), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_EQ_GT,
  [1825] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(75), 1,
      sym_comment,
    ACTIONS(220), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [1838] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(76), 1,
      sym_comment,
    ACTIONS(222), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [1851] = 4,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(226), 1,
      anon_sym_LF,
    STATE(77), 1,
      sym_comment,
    ACTIONS(224), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [1866] = 5,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(228), 1,
      anon_sym_DQUOTE,
    STATE(78), 1,
      sym_comment,
    STATE(95), 1,
      aux_sym_interpreted_string_literal_repeat1,
    ACTIONS(230), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [1883] = 5,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(232), 1,
      anon_sym_DQUOTE,
    STATE(78), 1,
      aux_sym_interpreted_string_literal_repeat1,
    STATE(79), 1,
      sym_comment,
    ACTIONS(230), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [1900] = 5,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(234), 1,
      anon_sym_DQUOTE,
    STATE(80), 1,
      sym_comment,
    STATE(95), 1,
      aux_sym_interpreted_string_literal_repeat1,
    ACTIONS(230), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [1917] = 5,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(236), 1,
      anon_sym_DQUOTE,
    STATE(80), 1,
      aux_sym_interpreted_string_literal_repeat1,
    STATE(81), 1,
      sym_comment,
    ACTIONS(230), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [1934] = 5,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(238), 1,
      anon_sym_DQUOTE,
    STATE(82), 1,
      sym_comment,
    STATE(95), 1,
      aux_sym_interpreted_string_literal_repeat1,
    ACTIONS(230), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [1951] = 5,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(240), 1,
      anon_sym_DQUOTE,
    STATE(82), 1,
      aux_sym_interpreted_string_literal_repeat1,
    STATE(83), 1,
      sym_comment,
    ACTIONS(230), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [1968] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(84), 1,
      sym_comment,
    ACTIONS(242), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_EQ_GT,
  [1981] = 5,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(244), 1,
      anon_sym_DQUOTE,
    STATE(85), 1,
      sym_comment,
    STATE(94), 1,
      aux_sym_interpreted_string_literal_repeat1,
    ACTIONS(230), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [1998] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(86), 1,
      sym_comment,
    ACTIONS(246), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_EQ_GT,
  [2011] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(87), 1,
      sym_comment,
    ACTIONS(224), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_EQ_GT,
  [2024] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(88), 1,
      sym_comment,
    ACTIONS(248), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2037] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(89), 1,
      sym_comment,
    ACTIONS(250), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2050] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(90), 1,
      sym_comment,
    ACTIONS(252), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2063] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(91), 1,
      sym_comment,
    ACTIONS(254), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_EQ_GT,
  [2076] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(92), 1,
      sym_comment,
    ACTIONS(256), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2089] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(93), 1,
      sym_comment,
    ACTIONS(258), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2102] = 5,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_DQUOTE,
    STATE(94), 1,
      sym_comment,
    STATE(95), 1,
      aux_sym_interpreted_string_literal_repeat1,
    ACTIONS(230), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2119] = 4,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(262), 1,
      anon_sym_DQUOTE,
    ACTIONS(264), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
    STATE(95), 2,
      sym_comment,
      aux_sym_interpreted_string_literal_repeat1,
  [2134] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(96), 1,
      sym_comment,
    ACTIONS(218), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [2146] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(97), 1,
      sym_comment,
    ACTIONS(224), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [2158] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(98), 1,
      sym_comment,
    ACTIONS(246), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [2170] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(99), 1,
      sym_comment,
    ACTIONS(242), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [2182] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    STATE(100), 1,
      sym_comment,
    ACTIONS(254), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [2194] = 4,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(267), 1,
      anon_sym_DQUOTE,
    STATE(101), 1,
      sym_comment,
    ACTIONS(269), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2208] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(102), 1,
      sym_comment,
    ACTIONS(271), 3,
      anon_sym_EQ_GT,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [2220] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(273), 1,
      anon_sym_LF,
    STATE(103), 1,
      sym_comment,
  [2230] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(275), 1,
      anon_sym_LF,
    STATE(104), 1,
      sym_comment,
  [2240] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(130), 1,
      anon_sym_LF,
    STATE(105), 1,
      sym_comment,
  [2250] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(277), 1,
      anon_sym_LF,
    STATE(106), 1,
      sym_comment,
  [2260] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(132), 1,
      anon_sym_LF,
    STATE(107), 1,
      sym_comment,
  [2270] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(279), 1,
      anon_sym_LF,
    STATE(108), 1,
      sym_comment,
  [2280] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(115), 1,
      anon_sym_LF,
    STATE(109), 1,
      sym_comment,
  [2290] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(281), 1,
      anon_sym_LF,
    STATE(110), 1,
      sym_comment,
  [2300] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(283), 1,
      anon_sym_EQ_GT,
    STATE(111), 1,
      sym_comment,
  [2310] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(285), 1,
      anon_sym_LF,
    STATE(112), 1,
      sym_comment,
  [2320] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(287), 1,
      anon_sym_COMMA,
    STATE(113), 1,
      sym_comment,
  [2330] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(289), 1,
      anon_sym_LF,
    STATE(114), 1,
      sym_comment,
  [2340] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(291), 1,
      anon_sym_LF,
    STATE(115), 1,
      sym_comment,
  [2350] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(293), 1,
      anon_sym_LF,
    STATE(116), 1,
      sym_comment,
  [2360] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(295), 1,
      anon_sym_LF,
    STATE(117), 1,
      sym_comment,
  [2370] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(297), 1,
      anon_sym_RBRACK,
    STATE(118), 1,
      sym_comment,
  [2380] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(299), 1,
      anon_sym_LF,
    STATE(119), 1,
      sym_comment,
  [2390] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(301), 1,
      anon_sym_LF,
    STATE(120), 1,
      sym_comment,
  [2400] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(194), 1,
      anon_sym_LF,
    STATE(121), 1,
      sym_comment,
  [2410] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(303), 1,
      anon_sym_LF,
    STATE(122), 1,
      sym_comment,
  [2420] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(305), 1,
      anon_sym_LF,
    STATE(123), 1,
      sym_comment,
  [2430] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(307), 1,
      anon_sym_LF,
    STATE(124), 1,
      sym_comment,
  [2440] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(309), 1,
      anon_sym_LF,
    STATE(125), 1,
      sym_comment,
  [2450] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(128), 1,
      anon_sym_LF,
    STATE(126), 1,
      sym_comment,
  [2460] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(311), 1,
      anon_sym_LF,
    STATE(127), 1,
      sym_comment,
  [2470] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(313), 1,
      anon_sym_LF,
    STATE(128), 1,
      sym_comment,
  [2480] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(315), 1,
      anon_sym_LF,
    STATE(129), 1,
      sym_comment,
  [2490] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(317), 1,
      anon_sym_LF,
    STATE(130), 1,
      sym_comment,
  [2500] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(319), 1,
      anon_sym_LF,
    STATE(131), 1,
      sym_comment,
  [2510] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(321), 1,
      anon_sym_LF,
    STATE(132), 1,
      sym_comment,
  [2520] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(323), 1,
      anon_sym_LF,
    STATE(133), 1,
      sym_comment,
  [2530] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(325), 1,
      aux_sym_comment_token1,
    STATE(134), 1,
      sym_comment,
  [2540] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(327), 1,
      anon_sym_RPAREN,
    STATE(135), 1,
      sym_comment,
  [2550] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(329), 1,
      anon_sym_LF,
    STATE(136), 1,
      sym_comment,
  [2560] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(331), 1,
      anon_sym_LF,
    STATE(137), 1,
      sym_comment,
  [2570] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(333), 1,
      anon_sym_LF,
    STATE(138), 1,
      sym_comment,
  [2580] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(271), 1,
      anon_sym_LF,
    STATE(139), 1,
      sym_comment,
  [2590] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(335), 1,
      anon_sym_LF,
    STATE(140), 1,
      sym_comment,
  [2600] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(337), 1,
      ts_builtin_sym_end,
    STATE(141), 1,
      sym_comment,
  [2610] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_LF,
    STATE(142), 1,
      sym_comment,
  [2620] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(341), 1,
      anon_sym_RBRACK,
    STATE(143), 1,
      sym_comment,
  [2630] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(343), 1,
      anon_sym_LF,
    STATE(144), 1,
      sym_comment,
  [2640] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(345), 1,
      anon_sym_EQ_GT,
    STATE(145), 1,
      sym_comment,
  [2650] = 3,
    ACTIONS(51), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(347), 1,
      anon_sym_LF,
    STATE(146), 1,
      sym_comment,
  [2660] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(349), 1,
      anon_sym_COMMA,
    STATE(147), 1,
      sym_comment,
  [2670] = 1,
    ACTIONS(351), 1,
      ts_builtin_sym_end,
};

static uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 40,
  [SMALL_STATE(4)] = 82,
  [SMALL_STATE(5)] = 122,
  [SMALL_STATE(6)] = 162,
  [SMALL_STATE(7)] = 200,
  [SMALL_STATE(8)] = 237,
  [SMALL_STATE(9)] = 274,
  [SMALL_STATE(10)] = 311,
  [SMALL_STATE(11)] = 348,
  [SMALL_STATE(12)] = 383,
  [SMALL_STATE(13)] = 420,
  [SMALL_STATE(14)] = 455,
  [SMALL_STATE(15)] = 474,
  [SMALL_STATE(16)] = 509,
  [SMALL_STATE(17)] = 528,
  [SMALL_STATE(18)] = 547,
  [SMALL_STATE(19)] = 566,
  [SMALL_STATE(20)] = 603,
  [SMALL_STATE(21)] = 640,
  [SMALL_STATE(22)] = 674,
  [SMALL_STATE(23)] = 708,
  [SMALL_STATE(24)] = 742,
  [SMALL_STATE(25)] = 773,
  [SMALL_STATE(26)] = 804,
  [SMALL_STATE(27)] = 835,
  [SMALL_STATE(28)] = 866,
  [SMALL_STATE(29)] = 897,
  [SMALL_STATE(30)] = 928,
  [SMALL_STATE(31)] = 959,
  [SMALL_STATE(32)] = 975,
  [SMALL_STATE(33)] = 991,
  [SMALL_STATE(34)] = 1007,
  [SMALL_STATE(35)] = 1035,
  [SMALL_STATE(36)] = 1063,
  [SMALL_STATE(37)] = 1091,
  [SMALL_STATE(38)] = 1119,
  [SMALL_STATE(39)] = 1135,
  [SMALL_STATE(40)] = 1163,
  [SMALL_STATE(41)] = 1191,
  [SMALL_STATE(42)] = 1207,
  [SMALL_STATE(43)] = 1235,
  [SMALL_STATE(44)] = 1251,
  [SMALL_STATE(45)] = 1267,
  [SMALL_STATE(46)] = 1295,
  [SMALL_STATE(47)] = 1323,
  [SMALL_STATE(48)] = 1351,
  [SMALL_STATE(49)] = 1367,
  [SMALL_STATE(50)] = 1383,
  [SMALL_STATE(51)] = 1399,
  [SMALL_STATE(52)] = 1427,
  [SMALL_STATE(53)] = 1455,
  [SMALL_STATE(54)] = 1471,
  [SMALL_STATE(55)] = 1487,
  [SMALL_STATE(56)] = 1503,
  [SMALL_STATE(57)] = 1519,
  [SMALL_STATE(58)] = 1535,
  [SMALL_STATE(59)] = 1551,
  [SMALL_STATE(60)] = 1567,
  [SMALL_STATE(61)] = 1583,
  [SMALL_STATE(62)] = 1599,
  [SMALL_STATE(63)] = 1615,
  [SMALL_STATE(64)] = 1631,
  [SMALL_STATE(65)] = 1647,
  [SMALL_STATE(66)] = 1663,
  [SMALL_STATE(67)] = 1679,
  [SMALL_STATE(68)] = 1707,
  [SMALL_STATE(69)] = 1723,
  [SMALL_STATE(70)] = 1751,
  [SMALL_STATE(71)] = 1767,
  [SMALL_STATE(72)] = 1783,
  [SMALL_STATE(73)] = 1799,
  [SMALL_STATE(74)] = 1812,
  [SMALL_STATE(75)] = 1825,
  [SMALL_STATE(76)] = 1838,
  [SMALL_STATE(77)] = 1851,
  [SMALL_STATE(78)] = 1866,
  [SMALL_STATE(79)] = 1883,
  [SMALL_STATE(80)] = 1900,
  [SMALL_STATE(81)] = 1917,
  [SMALL_STATE(82)] = 1934,
  [SMALL_STATE(83)] = 1951,
  [SMALL_STATE(84)] = 1968,
  [SMALL_STATE(85)] = 1981,
  [SMALL_STATE(86)] = 1998,
  [SMALL_STATE(87)] = 2011,
  [SMALL_STATE(88)] = 2024,
  [SMALL_STATE(89)] = 2037,
  [SMALL_STATE(90)] = 2050,
  [SMALL_STATE(91)] = 2063,
  [SMALL_STATE(92)] = 2076,
  [SMALL_STATE(93)] = 2089,
  [SMALL_STATE(94)] = 2102,
  [SMALL_STATE(95)] = 2119,
  [SMALL_STATE(96)] = 2134,
  [SMALL_STATE(97)] = 2146,
  [SMALL_STATE(98)] = 2158,
  [SMALL_STATE(99)] = 2170,
  [SMALL_STATE(100)] = 2182,
  [SMALL_STATE(101)] = 2194,
  [SMALL_STATE(102)] = 2208,
  [SMALL_STATE(103)] = 2220,
  [SMALL_STATE(104)] = 2230,
  [SMALL_STATE(105)] = 2240,
  [SMALL_STATE(106)] = 2250,
  [SMALL_STATE(107)] = 2260,
  [SMALL_STATE(108)] = 2270,
  [SMALL_STATE(109)] = 2280,
  [SMALL_STATE(110)] = 2290,
  [SMALL_STATE(111)] = 2300,
  [SMALL_STATE(112)] = 2310,
  [SMALL_STATE(113)] = 2320,
  [SMALL_STATE(114)] = 2330,
  [SMALL_STATE(115)] = 2340,
  [SMALL_STATE(116)] = 2350,
  [SMALL_STATE(117)] = 2360,
  [SMALL_STATE(118)] = 2370,
  [SMALL_STATE(119)] = 2380,
  [SMALL_STATE(120)] = 2390,
  [SMALL_STATE(121)] = 2400,
  [SMALL_STATE(122)] = 2410,
  [SMALL_STATE(123)] = 2420,
  [SMALL_STATE(124)] = 2430,
  [SMALL_STATE(125)] = 2440,
  [SMALL_STATE(126)] = 2450,
  [SMALL_STATE(127)] = 2460,
  [SMALL_STATE(128)] = 2470,
  [SMALL_STATE(129)] = 2480,
  [SMALL_STATE(130)] = 2490,
  [SMALL_STATE(131)] = 2500,
  [SMALL_STATE(132)] = 2510,
  [SMALL_STATE(133)] = 2520,
  [SMALL_STATE(134)] = 2530,
  [SMALL_STATE(135)] = 2540,
  [SMALL_STATE(136)] = 2550,
  [SMALL_STATE(137)] = 2560,
  [SMALL_STATE(138)] = 2570,
  [SMALL_STATE(139)] = 2580,
  [SMALL_STATE(140)] = 2590,
  [SMALL_STATE(141)] = 2600,
  [SMALL_STATE(142)] = 2610,
  [SMALL_STATE(143)] = 2620,
  [SMALL_STATE(144)] = 2630,
  [SMALL_STATE(145)] = 2640,
  [SMALL_STATE(146)] = 2650,
  [SMALL_STATE(147)] = 2660,
  [SMALL_STATE(148)] = 2670,
};

static TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [19] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [21] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(30),
  [24] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(36),
  [27] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(23),
  [30] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(22),
  [33] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(21),
  [36] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(10),
  [39] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(136),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [55] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_retract_directive_repeat1, 2), SHIFT_REPEAT(109),
  [58] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_retract_directive_repeat1, 2), SHIFT_REPEAT(83),
  [61] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_retract_directive_repeat1, 2), SHIFT_REPEAT(126),
  [64] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_retract_directive_repeat1, 2),
  [66] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_retract_directive_repeat1, 2), SHIFT_REPEAT(34),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [81] = {.entry = {.count = 1, .reusable = false}}, SHIFT(140),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [85] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_replace_directive_repeat1, 2), SHIFT_REPEAT(74),
  [88] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_replace_directive_repeat1, 2), SHIFT_REPEAT(79),
  [91] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_replace_directive_repeat1, 2), SHIFT_REPEAT(87),
  [94] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_replace_directive_repeat1, 2),
  [96] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [98] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [100] = {.entry = {.count = 1, .reusable = false}}, SHIFT(87),
  [102] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [104] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_exclude_directive_repeat1, 2), SHIFT_REPEAT(96),
  [107] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_exclude_directive_repeat1, 2), SHIFT_REPEAT(81),
  [110] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_exclude_directive_repeat1, 2), SHIFT_REPEAT(97),
  [113] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_exclude_directive_repeat1, 2),
  [115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string_literal, 1),
  [117] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_require_directive_repeat1, 2), SHIFT_REPEAT(96),
  [120] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_require_directive_repeat1, 2), SHIFT_REPEAT(81),
  [123] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_require_directive_repeat1, 2), SHIFT_REPEAT(97),
  [126] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_require_directive_repeat1, 2),
  [128] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string_or_ident, 1),
  [130] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpreted_string_literal, 2),
  [132] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpreted_string_literal, 3),
  [134] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [136] = {.entry = {.count = 1, .reusable = false}}, SHIFT(116),
  [138] = {.entry = {.count = 1, .reusable = false}}, SHIFT(142),
  [140] = {.entry = {.count = 1, .reusable = false}}, SHIFT(144),
  [142] = {.entry = {.count = 1, .reusable = false}}, SHIFT(146),
  [144] = {.entry = {.count = 1, .reusable = false}}, SHIFT(77),
  [146] = {.entry = {.count = 1, .reusable = false}}, SHIFT(14),
  [148] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [150] = {.entry = {.count = 1, .reusable = false}}, SHIFT(16),
  [152] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [154] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [156] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [158] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_require_directive, 5),
  [160] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_go_directive, 3),
  [162] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_directive, 2),
  [164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_require_directive, 2),
  [166] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exclude_directive, 2),
  [168] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_directive, 2),
  [170] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 1),
  [172] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_retract_directive, 2),
  [174] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive, 1),
  [176] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exclude_directive, 5),
  [178] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_retract_spec, 6),
  [180] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_spec, 6),
  [182] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_retract_directive, 6),
  [184] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_spec, 5),
  [186] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_retract_spec, 2),
  [188] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_directive, 6),
  [190] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exclude_directive, 6),
  [192] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_require_directive, 6),
  [194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_path, 1),
  [196] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_require_spec, 3),
  [198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_directive, 6),
  [200] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_spec, 4),
  [202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exclude_spec, 3),
  [204] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_directive, 5),
  [206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_retract_directive, 5),
  [208] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_retract_spec, 2),
  [210] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_retract_spec, 6),
  [212] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_retract_directive_repeat1, 1),
  [214] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_retract_directive_repeat1, 1),
  [216] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_require_directive_repeat1, 1),
  [218] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string_literal, 1),
  [220] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_require_spec, 3),
  [222] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_replace_directive_repeat1, 1),
  [224] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string_or_ident, 1),
  [226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file_path, 1),
  [228] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [232] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [234] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [236] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [238] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [240] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [242] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpreted_string_literal, 3),
  [244] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [246] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpreted_string_literal, 2),
  [248] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_exclude_spec, 3),
  [250] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_replace_spec, 4),
  [252] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_replace_spec, 5),
  [254] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_path, 1),
  [256] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_exclude_directive_repeat1, 1),
  [258] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_replace_spec, 6),
  [260] = {.entry = {.count = 1, .reusable = false}}, SHIFT(18),
  [262] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_interpreted_string_literal_repeat1, 2),
  [264] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interpreted_string_literal_repeat1, 2), SHIFT_REPEAT(101),
  [267] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_interpreted_string_literal_repeat1, 1),
  [269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_interpreted_string_literal_repeat1, 1),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_version, 1),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_go_version, 1),
  [297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [325] = {.entry = {.count = 1, .reusable = false}}, SHIFT(148),
  [327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [337] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [351] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_gomod(void) {
  static TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = (const uint16_t *)ts_parse_table,
    .small_parse_table = (const uint16_t *)ts_small_parse_table,
    .small_parse_table_map = (const uint32_t *)ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = (const TSSymbol *)ts_alias_sequences,
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
