#if OPENCLI
#pragma warning restore
#else
#pragma warning disable
#endif

using System.Text.Json;
using System.Text.Json.Serialization;

namespace OpenCli.Internal;

internal static class OpenCliWriter
{
    private static readonly JsonSerializerOptions _options = new JsonSerializerOptions
    {
        WriteIndented = true,
        DefaultIgnoreCondition = JsonIgnoreCondition.WhenWritingNull,
    };

    public static string Write(OpenCliDocument document)
    {
        if (document == null)
        {
            throw new ArgumentNullException(nameof(document));
        }

        return JsonSerializer.Serialize(
            OpenCliMapper.Map(document),
            _options);
    }

    public static void Write(Stream stream, OpenCliDocument document)
    {
        if (document == null)
        {
            throw new ArgumentNullException(nameof(document));
        }

        JsonSerializer.Serialize(
            stream,
            OpenCliMapper.Map(document),
            _options);
    }
}