/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Channel;
import hudson.remoting.Checksum;
import hudson.remoting.JarCache;
import hudson.remoting.ResourceImageRef;
import hudson.remoting.URLish;
import hudson.remoting.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

class ResourceImageInJar
extends ResourceImageRef {
    final long sum1;
    final long sum2;
    final String path;
    private static final long serialVersionUID = 1L;

    ResourceImageInJar(long sum1, long sum2, String path) {
        this.sum1 = sum1;
        this.sum2 = sum2;
        this.path = path;
    }

    ResourceImageInJar(Checksum sum, String path) {
        this(sum.sum1, sum.sum2, path);
    }

    @Override
    Future<byte[]> resolve(Channel channel, String resourcePath) throws IOException, InterruptedException {
        return this._resolveJarURL(channel).thenApply(jar -> this.readContents((URL)jar, resourcePath));
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="This is only used for managing the jar cache as files.")
    private byte[] readContents(URL jar, String resourcePath) {
        byte[] byArray;
        block8: {
            InputStream in = this.toResourceURL(jar, resourcePath).openStream();
            try {
                byArray = Util.readFully(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return byArray;
    }

    @Override
    Future<URLish> resolveURL(Channel channel, String resourcePath) throws IOException, InterruptedException {
        return this._resolveJarURL(channel).thenApply(jar -> this.getUrlish((URL)jar, resourcePath));
    }

    private URLish getUrlish(URL jar, String resourcePath) {
        try {
            return URLish.from(this.toResourceURL(jar, resourcePath));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NonNull
    private URL toResourceURL(URL jar, String resourcePath) throws IOException {
        if (this.path != null) {
            resourcePath = this.path;
        }
        return new URL("jar:" + String.valueOf(jar) + "!/" + resourcePath);
    }

    CompletableFuture<URL> _resolveJarURL(Channel channel) throws IOException, InterruptedException {
        JarCache c = channel.getJarCache();
        if (c == null) {
            throw new IOException(String.format("Failed to resolve a jar %016x%016x. JAR Cache is disabled for the channel %s", this.sum1, this.sum2, channel.getName()));
        }
        return c.resolve(channel, this.sum1, this.sum2);
    }
}

