/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.Engine;
import hudson.remoting.EngineListener;
import hudson.remoting.FileSystemJarCache;
import hudson.remoting.JarCache;
import hudson.remoting.PingThread;
import hudson.remoting.SocketChannelStream;
import hudson.remoting.StandardOutputStream;
import hudson.remoting.Util;
import io.jenkins.remoting.shaded.org.kohsuke.args4j.Argument;
import io.jenkins.remoting.shaded.org.kohsuke.args4j.CmdLineException;
import io.jenkins.remoting.shaded.org.kohsuke.args4j.CmdLineParser;
import io.jenkins.remoting.shaded.org.kohsuke.args4j.Option;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jenkinsci.remoting.DurationOptionHandler;
import org.jenkinsci.remoting.engine.JnlpAgentEndpointResolver;
import org.jenkinsci.remoting.engine.WorkDirManager;
import org.jenkinsci.remoting.util.DurationFormatter;
import org.jenkinsci.remoting.util.PathUtils;
import org.jenkinsci.remoting.util.SettableFuture;
import org.jenkinsci.remoting.util.https.NoCheckHostnameVerifier;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@SuppressFBWarnings(value={"DM_EXIT"}, justification="This class is runnable. It is eligible to exit in the case of wrong params")
public class Launcher {
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="TODO needs triage")
    public Channel.Mode mode = Channel.Mode.BINARY;
    @Deprecated
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="TODO needs triage")
    public boolean ping = true;
    @Option(name="-agentLog", usage="Local agent error log destination (overrides workDir)")
    @CheckForNull
    public File agentLog = null;
    @Option(name="-jnlpUrl", usage="instead of talking to the controller via stdin/stdout, emulate a JNLP client by making a TCP connection to the controller. Connection parameters are obtained by parsing the JNLP file.", forbids={"-direct", "-name", "-tunnel", "-url", "-webSocket"})
    @Deprecated
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="TODO needs triage")
    public URL agentJnlpURL = null;
    @Option(name="-credentials", metaVar="USER:PASSWORD", aliases={"-jnlpCredentials"}, usage="HTTP BASIC AUTH header to pass in for making HTTP requests.")
    public String agentJnlpCredentials = null;
    @Option(name="-secret", metaVar="HEX_SECRET", usage="Agent connection secret.")
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="TODO needs triage")
    public String secret;
    @Option(name="-name", usage="Name of the agent.")
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="TODO needs triage")
    public String name;
    @Option(name="-proxyCredentials", metaVar="USER:PASSWORD", usage="HTTP BASIC AUTH header to pass in for making HTTP authenticated proxy requests.")
    public String proxyCredentials = System.getProperty("proxyCredentials");
    @Deprecated
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="TODO needs triage")
    public File tcpPortFile = null;
    @Deprecated
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="TODO needs triage")
    public String auth = null;
    @Option(name="-jar-cache", metaVar="DIR", usage="Cache directory that stores jar files sent from the controller")
    @CheckForNull
    public File jarCache = null;
    @Option(name="-loggingConfig", usage="Path to the property file with java.util.logging settings")
    @CheckForNull
    public File loggingConfigFilePath = null;
    @Option(name="-cert", usage="Specify additional X.509 encoded PEM certificates to trust when connecting to Jenkins root URLs. If starting with @ then the remainder is assumed to be the name of the certificate file to read.", forbids={"-noCertificateCheck"})
    public List<String> candidateCertificates;
    private List<X509Certificate> x509Certificates;
    private SSLSocketFactory sslSocketFactory;
    @Option(name="-noCertificateCheck", aliases={"-disableHttpsCertValidation"}, forbids={"-cert"}, usage="Ignore SSL validation errors - use as a last resort only.")
    public boolean noCertificateCheck = false;
    private HostnameVerifier hostnameVerifier;
    @Deprecated
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="TODO needs triage")
    public InetSocketAddress connectionTarget = null;
    @Option(name="-noReconnect", aliases={"-noreconnect"}, usage="Doesn't try to reconnect when a communication fail, and exit instead")
    public boolean noReconnect = false;
    @Option(name="-noReconnectAfter", usage="Bail out after the given time after the first attempt to reconnect", handler=DurationOptionHandler.class, forbids={"-noReconnect"})
    public Duration noReconnectAfter;
    @Option(name="-noKeepAlive", usage="Disable TCP socket keep alive on connection to the controller.")
    public boolean noKeepAlive = false;
    @Option(name="-workDir", usage="Declares the working directory of the remoting instance (stores cache and logs by default)")
    @CheckForNull
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="TODO needs triage")
    public File workDir = null;
    @Option(name="-internalDir", usage="Specifies a name of the internal files within a working directory ('remoting' by default)", depends={"-workDir"})
    @NonNull
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="TODO needs triage")
    public String internalDir = WorkDirManager.DirType.INTERNAL_DIR.getDefaultLocation();
    @Option(name="-failIfWorkDirIsMissing", usage="Fails the initialization if the requested workDir or internalDir are missing ('false' by default)", depends={"-workDir"})
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="TODO needs triage")
    public boolean failIfWorkDirIsMissing = false;
    @Option(name="-tunnel", metaVar="HOST:PORT", usage="Connect to the specified host and port, instead of connecting directly to Jenkins. Useful when connection to Jenkins needs to be tunneled. Can be also HOST: or :PORT, in which case the missing portion will be auto-configured like the default behavior.")
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="TODO needs triage")
    public String tunnel;
    @Deprecated
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="TODO needs triage")
    public boolean headlessMode;
    @Option(name="-url", usage="Specify the Jenkins root URLs to connect to.")
    public List<URL> urls = new ArrayList<URL>();
    @Option(name="-webSocket", usage="Make a WebSocket connection to Jenkins rather than using the TCP port.", depends={"-url"}, forbids={"-direct", "-tunnel", "-credentials", "-noKeepAlive"})
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="TODO needs triage")
    public boolean webSocket;
    @Option(name="-webSocketHeader", usage="Additional WebSocket header to set, eg for authenticating with reverse proxies. To specify multiple headers, call this flag multiple times, one with each header", metaVar="NAME=VALUE", depends={"-webSocket"})
    public Map<String, String> webSocketHeaders;
    @Option(name="-direct", metaVar="HOST:PORT", aliases={"-directConnection"}, depends={"-instanceIdentity"}, forbids={"-jnlpUrl", "-url", "-tunnel"}, usage="Connect directly to this TCP agent port, skipping the HTTP(S) connection parameter download. For example, \"myjenkins:50000\".")
    public String directConnection;
    @Option(name="-instanceIdentity", depends={"-direct"}, usage="The base64 encoded InstanceIdentity byte array of the Jenkins controller. When this is set, the agent skips connecting to an HTTP(S) port for connection info.")
    public String instanceIdentity;
    @Option(name="-protocols", depends={"-direct"}, usage="Specify the remoting protocols to attempt when instanceIdentity is provided.")
    public List<String> protocols = new ArrayList<String>();
    @Option(name="-help", usage="Show this help message")
    public boolean showHelp = false;
    @Option(name="-version", usage="Shows the version of the remoting jar and then exits")
    public boolean showVersion = false;
    @Argument
    @Deprecated
    public List<String> args = new ArrayList<String>();
    private boolean initialized;
    private static String communicationProtocolName;
    public static final String VERSION;
    private static final String JENKINS_VERSION_PROP_FILE = "hudson-version.properties";
    private static final String UNKNOWN_JENKINS_VERSION_STR = "?";
    private static final Logger LOGGER;

    @Option(name="-text", usage="encode communication with the controller with base64. Useful for running agent over 8-bit unsafe protocol like telnet")
    public void setTextMode(boolean b) {
        this.mode = b ? Channel.Mode.TEXT : Channel.Mode.BINARY;
        System.out.println("Running in " + this.mode.name().toLowerCase(Locale.ENGLISH) + " mode");
    }

    @Deprecated
    @Option(name="-ping", usage="(deprecated; now always pings)")
    public void setPing(boolean ping) {
        this.ping = ping;
        System.err.println("WARNING: The \"-ping\" argument is deprecated and will be removed without replacement in a future release.");
    }

    @Deprecated
    @Option(name="-tcp", usage="(deprecated) instead of talking to the controller via stdin/stdout, listens to a random local port, write that port number to the given file, then wait for the controller to connect to that port.")
    public void setTcpPortFile(File tcpPortFile) {
        this.tcpPortFile = tcpPortFile;
        System.err.println("WARNING: The \"-tcp\" argument is deprecated and will be removed without replacement in a future release.");
    }

    @Deprecated
    @Option(name="-auth", metaVar="user:pass", usage="(deprecated) unused; use -credentials or -proxyCredentials")
    public void setAuth(String auth) {
        this.auth = auth;
        System.err.println("WARNING: The \"-auth\" argument is deprecated and will be removed in a future release; use \"-credentials\" or \"-proxyCredentials\" instead.");
    }

    @Deprecated
    @Option(name="-connectTo", usage="(deprecated) make a TCP connection to the given host and port, then start communication.", metaVar="HOST:PORT")
    public void setConnectTo(String target) {
        String[] tokens = target.split(":");
        if (tokens.length != 2) {
            throw new IllegalArgumentException(target);
        }
        this.connectionTarget = new InetSocketAddress(tokens[0], Integer.parseInt(tokens[1]));
        System.err.println("WARNING: The \"-connectTo\" argument is deprecated and will be removed without replacement in a future release.");
    }

    @Deprecated
    @Option(name="-headless", usage="(deprecated; now always headless)")
    public void setHeadlessMode(boolean headlessMode) {
        this.headlessMode = headlessMode;
        System.err.println("WARNING: The \"-headless\" argument is deprecated and will be removed without replacement in a future release.");
    }

    public static void main(String ... args) throws IOException, InterruptedException {
        Launcher launcher = new Launcher();
        CmdLineParser parser = new CmdLineParser(launcher);
        try {
            parser.parseArgument(args);
            if (launcher.args.size() == 2) {
                System.err.println("WARNING: Providing the secret and agent name as positional arguments is deprecated; use \"-secret\" and \"-name\" instead.");
            }
            Launcher.normalizeArguments(launcher);
            if (launcher.showHelp && !launcher.showVersion) {
                parser.printUsage(System.out);
                return;
            }
            launcher.run();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar agent.jar [options...]");
            parser.printUsage(System.err);
            System.err.println();
        }
    }

    public void run() throws CmdLineException, IOException, InterruptedException {
        if (this.showVersion) {
            String version = Util.getVersion();
            if (version != null) {
                System.out.println(version);
            }
            return;
        }
        if (this.connectionTarget != null) {
            this.initialize();
            this.runAsTcpClient();
        } else if (this.agentJnlpURL != null || !this.urls.isEmpty() || this.directConnection != null) {
            if (this.agentJnlpURL != null) {
                System.err.println("WARNING: The \"-jnlpUrl\" argument is deprecated. Use \"-url\" and \"-name\" instead, potentially also passing in \"-webSocket\", \"-tunnel\", and/or work directory options as needed.");
                this.bootstrapInboundAgent();
            } else {
                this.initialize();
            }
            this.runAsInboundAgent();
        } else if (this.tcpPortFile != null) {
            this.initialize();
            this.runAsTcpServer();
        } else {
            this.initialize();
            this.runWithStdinStdout();
        }
    }

    private synchronized void initialize() throws IOException {
        if (this.initialized) {
            throw new IllegalStateException("double initialization");
        }
        WorkDirManager workDirManager = WorkDirManager.getInstance();
        Path internalDirPath = workDirManager.initializeWorkDir(this.workDir, this.internalDir, this.failIfWorkDirIsMissing);
        if (this.agentLog != null) {
            workDirManager.disable(WorkDirManager.DirType.LOGS_DIR);
        }
        if (this.loggingConfigFilePath != null) {
            workDirManager.setLoggingConfig(this.loggingConfigFilePath);
        }
        workDirManager.setupLogging(internalDirPath, this.agentLog != null ? PathUtils.fileToPath(this.agentLog) : null);
        this.createX509Certificates();
        try {
            this.sslSocketFactory = Engine.getSSLSocketFactory(this.x509Certificates, this.noCertificateCheck);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        if (this.noCertificateCheck) {
            this.hostnameVerifier = new NoCheckHostnameVerifier();
        }
        this.initialized = true;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Parameter supplied by user / administrator.")
    private void createX509Certificates() {
        if (this.candidateCertificates != null && !this.candidateCertificates.isEmpty()) {
            CertificateFactory factory;
            try {
                factory = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException e) {
                throw new IllegalStateException("Java platform specification mandates support for X.509", e);
            }
            this.x509Certificates = new ArrayList<X509Certificate>();
            for (String certOrAtFilename : this.candidateCertificates) {
                byte[] cert;
                block18: {
                    if ((certOrAtFilename = certOrAtFilename.trim()).startsWith("@")) {
                        long length;
                        File file = new File(certOrAtFilename.substring(1));
                        if (file.isFile() && (length = file.length()) < 65536L && length > (long)"-----BEGIN CERTIFICATE-----\n-----END CERTIFICATE-----".length()) {
                            try (FileInputStream fis = new FileInputStream(file);){
                                cert = new byte[(int)length];
                                int read = fis.read(cert);
                                if (cert.length != read) {
                                    LOGGER.log(Level.WARNING, "Only read {0} bytes from {1}, expected to read {2}", new Object[]{read, file, cert.length});
                                    continue;
                                }
                                break block18;
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.WARNING, e, () -> "Could not read certificate from " + String.valueOf(file));
                            }
                            continue;
                        }
                        if (file.isFile()) {
                            LOGGER.log(Level.WARNING, "Could not read certificate from {0}. File size is not within the expected range for a PEM encoded X.509 certificate", file.getAbsolutePath());
                            continue;
                        }
                        LOGGER.log(Level.WARNING, "Could not read certificate from {0}. File not found", file.getAbsolutePath());
                        continue;
                    }
                    cert = certOrAtFilename.getBytes(StandardCharsets.US_ASCII);
                }
                try {
                    this.x509Certificates.add((X509Certificate)factory.generateCertificate(new ByteArrayInputStream(cert)));
                }
                catch (ClassCastException e) {
                    LOGGER.log(Level.WARNING, "Expected X.509 certificate from " + certOrAtFilename, e);
                }
                catch (CertificateException e) {
                    LOGGER.log(Level.WARNING, "Could not parse X.509 certificate from " + certOrAtFilename, e);
                }
            }
        }
    }

    private void bootstrapInboundAgent() throws CmdLineException, IOException, InterruptedException {
        List<String> jnlpArgs;
        try {
            jnlpArgs = this.parseJnlpArguments();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        if (this.directConnection != null) {
            jnlpArgs.add("-direct");
            jnlpArgs.add(this.directConnection);
        }
        if (this.tunnel != null) {
            jnlpArgs.add("-tunnel");
            jnlpArgs.add(this.tunnel);
        }
        if (this.agentJnlpCredentials != null) {
            jnlpArgs.add("-credentials");
            jnlpArgs.add(this.agentJnlpCredentials);
        }
        if (this.proxyCredentials != null) {
            jnlpArgs.add("-proxyCredentials");
            jnlpArgs.add(this.proxyCredentials);
        }
        if (this.noKeepAlive) {
            jnlpArgs.add("-noKeepAlive");
        }
        if (this.workDir != null) {
            jnlpArgs.add("-workDir");
            jnlpArgs.add(this.workDir.getAbsolutePath());
            jnlpArgs.add("-internalDir");
            jnlpArgs.add(this.internalDir);
            if (this.failIfWorkDirIsMissing) {
                jnlpArgs.add("-failIfWorkDirIsMissing");
            }
        }
        if (this.candidateCertificates != null && !this.candidateCertificates.isEmpty()) {
            for (String c : this.candidateCertificates) {
                jnlpArgs.add("-cert");
                jnlpArgs.add(c);
            }
        }
        if (this.noCertificateCheck) {
            jnlpArgs.add("-noCertificateCheck");
        }
        Launcher bootstrap = new Launcher();
        CmdLineParser parser = new CmdLineParser(bootstrap);
        parser.parseArgument(jnlpArgs.toArray(new String[0]));
        Launcher.normalizeArguments(bootstrap);
        Launcher.validateInboundAgentArgs(bootstrap);
        assert (this.urls.isEmpty());
        this.urls.addAll(bootstrap.urls);
        if (bootstrap.secret != null) {
            this.secret = bootstrap.secret;
        }
        if (bootstrap.name != null) {
            this.name = bootstrap.name;
        }
        if (bootstrap.webSocket) {
            this.webSocket = true;
        }
        if (bootstrap.tunnel != null) {
            this.tunnel = bootstrap.tunnel;
        }
        if (bootstrap.workDir != null) {
            this.workDir = bootstrap.workDir;
        }
        if (!WorkDirManager.DirType.INTERNAL_DIR.getDefaultLocation().equals(bootstrap.internalDir)) {
            this.internalDir = bootstrap.internalDir;
        }
        if (bootstrap.failIfWorkDirIsMissing) {
            this.failIfWorkDirIsMissing = bootstrap.failIfWorkDirIsMissing;
        }
    }

    private static void normalizeArguments(Launcher launcher) throws CmdLineException {
        if (!launcher.args.isEmpty()) {
            if (launcher.args.size() != 2) {
                throw new CmdLineException(null, "Two arguments required, but got " + String.valueOf(launcher.args));
            }
            if (launcher.secret != null) {
                throw new CmdLineException(null, "Cannot provide secret via both named and positional arguments");
            }
            launcher.secret = launcher.args.get(0);
            if (launcher.name != null) {
                throw new CmdLineException(null, "Cannot provide name via both named and positional arguments");
            }
            launcher.name = launcher.args.get(1);
            launcher.args.clear();
        }
    }

    private static void validateInboundAgentArgs(Launcher launcher) throws CmdLineException {
        assert (launcher.args.isEmpty()) : "should have been normalized previously";
        if (launcher.secret == null) {
            throw new CmdLineException(null, "Secret is required for inbound agents");
        }
        if (launcher.name == null) {
            throw new CmdLineException(null, "Name is required for inbound agents");
        }
        if (launcher.urls.isEmpty() && launcher.directConnection == null) {
            throw new CmdLineException(null, "At least one URL is required for inbound agents");
        }
        if (launcher.webSocket) {
            assert (!launcher.urls.isEmpty());
            if (launcher.urls.size() > 1) {
                throw new CmdLineException(null, "Only a single URL is supported for WebSocket agents");
            }
        }
    }

    private void runAsInboundAgent() throws CmdLineException, IOException, InterruptedException {
        Launcher.validateInboundAgentArgs(this);
        SettableFuture<Void> completion = SettableFuture.create();
        Engine engine = this.createEngine(completion);
        engine.startEngine();
        try {
            completion.get();
            LOGGER.fine("Engine has died");
        }
        catch (ExecutionException x) {
            throw new IllegalStateException(x.getCause());
        }
        finally {
            engine.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"CIPHER_INTEGRITY", "STATIC_IV"}, justification="Integrity not needed here. IV used for decryption only, loaded from encryptor.")
    private List<String> parseJnlpArguments() throws ParserConfigurationException, SAXException, IOException, InterruptedException {
        this.initialize();
        if (this.secret != null) {
            this.agentJnlpURL = new URL(String.valueOf(this.agentJnlpURL) + "?encrypt=true");
            if (this.agentJnlpCredentials != null) {
                throw new IOException("-jnlpCredentials and -secret are mutually exclusive");
            }
        }
        Instant firstAttempt = Instant.now();
        while (true) {
            HttpURLConnection http;
            URLConnection con = null;
            try {
                Document dom;
                con = JnlpAgentEndpointResolver.openURLConnection(this.agentJnlpURL, null, this.agentJnlpCredentials, this.proxyCredentials, this.sslSocketFactory, this.hostnameVerifier);
                con.connect();
                if (con instanceof HttpURLConnection && (http = (HttpURLConnection)con).getResponseCode() >= 400) {
                    throw new IOException("Failed to load " + String.valueOf(this.agentJnlpURL) + ": " + http.getResponseCode() + " " + http.getResponseMessage());
                }
                String contentType = con.getHeaderField("Content-Type");
                String expectedContentType = this.secret == null ? "application/x-java-jnlp-file" : "application/octet-stream";
                InputStream input = con.getInputStream();
                if (this.secret != null) {
                    byte[] payload = input.readAllBytes();
                    try {
                        Cipher cipher = Cipher.getInstance("AES/CFB8/NoPadding");
                        cipher.init(2, (Key)new SecretKeySpec(Launcher.fromHexString(this.secret.substring(0, Math.min(this.secret.length(), 32))), "AES"), new IvParameterSpec(payload, 0, 16));
                        byte[] decrypted = cipher.doFinal(payload, 16, payload.length - 16);
                        input = new ByteArrayInputStream(decrypted);
                    }
                    catch (GeneralSecurityException x) {
                        throw new IOException("Failed to decrypt the JNLP file. Invalid secret key?", x);
                    }
                }
                if (contentType == null || !contentType.startsWith(expectedContentType)) {
                    try {
                        dom = Launcher.loadDom(input);
                    }
                    catch (IOException | SAXException e) {
                        throw new IOException(String.valueOf(this.agentJnlpURL) + " doesn't look like a JNLP file; content type was " + contentType);
                    }
                } else {
                    dom = Launcher.loadDom(input);
                }
                NodeList argElements = dom.getElementsByTagName("argument");
                ArrayList<String> jnlpArgs = new ArrayList<String>();
                for (int i = 0; i < argElements.getLength(); ++i) {
                    jnlpArgs.add(argElements.item(i).getTextContent());
                }
                ArrayList<String> arrayList = jnlpArgs;
                return arrayList;
            }
            catch (SSLHandshakeException e) {
                if (e.getMessage().contains("PKIX path building failed")) {
                    throw new IOException("Failed to validate a server certificate. If you are using a self-signed certificate, you can use the -noCertificateCheck option to bypass this check.", e);
                }
                throw e;
            }
            catch (IOException e) {
                if (this.noReconnect) {
                    throw new IOException("Failed to obtain " + String.valueOf(this.agentJnlpURL), e);
                }
                if (Util.shouldBailOut(firstAttempt, this.noReconnectAfter)) {
                    throw new IOException("Failed to obtain " + String.valueOf(this.agentJnlpURL) + " after " + DurationFormatter.format(this.noReconnectAfter), e);
                }
                System.err.println("Failed to obtain " + String.valueOf(this.agentJnlpURL));
                e.printStackTrace(System.err);
                System.err.println("Waiting 10 seconds before retry");
                TimeUnit.SECONDS.sleep(10L);
                continue;
            }
            finally {
                if (!(con instanceof HttpURLConnection)) continue;
                http = (HttpURLConnection)con;
                http.disconnect();
                continue;
            }
            break;
        }
    }

    private static byte[] fromHexString(String data) {
        byte[] r = new byte[data.length() / 2];
        for (int i = 0; i < data.length(); i += 2) {
            r[i / 2] = (byte)Integer.parseInt(data.substring(i, i + 2), 16);
        }
        return r;
    }

    static Document loadDom(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @SuppressFBWarnings(value={"UNENCRYPTED_SERVER_SOCKET", "DM_DEFAULT_ENCODING", "ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="This is an old, insecure mechanism that should be removed. port number file should be in platform default encoding. Laucher instance is created only once.")
    private void runAsTcpServer() throws IOException, InterruptedException {
        Socket s;
        try (ServerSocket ss = new ServerSocket(0, 1);){
            ss.setSoTimeout(30000);
            try (FileWriter w = new FileWriter(this.tcpPortFile);){
                w.write(String.valueOf(ss.getLocalPort()));
            }
            s = ss.accept();
        }
        finally {
            boolean deleted = this.tcpPortFile.delete();
            if (!deleted) {
                LOGGER.log(Level.WARNING, "Cannot delete the temporary TCP port file {0}", this.tcpPortFile);
            }
        }
        communicationProtocolName = "TCP (remote: server)";
        this.runOnSocket(s);
    }

    private void runOnSocket(Socket s) throws IOException, InterruptedException {
        s.setKeepAlive(true);
        s.setTcpNoDelay(true);
        Launcher.main(new BufferedInputStream(SocketChannelStream.in(s)), new BufferedOutputStream(SocketChannelStream.out(s)), this.mode, this.ping, this.jarCache != null ? new FileSystemJarCache(this.jarCache, true) : null);
    }

    @Deprecated
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET", "ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="This implements an old, insecure connection mechanism. Laucher instance is created only once.")
    private void runAsTcpClient() throws IOException, InterruptedException {
        Socket s = new Socket(this.connectionTarget.getAddress(), this.connectionTarget.getPort());
        communicationProtocolName = "TCP (remote: client)";
        this.runOnSocket(s);
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD", "DMI_RANDOM_USED_ONLY_ONCE"}, justification="Laucher instance is created only once.")
    private void runWithStdinStdout() throws IOException, InterruptedException {
        Launcher.ttyCheck();
        if (Launcher.isWindows()) {
            new SecureRandom().nextBoolean();
        }
        StandardOutputStream os = new StandardOutputStream();
        System.setOut(System.err);
        communicationProtocolName = "Standard in/out";
        Launcher.main(System.in, os, this.mode, this.ping, this.jarCache != null ? new FileSystemJarCache(this.jarCache, true) : null);
    }

    private static void ttyCheck() {
        Console console = System.console();
        if (console != null) {
            System.out.println("WARNING: Are you running agent from an interactive console?\nIf so, you are probably using it incorrectly.\nSee https://wiki.jenkins.io/display/JENKINS/Launching+agent+from+console");
        }
    }

    public static void main(InputStream is, OutputStream os) throws IOException, InterruptedException {
        Launcher.main(is, os, Channel.Mode.BINARY);
    }

    public static void main(InputStream is, OutputStream os, Channel.Mode mode) throws IOException, InterruptedException {
        Launcher.main(is, os, mode, false);
    }

    @Deprecated
    public static void main(InputStream is, OutputStream os, Channel.Mode mode, boolean performPing) throws IOException, InterruptedException {
        Launcher.main(is, os, mode, performPing, null);
    }

    public static void main(InputStream is, OutputStream os, Channel.Mode mode, boolean performPing, @CheckForNull JarCache cache) throws IOException, InterruptedException {
        ExecutorService executor = Executors.newCachedThreadPool();
        ChannelBuilder cb = new ChannelBuilder("channel", executor).withMode(mode).withJarCacheOrDefault(cache);
        if (os instanceof StandardOutputStream) {
            cb.withProperty(StandardOutputStream.class, os);
        }
        Channel channel = cb.build(is, os);
        System.err.println("channel started");
        long timeout = 1000L * Long.parseLong(System.getProperty("hudson.remoting.Launcher.pingTimeoutSec", "240"));
        long interval = 1000L * Long.parseLong(System.getProperty("hudson.remoting.Launcher.pingIntervalSec", "0"));
        Logger.getLogger(PingThread.class.getName()).log(Level.FINE, "performPing={0} timeout={1} interval={2}", new Object[]{performPing, timeout, interval});
        if (performPing && timeout > 0L && interval > 0L) {
            new PingThread(channel, timeout, interval){

                @Override
                @Deprecated
                protected void onDead() {
                    System.err.println("Ping failed. Terminating");
                    System.exit(-1);
                }

                @Override
                @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"}, justification="Prints the agent-side message to the agent log before exiting.")
                protected void onDead(Throwable cause) {
                    System.err.println("Ping failed. Terminating");
                    cause.printStackTrace();
                    System.exit(-1);
                }
            }.start();
        }
        channel.join();
        System.err.println("channel stopped");
        System.exit(0);
    }

    public static boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    public static String getCommunicationProtocolName() {
        return communicationProtocolName;
    }

    private static String computeVersion() {
        Properties props = new Properties();
        InputStream is = Launcher.class.getResourceAsStream(JENKINS_VERSION_PROP_FILE);
        if (is == null) {
            LOGGER.log(Level.FINE, "Cannot locate the {0} resource file. Hudson/Jenkins version is unknown", JENKINS_VERSION_PROP_FILE);
            return UNKNOWN_JENKINS_VERSION_STR;
        }
        try {
            props.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            Launcher.closeWithLogOnly(is, JENKINS_VERSION_PROP_FILE);
        }
        return props.getProperty("version", UNKNOWN_JENKINS_VERSION_STR);
    }

    private static void closeWithLogOnly(Closeable stream, String name) {
        try {
            stream.close();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Cannot close the resource file " + name, ex);
        }
    }

    private Engine createEngine(SettableFuture<Void> completion) throws IOException {
        LOGGER.log(Level.INFO, "Setting up agent: {0}", this.name);
        Engine engine = new Engine(new CuiListener(completion), this.urls, this.secret, this.name, this.directConnection, this.instanceIdentity, new HashSet<String>(this.protocols));
        engine.setWebSocket(this.webSocket);
        if (this.webSocketHeaders != null) {
            engine.setWebSocketHeaders(this.webSocketHeaders);
        }
        if (this.tunnel != null) {
            engine.setTunnel(this.tunnel);
        }
        if (this.agentJnlpCredentials != null) {
            engine.setCredentials(this.agentJnlpCredentials);
        }
        if (this.proxyCredentials != null) {
            engine.setProxyCredentials(this.proxyCredentials);
        }
        if (this.jarCache != null) {
            engine.setJarCache(new FileSystemJarCache(this.jarCache, true));
        }
        engine.setNoReconnect(this.noReconnect);
        engine.setNoReconnectAfter(this.noReconnectAfter);
        engine.setKeepAlive(!this.noKeepAlive);
        if (this.noCertificateCheck) {
            LOGGER.log(Level.WARNING, "Certificate validation for HTTPs endpoints is disabled");
        }
        engine.setDisableHttpsCertValidation(this.noCertificateCheck);
        if (this.agentLog != null) {
            engine.setAgentLog(PathUtils.fileToPath(this.agentLog));
        }
        if (this.loggingConfigFilePath != null) {
            engine.setLoggingConfigFile(PathUtils.fileToPath(this.loggingConfigFilePath));
        }
        if (this.x509Certificates != null && !this.x509Certificates.isEmpty()) {
            engine.setCandidateCertificates(this.x509Certificates);
        }
        if (this.workDir != null) {
            engine.setWorkDir(PathUtils.fileToPath(this.workDir));
        }
        engine.setInternalDir(this.internalDir);
        engine.setFailIfWorkDirIsMissing(this.failIfWorkDirIsMissing);
        return engine;
    }

    static {
        VERSION = Launcher.computeVersion();
        LOGGER = Logger.getLogger(Launcher.class.getName());
    }

    private static final class CuiListener
    implements EngineListener {
        private final SettableFuture<Void> completion;

        CuiListener(SettableFuture<Void> completion) {
            this.completion = completion;
        }

        @Override
        public void status(String msg, Throwable t) {
            LOGGER.log(Level.INFO, msg, t);
        }

        @Override
        public void status(String msg) {
            this.status(msg, null);
        }

        @Override
        public void error(Throwable t) {
            LOGGER.log(Level.FINE, null, t);
            this.completion.setException(t);
        }

        @Override
        public void completed() {
            this.completion.set(null);
        }
    }
}

