/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.util;

import net.sf.json.JSONException;

public abstract class JavaIdentifierTransformer {
    public static final JavaIdentifierTransformer CAMEL_CASE = new CamelCaseJavaIdentifierTransformer();
    public static final JavaIdentifierTransformer NOOP = new NoopJavaIdentifierTransformer();
    public static final JavaIdentifierTransformer STRICT = new StrictJavaIdentifierTransformer();
    public static final JavaIdentifierTransformer UNDERSCORE = new UnderscoreJavaIdentifierTransformer();
    public static final JavaIdentifierTransformer WHITESPACE = new WhiteSpaceJavaIdentifierTransformer();

    public abstract String transformToJavaIdentifier(String var1);

    protected final String shaveOffNonJavaIdentifierStartChars(String str) {
        String str2 = str;
        boolean ready = false;
        while (!ready) {
            if (!Character.isJavaIdentifierStart(str2.charAt(0))) {
                if (!(str2 = str2.substring(1)).isEmpty()) continue;
                throw new JSONException("Can't convert '" + str + "' to a valid Java identifier");
            }
            ready = true;
        }
        return str2;
    }

    private static final class CamelCaseJavaIdentifierTransformer
    extends JavaIdentifierTransformer {
        private CamelCaseJavaIdentifierTransformer() {
        }

        @Override
        public String transformToJavaIdentifier(String str) {
            if (str == null) {
                return null;
            }
            String str2 = this.shaveOffNonJavaIdentifierStartChars(str);
            StringBuilder sb = new StringBuilder();
            boolean toUpperCaseNextChar = false;
            for (char ch : str2.toCharArray()) {
                if (!Character.isJavaIdentifierPart(ch) || Character.isWhitespace(ch)) {
                    toUpperCaseNextChar = true;
                    continue;
                }
                if (toUpperCaseNextChar) {
                    sb.append(Character.toUpperCase(ch));
                    toUpperCaseNextChar = false;
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
    }

    private static final class NoopJavaIdentifierTransformer
    extends JavaIdentifierTransformer {
        private NoopJavaIdentifierTransformer() {
        }

        @Override
        public String transformToJavaIdentifier(String str) {
            return str;
        }
    }

    private static final class StrictJavaIdentifierTransformer
    extends JavaIdentifierTransformer {
        private StrictJavaIdentifierTransformer() {
        }

        @Override
        public String transformToJavaIdentifier(String str) {
            throw new JSONException("'" + str + "' is not a valid Java identifier.");
        }
    }

    private static final class UnderscoreJavaIdentifierTransformer
    extends JavaIdentifierTransformer {
        private UnderscoreJavaIdentifierTransformer() {
        }

        @Override
        public String transformToJavaIdentifier(String str) {
            if (str == null) {
                return null;
            }
            String str2 = this.shaveOffNonJavaIdentifierStartChars(str);
            StringBuilder sb = new StringBuilder();
            boolean toUnderScorePreviousChar = false;
            for (char ch : str2.toCharArray()) {
                if (!Character.isJavaIdentifierPart(ch) || Character.isWhitespace(ch)) {
                    toUnderScorePreviousChar = true;
                    continue;
                }
                if (toUnderScorePreviousChar) {
                    sb.append("_");
                    toUnderScorePreviousChar = false;
                }
                sb.append(ch);
            }
            if (sb.charAt(sb.length() - 1) == '_') {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
    }

    private static final class WhiteSpaceJavaIdentifierTransformer
    extends JavaIdentifierTransformer {
        private WhiteSpaceJavaIdentifierTransformer() {
        }

        @Override
        public String transformToJavaIdentifier(String str) {
            if (str == null) {
                return null;
            }
            String str2 = this.shaveOffNonJavaIdentifierStartChars(str);
            StringBuilder sb = new StringBuilder();
            for (char ch : str2.toCharArray()) {
                if (!Character.isJavaIdentifierPart(ch)) continue;
                sb.append(ch);
            }
            return sb.toString();
        }
    }
}

