/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.primitive;

import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.primitive.AbstractIntegerMorpher;

public final class ByteMorpher
extends AbstractIntegerMorpher {
    private byte defaultValue;

    public ByteMorpher() {
    }

    public ByteMorpher(byte defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteMorpher)) {
            return false;
        }
        ByteMorpher other = (ByteMorpher)obj;
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(this.getDefaultValue(), other.getDefaultValue());
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public byte getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        if (this.isUseDefault()) {
            return Objects.hashCode(this.getDefaultValue());
        }
        return 17;
    }

    public byte morph(Object value) {
        if (value == null) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException("value is null");
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        byte i = 0;
        try {
            i = Byte.parseByte(this.getIntegerValue(value));
            return i;
        }
        catch (NumberFormatException nfe) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException(nfe);
        }
    }

    @Override
    public Class morphsTo() {
        return Byte.TYPE;
    }
}

