/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.listeners.RunListener;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedMap;
import java.util.function.IntPredicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.lazy.AbstractLazyLoadRunMap;
import jenkins.model.lazy.BuildReference;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class RunMap<R extends Run<?, R>>
extends AbstractLazyLoadRunMap<R>
implements Iterable<R> {
    private final SortedMap<Integer, R> view = Collections.unmodifiableSortedMap(this);
    @CheckForNull
    private final Job<?, ?> job;
    private Constructor<R> cons;
    @Deprecated
    public static final Comparator<Comparable> COMPARATOR = Comparator.reverseOrder();
    private static final Logger LOGGER = Logger.getLogger(RunMap.class.getName());

    @Deprecated
    public RunMap() {
        this.job = null;
        this.initBaseDir(null);
    }

    @Restricted(value={NoExternalUse.class})
    public RunMap(@NonNull Job<?, ?> job) {
        this.job = Objects.requireNonNull(job);
    }

    public RunMap(@NonNull Job<?, ?> job, Constructor<R> cons) {
        this.job = Objects.requireNonNull(job);
        this.cons = cons;
        this.initBaseDir(job.getBuildDir());
    }

    @Deprecated
    public RunMap(File baseDir, Constructor<R> cons) {
        this.job = null;
        this.cons = cons;
        this.initBaseDir(baseDir);
    }

    @Override
    public boolean remove(R run) {
        return this.removeValue(run);
    }

    @Override
    public Iterator<R> iterator() {
        return new Iterator<R>(){
            R last = null;
            R next = (Run)RunMap.this.newestBuild();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public R next() {
                this.last = this.next;
                if (this.last == null) {
                    throw new NoSuchElementException();
                }
                this.next = ((Run)this.last).getPreviousBuild();
                return this.last;
            }

            @Override
            public void remove() {
                if (this.last == null) {
                    throw new UnsupportedOperationException();
                }
                RunMap.this.removeValue(this.last);
            }
        };
    }

    @Override
    public boolean removeValue(R run) {
        ((Run)run).dropLinks();
        return super.removeValue(run);
    }

    public SortedMap<Integer, R> getView() {
        return this.view;
    }

    public R newestValue() {
        return (R)((Run)this.search(Integer.MAX_VALUE, AbstractLazyLoadRunMap.Direction.DESC));
    }

    public R oldestValue() {
        return (R)((Run)this.search(Integer.MIN_VALUE, AbstractLazyLoadRunMap.Direction.ASC));
    }

    @Override
    protected int getNumberOf(R r) {
        return ((Run)r).getNumber();
    }

    @Override
    protected String getIdOf(R r) {
        return ((Run)r).getId();
    }

    @Override
    public R put(R r) {
        File rootDir = ((Run)r).getRootDir();
        if (Files.isDirectory(rootDir.toPath(), new LinkOption[0])) {
            throw new IllegalStateException("JENKINS-23152: " + String.valueOf(rootDir) + " already existed; will not overwrite with " + String.valueOf(r));
        }
        if (!r.getClass().getName().equals("hudson.matrix.MatrixRun")) {
            this.proposeNewNumber(((Run)r).getNumber());
        }
        try {
            Util.createDirectories(rootDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return (R)((Run)super._put(r));
    }

    @Override
    @CheckForNull
    public R getById(String id) {
        try {
            return (R)((Run)this.getByNumber(Integer.parseInt(id)));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    protected BuildReference<R> createReference(R r) {
        return ((Run)r).createReference();
    }

    @Override
    @Restricted(value={NoExternalUse.class})
    protected boolean allowLoad(int buildNumber) {
        if (this.job == null) {
            LOGGER.fine(() -> "deprecated constructor without Job used on " + String.valueOf(this.dir));
            return true;
        }
        for (RunListener l : RunListener.all()) {
            if (l.allowLoad(this.job, buildNumber)) continue;
            LOGGER.finer(() -> String.valueOf(l) + " declined to load " + buildNumber + " in " + String.valueOf(this.job));
            return false;
        }
        LOGGER.finest(() -> "no RunListener declined to load " + buildNumber + " in " + String.valueOf(this.job) + " so proceeding");
        return true;
    }

    @Override
    @Restricted(value={NoExternalUse.class})
    protected IntPredicate createLoadAllower() {
        if (this.job == null) {
            LOGGER.fine(() -> "deprecated constructor without Job used on " + String.valueOf(this.dir));
            return buildNumber -> true;
        }
        List<IntPredicate> allowers = RunListener.all().stream().map(l -> l.createLoadAllower(this.job)).toList();
        return buildNumber -> {
            for (IntPredicate allower : allowers) {
                if (allower.test(buildNumber)) continue;
                LOGGER.finer(() -> String.valueOf(allower) + " declined to load " + buildNumber + " in " + String.valueOf(this.job));
                return false;
            }
            LOGGER.finest(() -> "no RunListener declined to load " + buildNumber + " in " + String.valueOf(this.job) + " so proceeding");
            return true;
        };
    }

    @Override
    protected R retrieve(File d) throws IOException {
        if (new File(d, "build.xml").exists()) {
            try {
                R b = this.cons.create(d);
                ((Run)b).onLoad();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Loaded " + ((Run)b).getFullDisplayName() + " in " + Thread.currentThread().getName(), new ThisIsHowItsLoaded());
                }
                return b;
            }
            catch (Exception | InstantiationError e) {
                LOGGER.log(Level.WARNING, "could not load " + String.valueOf(d), e);
            }
        }
        LOGGER.fine(() -> "no config.xml in " + String.valueOf(d));
        return null;
    }

    @Override
    protected Class<R> getBuildClass() {
        return this.cons.getBuildClass();
    }

    @Deprecated
    public void load(Job job, Constructor<R> cons) {
        this.cons = cons;
        this.initBaseDir(job.getBuildDir());
    }

    public static interface Constructor<R extends Run<?, R>> {
        public R create(File var1) throws IOException;

        public Class<R> getBuildClass();
    }

    private static class ThisIsHowItsLoaded
    extends Exception {
        private ThisIsHowItsLoaded() {
        }
    }
}

