/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDNumberTreeNode;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;

public class PageParentTreeFinder {
    private PDPage srcPage;

    public PageParentTreeFinder(PDPage srcPage) {
        this.srcPage = srcPage;
    }

    public COSArray getPageParentTreeArray(PDDocument srcDoc) throws IOException {
        int position = this.srcPage.getCOSObject().getInt(COSName.STRUCT_PARENTS);
        if (position == -1) {
            position = this.findXObjectStructParent();
        }
        if (position != -1) {
            PDNumberTreeNode srcNumberTreeNode = srcDoc.getDocumentCatalog().getStructureTreeRoot().getParentTree();
            return this.traverseParentTree(srcNumberTreeNode.getCOSObject(), position);
        }
        return new COSArray();
    }

    private int findXObjectStructParent() throws IOException {
        int position = -1;
        Iterable mapXObject = this.srcPage.getResources().getXObjectNames();
        for (COSName n : mapXObject) {
            PDXObject t = this.srcPage.getResources().getXObject(n);
            COSStream xObjectDict = t.getCOSObject();
            position = xObjectDict.getInt(COSName.STRUCT_PARENTS);
            if (position == -1) continue;
            return position;
        }
        return position;
    }

    private COSArray traverseParentTree(COSDictionary numberTreeNodeDict, int position) {
        ArrayList<COSArray> nums = new ArrayList<COSArray>();
        if (numberTreeNodeDict.containsKey(COSName.NUMS)) {
            COSArray numberTree = (COSArray)numberTreeNodeDict.getItem(COSName.NUMS);
            return this.extractMarkedContentParents(numberTree, position);
        }
        COSArray parentTree = (COSArray)numberTreeNodeDict.getDictionaryObject(COSName.KIDS);
        this.traverseKids((COSBase)parentTree, position, nums);
        if (nums.isEmpty()) {
            return new COSArray();
        }
        return (COSArray)nums.get(0);
    }

    private void traverseKids(COSBase kids, int position, List<COSArray> numList) {
        if (!numList.isEmpty()) {
            return;
        }
        if (kids instanceof COSArray) {
            COSArray kidsArray = (COSArray)kids;
            for (COSBase kid : kidsArray) {
                COSObject kidCOSObj = (COSObject)kid;
                this.traverseKids((COSBase)kidCOSObj, position, numList);
            }
        } else if (kids instanceof COSObject) {
            COSObject kidCOSObj = (COSObject)kids;
            COSDictionary kid = (COSDictionary)kidCOSObj.getObject();
            if (kid.getDictionaryObject(COSName.NUMS) == null) {
                this.traverseKids(kid.getDictionaryObject(COSName.KIDS), position, numList);
            } else if (kid.getDictionaryObject(COSName.LIMITS) != null) {
                COSArray kidCOSArray = (COSArray)kid.getDictionaryObject(COSName.LIMITS);
                int lowerLimit = ((COSInteger)kidCOSArray.get(0)).intValue();
                int upperLimit = ((COSInteger)kidCOSArray.get(1)).intValue();
                if (lowerLimit <= position && position <= upperLimit) {
                    COSArray nums = (COSArray)kid.getDictionaryObject(COSName.NUMS);
                    numList.add(this.extractMarkedContentParents(nums, position));
                }
            } else {
                COSArray nums = (COSArray)kid.getDictionaryObject(COSName.NUMS);
                numList.add(this.extractMarkedContentParents(nums, position));
            }
        }
    }

    private COSArray extractMarkedContentParents(COSArray numberTree, int position) {
        boolean keyFlag = false;
        for (COSBase kid : numberTree) {
            int temp;
            if (keyFlag) {
                if (kid instanceof COSObject) {
                    COSBase tempObject = ((COSObject)kid).getObject();
                    if (tempObject instanceof COSArray) {
                        return (COSArray)tempObject;
                    }
                } else if (kid instanceof COSArray) {
                    return (COSArray)kid;
                }
            }
            if (!(kid instanceof COSInteger) || (temp = ((COSInteger)kid).intValue()) != position) continue;
            keyFlag = true;
        }
        return new COSArray();
    }
}

