/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.remoting.DiagnosedStreamCorruptionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

class FlightRecorderInputStream
extends InputStream {
    private static final Logger LOGGER = Logger.getLogger(FlightRecorderInputStream.class.getName());
    static final int BUFFER_SIZE = Integer.getInteger("hudson.remoting.FlightRecorderInputStream.BUFFER_SIZE", 1024);
    private final InputStream source;
    private ByteArrayRingBuffer recorder = new ByteArrayRingBuffer(BUFFER_SIZE);

    FlightRecorderInputStream(InputStream source) {
        this.source = source;
    }

    public void clear() {
        this.recorder = new ByteArrayRingBuffer(BUFFER_SIZE);
    }

    public byte[] getRecord() {
        return this.recorder.toByteArray();
    }

    public DiagnosedStreamCorruptionException analyzeCrash(Exception problem, String diagnosisName) {
        final ByteArrayOutputStream readAhead = new ByteArrayOutputStream();
        final IOException[] error = new IOException[1];
        Thread diagnosisThread = new Thread(diagnosisName + " stream corruption diagnosis thread"){

            @Override
            public void run() {
                try {
                    int b;
                    while (!Thread.interrupted() && (b = FlightRecorderInputStream.this.source.read()) != -1) {
                        readAhead.write(b);
                    }
                }
                catch (IOException e) {
                    error[0] = e;
                }
            }
        };
        diagnosisThread.setUncaughtExceptionHandler((t, e) -> LOGGER.log(Level.SEVERE, e, () -> "Uncaught exception in diagnosis thread " + String.valueOf(t)));
        diagnosisThread.start();
        try {
            diagnosisThread.join(1000L);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        IOException diagnosisProblem = error[0];
        if (diagnosisThread.isAlive()) {
            diagnosisThread.interrupt();
        }
        return new DiagnosedStreamCorruptionException(problem, diagnosisProblem, this.getRecord(), readAhead.toByteArray());
    }

    @Override
    public int read() throws IOException {
        int i = this.source.read();
        if (i >= 0) {
            this.recorder.write(i);
        }
        return i;
    }

    @Override
    public int read(@NonNull byte[] b, int off, int len) throws IOException {
        if ((len = this.source.read(b, off, len)) > 0) {
            this.recorder.write(b, off, len);
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        byte[] buf = new byte[(int)Math.min(n, 65536L)];
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int available() throws IOException {
        return this.source.available();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private static class ByteArrayRingBuffer
    extends OutputStream {
        byte[] data;
        int capacity;
        int pos = 0;
        boolean filled = false;

        public ByteArrayRingBuffer(int capacity) {
            this.data = new byte[capacity];
            this.capacity = capacity;
        }

        @Override
        public synchronized void write(int b) {
            if (this.pos == this.capacity) {
                this.filled = true;
                this.pos = 0;
            }
            this.data[this.pos++] = (byte)b;
        }

        public synchronized byte[] toByteArray() {
            if (!this.filled) {
                return Arrays.copyOf(this.data, this.pos);
            }
            byte[] ret = new byte[this.capacity];
            System.arraycopy(this.data, this.pos, ret, 0, this.capacity - this.pos);
            System.arraycopy(this.data, 0, ret, this.capacity - this.pos, this.pos);
            return ret;
        }

        @Override
        public synchronized void write(@NonNull byte[] buf, int off, int len) {
            int num;
            if (len > this.capacity) {
                off += len - this.capacity;
                len = this.capacity;
            }
            if ((num = Math.min(len, this.capacity - this.pos)) > 0) {
                System.arraycopy(buf, off, this.data, this.pos, num);
                off += num;
                len -= num;
                this.pos += num;
            }
            if (this.pos == this.capacity) {
                this.filled = true;
                this.pos = 0;
            }
            if (len > 0) {
                System.arraycopy(buf, off, this.data, this.pos, len);
                this.pos += len;
            }
        }
    }
}

