/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util.xml;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import jenkins.util.SystemProperties;
import jenkins.util.xml.RestrictiveEntityResolver;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class XMLUtils {
    private static final Logger LOGGER = LogManager.getLogManager().getLogger(XMLUtils.class.getName());
    private static final String DISABLED_PROPERTY_NAME = XMLUtils.class.getName() + ".disableXXEPrevention";
    private static final String FEATURE_HTTP_XML_ORG_SAX_FEATURES_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String FEATURE_HTTP_XML_ORG_SAX_FEATURES_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";

    public static void safeTransform(@NonNull Source source, @NonNull Result out) throws TransformerException, SAXException {
        InputSource src = SAXSource.sourceToInputSource(source);
        if (src != null) {
            SAXTransformerFactory stFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            stFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            try {
                xmlReader.setFeature(FEATURE_HTTP_XML_ORG_SAX_FEATURES_EXTERNAL_GENERAL_ENTITIES, false);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            try {
                xmlReader.setFeature(FEATURE_HTTP_XML_ORG_SAX_FEATURES_EXTERNAL_PARAMETER_ENTITIES, false);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            xmlReader.setEntityResolver(RestrictiveEntityResolver.INSTANCE);
            SAXSource saxSource = new SAXSource(xmlReader, src);
            XMLUtils._transform(saxSource, out);
        } else if (SystemProperties.getBoolean(DISABLED_PROPERTY_NAME)) {
            LOGGER.log(Level.WARNING, "XML external entity (XXE) prevention has been disabled by the system property {0}=true Your system may be vulnerable to XXE attacks.", DISABLED_PROPERTY_NAME);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Caller stack trace: ", new Exception("XXE Prevention caller history"));
            }
            XMLUtils._transform(source, out);
        } else {
            throw new TransformerException("Could not convert source of type " + String.valueOf(source.getClass()) + " and XXEPrevention is enabled.");
        }
    }

    @SuppressFBWarnings(value={"XXE_DOCUMENT"}, justification="newDocumentBuilderFactory() does what FindSecBugs recommends, yet FindSecBugs cannot see this")
    @NonNull
    public static Document parse(@NonNull InputStream stream) throws SAXException, IOException {
        DocumentBuilder docBuilder;
        try {
            docBuilder = XMLUtils.newDocumentBuilderFactory().newDocumentBuilder();
            docBuilder.setEntityResolver(RestrictiveEntityResolver.INSTANCE);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unexpected error creating DocumentBuilder.", e);
        }
        return docBuilder.parse(new InputSource(stream));
    }

    @SuppressFBWarnings(value={"XXE_DOCUMENT"}, justification="newDocumentBuilderFactory() does what FindSecBugs recommends, yet FindSecBugs cannot see this")
    @NonNull
    public static Document parse(@NonNull Reader stream) throws SAXException, IOException {
        DocumentBuilder docBuilder;
        try {
            docBuilder = XMLUtils.newDocumentBuilderFactory().newDocumentBuilder();
            docBuilder.setEntityResolver(RestrictiveEntityResolver.INSTANCE);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unexpected error creating DocumentBuilder.", e);
        }
        return docBuilder.parse(new InputSource(stream));
    }

    @NonNull
    public static Document parse(@NonNull File file) throws SAXException, IOException {
        Document document;
        block9: {
            if (!file.exists() || !file.isFile()) {
                throw new IllegalArgumentException(String.format("File %s does not exist or is not a 'normal' file.", file.getAbsolutePath()));
            }
            InputStream fileInputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                document = XMLUtils.parse(fileInputStream);
                if (fileInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidPathException e) {
                    throw new IOException(e);
                }
            }
            fileInputStream.close();
        }
        return document;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @NonNull
    public static Document parse(@NonNull File file, @NonNull String encoding) throws SAXException, IOException {
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException(String.format("File %s does not exist or is not a 'normal' file.", file.getAbsolutePath()));
        }
        try (InputStream fileInputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            Document document;
            try (InputStreamReader fileReader = new InputStreamReader(fileInputStream, encoding);){
                document = XMLUtils.parse(fileReader);
            }
            return document;
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    @NonNull
    public static String getValue(@NonNull String xpath, @NonNull File file) throws IOException, SAXException, XPathExpressionException {
        return XMLUtils.getValue(xpath, file, Charset.defaultCharset().toString());
    }

    @NonNull
    public static String getValue(@NonNull String xpath, @NonNull File file, @NonNull String fileDataEncoding) throws IOException, SAXException, XPathExpressionException {
        Document document = XMLUtils.parse(file, fileDataEncoding);
        return XMLUtils.getValue(xpath, document);
    }

    public static String getValue(String xpath, Document document) throws XPathExpressionException {
        XPath xPathProcessor = XPathFactory.newInstance().newXPath();
        return xPathProcessor.compile(xpath).evaluate(document);
    }

    private static void _transform(Source source, Result out) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer t = factory.newTransformer();
        t.transform(source, out);
    }

    private static DocumentBuilderFactory newDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        XMLUtils.setDocumentBuilderFactoryFeature(documentBuilderFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        XMLUtils.setDocumentBuilderFactoryFeature(documentBuilderFactory, FEATURE_HTTP_XML_ORG_SAX_FEATURES_EXTERNAL_GENERAL_ENTITIES, false);
        XMLUtils.setDocumentBuilderFactoryFeature(documentBuilderFactory, FEATURE_HTTP_XML_ORG_SAX_FEATURES_EXTERNAL_PARAMETER_ENTITIES, false);
        XMLUtils.setDocumentBuilderFactoryFeature(documentBuilderFactory, "http://apache.org/xml/features/disallow-doctype-decl", true);
        return documentBuilderFactory;
    }

    private static void setDocumentBuilderFactoryFeature(DocumentBuilderFactory documentBuilderFactory, String feature, boolean state) {
        try {
            documentBuilderFactory.setFeature(feature, state);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, String.format("Failed to set the XML Document Builder factory feature %s to %s", feature, state), e);
        }
    }
}

