/*
 * Decompiled with CFR 0.152.
 */
package jenkins.cli.listeners;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.UUID;
import org.springframework.security.core.Authentication;

public class CLIContext {
    private final String correlationId = UUID.randomUUID().toString();
    private final String command;
    private final List<String> args;
    private final Authentication auth;

    public CLIContext(@NonNull String command, @CheckForNull List<String> args, @Nullable Authentication auth) {
        this.command = command;
        this.args = args != null ? args : List.of();
        this.auth = auth;
    }

    @NonNull
    public String getCorrelationId() {
        return this.correlationId;
    }

    @NonNull
    public String getCommand() {
        return this.command;
    }

    @NonNull
    public List<String> getArgs() {
        return this.args;
    }

    @CheckForNull
    public Authentication getAuth() {
        return this.auth;
    }
}

