/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.util.Messages;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class Retrier<V> {
    private static final Logger LOGGER = Logger.getLogger(Retrier.class.getName());
    private int attempts;
    private long delay;
    private Callable<V> callable;
    private BiPredicate<Integer, V> checkResult;
    private String action;
    private BiFunction<Integer, Exception, V> duringActionExceptionListener;
    private Class<?>[] duringActionExceptions;

    private Retrier(Builder<V> builder) {
        this.attempts = builder.attempts;
        this.delay = builder.delay;
        this.callable = builder.callable;
        this.checkResult = builder.checkResult;
        this.action = builder.action;
        this.duringActionExceptionListener = builder.duringActionExceptionListener;
        this.duringActionExceptions = builder.duringActionExceptions;
    }

    @CheckForNull
    public V start() throws Exception {
        Object result = null;
        int currentAttempt = 0;
        boolean success = false;
        while (currentAttempt < this.attempts && !success) {
            block9: {
                ++currentAttempt;
                try {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, Messages.Retrier_Attempt(currentAttempt, this.action));
                    }
                    result = this.callable.call();
                }
                catch (Exception e) {
                    if (this.duringActionExceptions == null || Stream.of(this.duringActionExceptions).noneMatch(exception -> exception.isAssignableFrom(e.getClass()))) {
                        LOGGER.log(Level.WARNING, Messages.Retrier_ExceptionThrown(currentAttempt, this.action), e);
                        throw e;
                    }
                    LOGGER.log(Level.INFO, Messages.Retrier_ExceptionFailed(currentAttempt, this.action), e);
                    if (this.duringActionExceptionListener == null) break block9;
                    LOGGER.log(Level.INFO, Messages.Retrier_CallingListener(e.getLocalizedMessage(), currentAttempt, this.action));
                    result = this.duringActionExceptionListener.apply(currentAttempt, e);
                }
            }
            success = this.checkResult.test(currentAttempt, result);
            if (!success) {
                if (currentAttempt < this.attempts) {
                    LOGGER.log(Level.WARNING, Messages.Retrier_AttemptFailed(currentAttempt, this.action));
                    LOGGER.log(Level.FINE, Messages.Retrier_Sleeping(this.delay, this.action));
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException ie) {
                        LOGGER.log(Level.FINE, Messages.Retrier_Interruption(this.action));
                        Thread.currentThread().interrupt();
                        currentAttempt = this.attempts;
                    }
                    continue;
                }
                LOGGER.log(Level.INFO, Messages.Retrier_NoSuccess(this.action, this.attempts));
                continue;
            }
            LOGGER.log(Level.INFO, Messages.Retrier_Success(this.action, currentAttempt));
        }
        return (V)result;
    }

    public static class Builder<V> {
        private Callable<V> callable;
        private String action;
        private BiPredicate<Integer, V> checkResult;
        private int attempts = 3;
        private long delay = 1000L;
        private BiFunction<Integer, Exception, V> duringActionExceptionListener;
        private Class<?>[] duringActionExceptions;

        @NonNull
        public Builder<V> withAttempts(int attempts) {
            this.attempts = attempts;
            return this;
        }

        @NonNull
        public Builder<V> withDelay(long millis) {
            this.delay = millis;
            return this;
        }

        @NonNull
        public Builder<V> withDuringActionExceptions(@CheckForNull Class<?>[] exceptions) {
            this.duringActionExceptions = exceptions != null ? Arrays.copyOf(exceptions, exceptions.length) : null;
            return this;
        }

        @NonNull
        public Builder<V> withDuringActionExceptionListener(@NonNull BiFunction<Integer, Exception, V> exceptionListener) {
            this.duringActionExceptionListener = exceptionListener;
            return this;
        }

        public Builder(@NonNull Callable<V> callable, @NonNull BiPredicate<Integer, V> checkResult, @NonNull String action) {
            this.callable = callable;
            this.action = action;
            this.checkResult = checkResult;
        }

        @NonNull
        public Retrier<V> build() {
            return new Retrier(this);
        }
    }
}

