/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Main;
import hudson.Util;
import hudson.model.AdministrativeMonitor;
import hudson.model.AperiodicWork;
import hudson.util.Messages;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class DoubleLaunchChecker
extends AdministrativeMonitor {
    private long lastWriteTime = 0L;
    private boolean activated;
    public final File home = Jenkins.get().getRootDir();
    private String collidingId;
    private static final Logger LOGGER = Logger.getLogger(DoubleLaunchChecker.class.getName());

    @Override
    public String getDisplayName() {
        return Messages.DoubleLaunchChecker_duplicate_jenkins_checker();
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    protected void execute() {
        LOGGER.fine("running detector");
        File timestampFile = new File(this.home, ".owner");
        long t = timestampFile.lastModified();
        if (t != 0L && this.lastWriteTime != 0L && t != this.lastWriteTime && this.isEnabled()) {
            try {
                this.collidingId = Files.readString(Util.fileToPath(timestampFile), Charset.defaultCharset());
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to read collision file", e);
            }
            this.activated = true;
            LOGGER.severe("Collision detected. timestamp=" + t + ", expected=" + this.lastWriteTime);
        }
        try {
            Files.writeString(Util.fileToPath(timestampFile), (CharSequence)this.getId(), Charset.defaultCharset(), new OpenOption[0]);
            this.lastWriteTime = timestampFile.lastModified();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, null, e);
            this.lastWriteTime = 0L;
        }
    }

    public String getId() {
        return Long.toString(ProcessHandle.current().pid());
    }

    public String getCollidingId() {
        return this.collidingId;
    }

    @Extension
    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM"}, justification="The random is just used for load distribution.")
    public static final class Schedule
    extends AperiodicWork {
        private final Random random = new Random();

        @Override
        public AperiodicWork getNewInstance() {
            return new Schedule();
        }

        @Override
        public long getRecurrencePeriod() {
            return (Main.isUnitTest ? Duration.ofSeconds(this.random.nextInt(10) + 20) : Duration.ofMinutes(this.random.nextInt(30) + 60)).toMillis();
        }

        @Override
        protected void doAperiodicRun() {
            ExtensionList.lookupSingleton(DoubleLaunchChecker.class).execute();
        }
    }
}

