/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.CheckPoint;
import hudson.model.Describable;
import hudson.tasks.BuildStep;
import java.io.IOException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BuildStepMonitor {
    NONE{

        @Override
        public boolean perform(BuildStep bs, AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
            return bs.perform(build, launcher, listener);
        }
    }
    ,
    STEP{

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean perform(BuildStep bs, AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
            CheckPoint cp = new CheckPoint(bs.getClass().getName(), bs.getClass());
            if (bs instanceof Describable) {
                cp.block(listener, ((Describable)((Object)bs)).getDescriptor().getDisplayName());
            } else {
                cp.block();
            }
            try {
                boolean bl = bs.perform(build, launcher, listener);
                return bl;
            }
            finally {
                cp.report();
            }
        }
    }
    ,
    BUILD{

        @Override
        public boolean perform(BuildStep bs, AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
            if (bs instanceof Describable) {
                CheckPoint.COMPLETED.block(listener, ((Describable)((Object)bs)).getDescriptor().getDisplayName());
            } else {
                CheckPoint.COMPLETED.block();
            }
            return bs.perform(build, launcher, listener);
        }
    };


    public abstract boolean perform(BuildStep var1, AbstractBuild var2, Launcher var3, BuildListener var4) throws IOException, InterruptedException;
}

