/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.CommandInterpreter;
import hudson.tasks.Messages;
import hudson.util.FormValidation;
import hudson.util.LineEndingConversion;
import java.util.ArrayList;
import java.util.List;
import jenkins.tasks.filters.EnvVarsFilterLocalRule;
import jenkins.tasks.filters.EnvVarsFilterLocalRuleDescriptor;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class BatchFile
extends CommandInterpreter {
    private Integer unstableReturn;

    @DataBoundConstructor
    public BatchFile(String command) {
        super(LineEndingConversion.convertEOL(command, LineEndingConversion.EOLType.Windows));
    }

    @Restricted(value={Beta.class})
    @DataBoundSetter
    public void setConfiguredLocalRules(List<EnvVarsFilterLocalRule> configuredLocalRules) {
        this.configuredLocalRules = configuredLocalRules;
    }

    @Override
    public String[] buildCommandLine(FilePath script) {
        return new String[]{"cmd", "/c", "call", script.getRemote()};
    }

    @Override
    protected String getContents() {
        return LineEndingConversion.convertEOL(this.command + "\r\nexit %ERRORLEVEL%", LineEndingConversion.EOLType.Windows);
    }

    @Override
    protected String getFileExtension() {
        return ".bat";
    }

    @CheckForNull
    public final Integer getUnstableReturn() {
        return Integer.valueOf(0).equals(this.unstableReturn) ? null : this.unstableReturn;
    }

    @DataBoundSetter
    public void setUnstableReturn(Integer unstableReturn) {
        this.unstableReturn = unstableReturn;
    }

    @Override
    protected boolean isErrorlevelForUnstableBuild(int exitCode) {
        return this.unstableReturn != null && exitCode != 0 && this.unstableReturn.equals(exitCode);
    }

    private Object readResolve() {
        BatchFile batch = new BatchFile(this.command);
        batch.setUnstableReturn(this.unstableReturn);
        batch.setConfiguredLocalRules(this.configuredLocalRules == null ? new ArrayList() : this.configuredLocalRules);
        return batch;
    }

    @Extension
    @Symbol(value={"batchFile"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        @Override
        public String getHelpFile() {
            return "/help/project-config/batch.html";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.BatchFile_DisplayName();
        }

        @Restricted(value={DoNotUse.class})
        public FormValidation doCheckUnstableReturn(@QueryParameter String value) {
            long unstableReturn;
            if ((value = Util.fixEmptyAndTrim(value)) == null) {
                return FormValidation.ok();
            }
            try {
                unstableReturn = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error(hudson.model.Messages.Hudson_NotANumber());
            }
            if (unstableReturn == 0L) {
                return FormValidation.warning(Messages.BatchFile_invalid_exit_code_zero());
            }
            if (unstableReturn < Integer.MIN_VALUE || unstableReturn > Integer.MAX_VALUE) {
                return FormValidation.error(Messages.BatchFile_invalid_exit_code_range(unstableReturn));
            }
            return FormValidation.ok();
        }

        @Override
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @Restricted(value={NoExternalUse.class})
        public List<EnvVarsFilterLocalRuleDescriptor> getApplicableLocalRules() {
            return EnvVarsFilterLocalRuleDescriptor.allApplicableFor(BatchFile.class);
        }
    }
}

