/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.model.User;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import jenkins.security.seed.UserSeedProperty;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.context.SecurityContextRepository;

public class HttpSessionContextIntegrationFilter2
extends SecurityContextPersistenceFilter {
    public HttpSessionContextIntegrationFilter2(SecurityContextRepository securityContextRepository) {
        super(securityContextRepository);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        Authentication a;
        SecurityContext o;
        HttpSession session = ((HttpServletRequest)req).getSession(false);
        if (session != null && (o = (SecurityContext)session.getAttribute("SPRING_SECURITY_CONTEXT")) != null && (a = o.getAuthentication()) != null && this.hasInvalidSessionSeed(a, session)) {
            session.setAttribute("SPRING_SECURITY_CONTEXT", null);
        }
        super.doFilter(req, res, chain);
    }

    private boolean hasInvalidSessionSeed(Authentication authentication, HttpSession session) {
        User userFromSession;
        if (UserSeedProperty.DISABLE_USER_SEED || authentication instanceof AnonymousAuthenticationToken) {
            return false;
        }
        try {
            userFromSession = User.getById(authentication.getName(), false);
        }
        catch (IllegalStateException ise) {
            this.logger.warn((Object)"Encountered IllegalStateException trying to get a user. System init may not have completed yet. Invalidating user session.");
            return false;
        }
        if (userFromSession == null) {
            return false;
        }
        Object userSessionSeedObject = session.getAttribute("_JENKINS_SESSION_SEED");
        if (!(userSessionSeedObject instanceof String)) {
            return true;
        }
        String actualUserSessionSeed = (String)userSessionSeedObject;
        UserSeedProperty userSeedProperty = userFromSession.getProperty(UserSeedProperty.class);
        if (userSeedProperty == null) {
            return true;
        }
        boolean validSeed = actualUserSessionSeed.equals(userSeedProperty.getSeed());
        return !validSeed;
    }
}

