/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.queue;

import hudson.AbortException;

class Latch {
    private final int n;
    private int i = 0;
    private Exception interrupted;

    Latch(int n) {
        this.n = n;
    }

    public synchronized void abort(Throwable cause) {
        this.interrupted = new AbortException();
        if (cause != null) {
            this.interrupted.initCause(cause);
        }
        this.notifyAll();
    }

    public synchronized void synchronize() throws InterruptedException {
        this.check(this.n);
        try {
            this.onCriteriaMet();
        }
        catch (Error | RuntimeException e) {
            this.abort(e);
            throw e;
        }
        this.check(this.n * 2);
    }

    private void check(int threshold) throws InterruptedException {
        ++this.i;
        if (this.i == threshold) {
            this.notifyAll();
        } else {
            while (this.i < threshold && this.interrupted == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.interrupted = e;
                    this.notifyAll();
                    throw e;
                }
            }
        }
        if (this.interrupted != null) {
            throw (InterruptedException)new InterruptedException().initCause(this.interrupted);
        }
    }

    protected void onCriteriaMet() throws InterruptedException {
    }
}

