/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.Messages;
import hudson.model.ModelObject;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.tasks.BuildWrapper;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import jenkins.util.SystemProperties;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileItemHeadersProvider;
import org.apache.commons.io.FilenameUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class FileParameterValue
extends ParameterValue {
    private static final String FOLDER_NAME = "fileParameters";
    private static final Pattern PROHIBITED_DOUBLE_DOT = Pattern.compile(".*[\\\\/]\\.\\.[\\\\/].*");
    private static final long serialVersionUID = -143427023159076073L;
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean ALLOW_FOLDER_TRAVERSAL_OUTSIDE_WORKSPACE = SystemProperties.getBoolean(FileParameterValue.class.getName() + ".allowFolderTraversalOutsideWorkspace");
    private final transient FileItem file;
    private final String originalFileName;
    private String location;

    @DataBoundConstructor
    public FileParameterValue(String name, FileItem file) {
        this(name, file, FilenameUtils.getName((String)file.getName()));
    }

    @Deprecated
    @SuppressFBWarnings(value={"FILE_UPLOAD_FILENAME"}, justification="TODO needs triage")
    public FileParameterValue(String name, org.apache.commons.fileupload.FileItem file) {
        this(name, file.toFileUpload2FileItem(), FilenameUtils.getName((String)file.getName()));
    }

    public FileParameterValue(String name, File file, String originalFileName) {
        this(name, new FileItemImpl2(file), originalFileName);
    }

    protected FileParameterValue(String name, FileItem file, String originalFileName) {
        super(name);
        this.file = file;
        this.originalFileName = originalFileName;
        this.setLocation(name);
    }

    protected void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public Object getValue() {
        return this.file;
    }

    @Override
    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        env.put(this.name, this.originalFileName);
    }

    @Override
    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return name -> this.name.equals(name) ? this.originalFileName : null;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public FileItem getFile2() {
        return this.file;
    }

    @Deprecated
    public org.apache.commons.fileupload.FileItem getFile() {
        return org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.getFile2());
    }

    @Override
    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        return new BuildWrapper(){

            @Override
            @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="TODO needs triage")
            public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
                if (FileParameterValue.this.location != null && !FileParameterValue.this.location.isEmpty() && FileParameterValue.this.file.getName() != null && !FileParameterValue.this.file.getName().isEmpty()) {
                    listener.getLogger().println("Copying file to " + FileParameterValue.this.location);
                    FilePath ws = build.getWorkspace();
                    if (ws == null) {
                        throw new IllegalStateException("The workspace should be created when setUp method is called");
                    }
                    if (!(ALLOW_FOLDER_TRAVERSAL_OUTSIDE_WORKSPACE || !PROHIBITED_DOUBLE_DOT.matcher(FileParameterValue.this.location).matches() && ws.isDescendant(FileParameterValue.this.location))) {
                        listener.error("Rejecting file path escaping base directory with relative path: " + FileParameterValue.this.location);
                        return null;
                    }
                    FilePath locationFilePath = ws.child(FileParameterValue.this.location);
                    locationFilePath.getParent().mkdirs();
                    if (locationFilePath.exists() && !locationFilePath.isDirectory()) {
                        locationFilePath.delete();
                    }
                    locationFilePath.copyFrom(FileParameterValue.this.file);
                    locationFilePath.copyTo(new FilePath(FileParameterValue.this.getLocationUnderBuild(build)));
                }
                return new BuildWrapper.Environment(){};
            }
        };
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileParameterValue other = (FileParameterValue)obj;
        return this.location == null && other.location == null;
    }

    public String toString() {
        return "(FileParameterValue) " + this.getName() + "='" + this.originalFileName + "'";
    }

    @Override
    public String getShortDescription() {
        return this.name + "=" + this.originalFileName;
    }

    public DirectoryBrowserSupport doDynamic(StaplerRequest2 request, StaplerResponse2 response) {
        AbstractBuild build = (AbstractBuild)request.findAncestor(AbstractBuild.class).getObject();
        File fileParameter = this.getFileParameterFolderUnderBuild(build);
        return new DirectoryBrowserSupport((ModelObject)build, new FilePath(fileParameter), Messages.FileParameterValue_IndexTitle(), "folder.png", false);
    }

    private File getLocationUnderBuild(AbstractBuild build) {
        return new File(this.getFileParameterFolderUnderBuild(build), this.location);
    }

    private File getFileParameterFolderUnderBuild(AbstractBuild<?, ?> build) {
        return new File(build.getRootDir(), FOLDER_NAME);
    }

    public static final class FileItemImpl2
    implements FileItem {
        private final File file;

        public FileItemImpl2(File file) {
            if (file == null) {
                throw new NullPointerException("file");
            }
            this.file = file;
        }

        public InputStream getInputStream() throws IOException {
            return Files.newInputStream(Util.fileToPath(this.file), new OpenOption[0]);
        }

        public String getContentType() {
            return null;
        }

        public String getName() {
            return this.file.getName();
        }

        public boolean isInMemory() {
            return false;
        }

        public long getSize() {
            return this.file.length();
        }

        public byte[] get() throws IOException {
            return Files.readAllBytes(this.file.toPath());
        }

        public String getString(Charset toCharset) throws IOException {
            return new String(this.get(), toCharset);
        }

        public String getString() throws IOException {
            return new String(this.get(), Charset.defaultCharset());
        }

        public FileItem write(Path to) throws IOException {
            try {
                new FilePath(this.file).copyTo(new FilePath(to.toFile()));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public FileItem delete() throws IOException {
            Files.deleteIfExists(Util.fileToPath(this.file));
            return this;
        }

        public String getFieldName() {
            return null;
        }

        public FileItem setFieldName(String name) {
            return this;
        }

        public boolean isFormField() {
            return false;
        }

        public FileItem setFormField(boolean state) {
            return this;
        }

        @Deprecated
        public OutputStream getOutputStream() throws IOException {
            return Files.newOutputStream(Util.fileToPath(this.file), new OpenOption[0]);
        }

        public org.apache.commons.fileupload2.core.FileItemHeaders getHeaders() {
            return FileItemFactory.AbstractFileItemBuilder.newFileItemHeaders();
        }

        public FileItemHeadersProvider setHeaders(org.apache.commons.fileupload2.core.FileItemHeaders headers) {
            return this;
        }
    }

    @Deprecated
    public static final class FileItemImpl
    implements org.apache.commons.fileupload.FileItem {
        private final FileItem delegate;

        public FileItemImpl(File file) {
            if (file == null) {
                throw new NullPointerException("file");
            }
            this.delegate = new FileItemImpl2(file);
        }

        public InputStream getInputStream() throws IOException {
            return org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).getInputStream();
        }

        public String getContentType() {
            return org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).getContentType();
        }

        @SuppressFBWarnings(value={"FILE_UPLOAD_FILENAME"}, justification="for compatibility")
        public String getName() {
            return org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).getName();
        }

        public boolean isInMemory() {
            return org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).isInMemory();
        }

        public long getSize() {
            return org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).getSize();
        }

        public byte[] get() {
            return org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).get();
        }

        public String getString(String encoding) throws UnsupportedEncodingException {
            return org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).getString(encoding);
        }

        public String getString() {
            return org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).getString();
        }

        public void write(File to) throws Exception {
            org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).write(to);
        }

        public void delete() {
            org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).delete();
        }

        public String getFieldName() {
            return org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).getFieldName();
        }

        public void setFieldName(String name) {
            org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).setFieldName(name);
        }

        public boolean isFormField() {
            return org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).isFormField();
        }

        public void setFormField(boolean state) {
            org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).setFormField(state);
        }

        @Deprecated
        public OutputStream getOutputStream() throws IOException {
            return org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).getOutputStream();
        }

        public FileItemHeaders getHeaders() {
            return org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).getHeaders();
        }

        public void setHeaders(FileItemHeaders headers) {
            org.apache.commons.fileupload.FileItem.fromFileUpload2FileItem((FileItem)this.delegate).setHeaders(headers);
        }

        public FileItem toFileUpload2FileItem() {
            return this.delegate;
        }
    }
}

