/*
 * Decompiled with CFR 0.152.
 */
package hudson.markup;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import hudson.markup.MarkupFormatterDescriptor;
import hudson.model.Describable;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.verb.GET;
import org.kohsuke.stapler.verb.POST;

public abstract class MarkupFormatter
implements Describable<MarkupFormatter>,
ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(MarkupFormatter.class.getName());
    private static boolean PREVIEWS_ALLOW_GET = SystemProperties.getBoolean(MarkupFormatter.class.getName() + ".previewsAllowGET");
    private static boolean PREVIEWS_SET_CSP = SystemProperties.getBoolean(MarkupFormatter.class.getName() + ".previewsSetCSP", true);

    public abstract void translate(@CheckForNull String var1, @NonNull Writer var2) throws IOException;

    @NonNull
    public final String translate(@CheckForNull String markup) throws IOException {
        StringWriter w = new StringWriter();
        this.translate(markup, w);
        return w.toString();
    }

    public String getHelpUrl() {
        return this.getDescriptor().getHelpFile("syntax");
    }

    public MarkupFormatterDescriptor getDescriptor() {
        return (MarkupFormatterDescriptor)Describable.super.getDescriptor();
    }

    @POST
    public HttpResponse doPreviewDescription(@QueryParameter String text) throws IOException {
        StringWriter w = new StringWriter();
        this.translate(text, w);
        Map<String, String> extraHeaders = Collections.emptyMap();
        if (PREVIEWS_SET_CSP) {
            extraHeaders = Stream.of("Content-Security-Policy", "X-WebKit-CSP", "X-Content-Security-Policy").collect(Collectors.toMap(Function.identity(), v -> "default-src 'none';"));
        }
        return MarkupFormatter.html(200, w.toString(), extraHeaders);
    }

    @GET
    @WebMethod(name={"previewDescription"})
    @Restricted(value={NoExternalUse.class})
    public HttpResponse previewsNowNeedPostForSecurity2153(@QueryParameter String text, StaplerRequest2 req) throws IOException {
        LOGGER.log(Level.FINE, "Received a GET request at " + String.valueOf(req.getRequestURL()));
        if (PREVIEWS_ALLOW_GET) {
            return this.doPreviewDescription(text);
        }
        return MarkupFormatter.html(405, "This endpoint now requires that POST requests are sent. Update the component implementing this preview feature.", Collections.emptyMap());
    }

    private static HttpResponse html(final int status, final @NonNull String html, final @NonNull Map<String, String> headers) {
        return new HttpResponse(){

            public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
                rsp.setContentType("text/html;charset=UTF-8");
                rsp.setStatus(status);
                for (Map.Entry header : headers.entrySet()) {
                    rsp.setHeader((String)header.getKey(), (String)header.getValue());
                }
                PrintWriter pw = rsp.getWriter();
                pw.print(html);
                pw.flush();
            }
        };
    }
}

