/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.define;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.tags.define.BeanTag;
import org.apache.commons.jelly.util.ClassLoaderUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassLoaderTag
extends BeanTag {
    private static final Log log = LogFactory.getLog(ClassLoaderTag.class);
    private String var;
    private String url;

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        if (this.getVar() == null) {
            throw new MissingAttributeException("var");
        }
        if (this.getUrl() == null) {
            throw new MissingAttributeException("url");
        }
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = ClassLoaderUtils.getClassLoader(((Object)((Object)this)).getClass());
        }
        URLClassLoader newClassLoader = null;
        try {
            newClassLoader = new URLClassLoader(new URL[]{new URL(this.getUrl())}, parent);
        }
        catch (MalformedURLException e) {
            throw new JellyTagException((Throwable)e);
        }
        log.debug((Object)("Storing the new classloader in " + this.getVar()));
        this.context.setVariable(this.getVar(), (Object)newClassLoader);
    }
}

