/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import net.sf.json.JsonConfig;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.DataWriter;
import org.kohsuke.stapler.export.ExportConfig;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;
import org.kohsuke.stapler.export.NamedPathPruner;
import org.kohsuke.stapler.export.TreePruner;

public class ResponseImpl
extends HttpServletResponseWrapper
implements StaplerResponse2 {
    private final Stapler stapler;
    private final HttpServletResponse response;
    private OutputMode mode = null;
    private Throwable origin;
    private JsonConfig jsonConfig;
    private Object output = null;
    static ModelBuilder MODEL_BUILDER = new ModelBuilder();

    public ResponseImpl(Stapler stapler, HttpServletResponse response) {
        super(response);
        this.stapler = stapler;
        this.response = response;
    }

    @Deprecated
    public ResponseImpl(Stapler stapler, javax.servlet.http.HttpServletResponse response) {
        this(stapler, io.jenkins.servlet.http.HttpServletResponseWrapper.toJakartaHttpServletResponse(response));
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.mode == OutputMode.CHAR) {
            throw new IllegalStateException("getWriter has already been called. Its call site is in the nested exception", this.origin);
        }
        if (this.mode == null) {
            this.recordOutput(super.getOutputStream());
        }
        return (ServletOutputStream)this.output;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.mode == OutputMode.BYTE) {
            throw new IllegalStateException("getOutputStream has already been called. Its call site is in the nested exception", this.origin);
        }
        if (this.mode == null) {
            this.recordOutput(super.getWriter());
        }
        return (PrintWriter)this.output;
    }

    private <T extends ServletOutputStream> T recordOutput(T obj) {
        this.output = obj;
        this.mode = OutputMode.BYTE;
        this.origin = new Throwable();
        return obj;
    }

    private <T extends PrintWriter> T recordOutput(T obj) {
        this.output = obj;
        this.mode = OutputMode.CHAR;
        this.origin = new Throwable();
        return obj;
    }

    @Override
    public void forward(Object it, String url, StaplerRequest2 request) throws ServletException, IOException {
        this.stapler.invoke(request, this.response, it, url);
    }

    @Override
    public void forwardToPreviousPage(StaplerRequest2 request) throws ServletException, IOException {
        String referer = request.getHeader("Referer");
        if (referer == null) {
            referer = ".";
        }
        this.sendRedirect(referer);
    }

    public void sendRedirect(@NonNull String url) throws IOException {
        if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("/")) {
            super.sendRedirect(url);
            return;
        }
        Object base = Stapler.getCurrentRequest2().getRequestURI();
        base = ((String)base).substring(0, ((String)base).lastIndexOf(47) + 1);
        if (!url.equals(".")) {
            base = (String)base + url;
        }
        super.sendRedirect((String)base);
    }

    @Override
    public void sendRedirect2(@NonNull String url) throws IOException {
        this.sendRedirect(ResponseImpl.encode(url));
    }

    @Override
    public void sendRedirect(int statusCode, @NonNull String url) throws IOException {
        if (statusCode == 302) {
            this.sendRedirect((String)url);
            return;
        }
        if (((String)url).startsWith("http://") || ((String)url).startsWith("https://")) {
            url = ResponseImpl.encode((String)url);
        } else {
            StaplerRequest2 req = Stapler.getCurrentRequest2();
            if (!((String)url).startsWith("/")) {
                String base = req.getRequestURI();
                base = base.substring(0, base.lastIndexOf(47) + 1);
                url = !((String)url).equals(".") ? base + ResponseImpl.encode((String)url) : base;
                assert (((String)url).startsWith("/"));
            }
            StringBuilder buf = new StringBuilder(req.getScheme()).append("://").append(req.getServerName());
            if (req.getScheme().equals("http") && req.getServerPort() != 80 || req.getScheme().equals("https") && req.getServerPort() != 443) {
                buf.append(':').append(req.getServerPort());
            }
            url = buf.append((String)url).toString();
        }
        this.setStatus(statusCode);
        this.setLocation((String)url);
        this.getOutputStream().close();
    }

    private void setLocation(@NonNull String url) {
        this.setHeader("Location", url);
    }

    @Override
    public void serveFile(StaplerRequest2 req, URL resource, long expiration) throws ServletException, IOException {
        if (!this.stapler.serveStaticResource((HttpServletRequest)req, (StaplerResponse2)this, resource, expiration)) {
            this.sendError(404);
        }
    }

    @Override
    public void serveFile(StaplerRequest2 req, URL resource) throws ServletException, IOException {
        this.serveFile(req, resource, -1L);
    }

    @Override
    public void serveLocalizedFile(StaplerRequest2 request, URL res) throws ServletException, IOException {
        this.serveLocalizedFile(request, res, -1L);
    }

    @Override
    public void serveLocalizedFile(StaplerRequest2 request, URL res, long expiration) throws ServletException, IOException {
        if (!this.stapler.serveStaticResource((HttpServletRequest)request, (StaplerResponse2)this, this.stapler.selectResourceByLocale(res, request.getLocale()), expiration)) {
            this.sendError(404);
        }
    }

    @Override
    public void serveFile(StaplerRequest2 req, InputStream data, long lastModified, long expiration, long contentLength, String fileName) throws ServletException, IOException {
        if (!this.stapler.serveStaticResource(req, this, data, lastModified, expiration, contentLength, fileName)) {
            this.sendError(404);
        }
    }

    @Override
    public void serveFile(StaplerRequest2 req, InputStream data, long lastModified, long expiration, int contentLength, String fileName) throws ServletException, IOException {
        this.serveFile(req, data, lastModified, expiration, (long)contentLength, fileName);
    }

    @Override
    public void serveFile(StaplerRequest2 req, InputStream data, long lastModified, long contentLength, String fileName) throws ServletException, IOException {
        this.serveFile(req, data, lastModified, -1L, contentLength, fileName);
    }

    @Override
    public void serveFile(StaplerRequest2 req, InputStream data, long lastModified, int contentLength, String fileName) throws ServletException, IOException {
        this.serveFile(req, data, lastModified, (long)contentLength, fileName);
    }

    @Override
    public void serveExposedBean(StaplerRequest2 req, Object exposedBean, Flavor flavor) throws ServletException, IOException {
        this.serveExposedBean(req, exposedBean, new ExportConfig().withFlavor(flavor).withPrettyPrint(req.hasParameter("pretty")));
    }

    @Override
    public void serveExposedBean(StaplerRequest2 req, Object exposedBean, ExportConfig config) throws ServletException, IOException {
        TreePruner pruner;
        String tree;
        String pad = null;
        Flavor flavor = config.getFlavor();
        this.setContentType(flavor.contentType);
        PrintWriter w = this.getWriter();
        if (flavor == Flavor.JSONP && (pad = req.getParameter("jsonp")) != null) {
            ((Writer)w).write(pad + "(");
        }
        if ((tree = req.getParameter("tree")) != null) {
            try {
                pruner = new NamedPathPruner(tree);
            }
            catch (IllegalArgumentException x) {
                throw new ServletException("Malformed tree expression: " + String.valueOf(x), (Throwable)x);
            }
        }
        int depth = 0;
        try {
            String s = req.getParameter("depth");
            if (s != null) {
                depth = Integer.parseInt(s);
            }
        }
        catch (NumberFormatException e) {
            throw new ServletException("Depth parameter must be a number");
        }
        pruner = new TreePruner.ByDepth(1 - depth);
        DataWriter dw = flavor.createDataWriter(exposedBean, w, config);
        if (exposedBean instanceof Object[]) {
            dw.startArray();
            for (Object item : (Object[])exposedBean) {
                this.writeOne(pruner, dw, item);
            }
            dw.endArray();
        } else {
            this.writeOne(pruner, dw, exposedBean);
        }
        if (pad != null) {
            ((Writer)w).write(41);
        }
        ((Writer)w).close();
    }

    private void writeOne(TreePruner pruner, DataWriter dw, Object item) throws IOException {
        Model<?> p = MODEL_BUILDER.get(item.getClass());
        p.writeTo(item, pruner, dw);
    }

    @Override
    public OutputStream getCompressedOutputStream(HttpServletRequest req) throws IOException {
        return this.getOutputStream();
    }

    @Override
    public Writer getCompressedWriter(HttpServletRequest req) throws IOException {
        return this.getWriter();
    }

    @Override
    public int reverseProxyTo(URL url, StaplerRequest2 req) throws IOException {
        HttpURLConnection con = ResponseImpl.openConnection(url);
        con.setDoOutput(true);
        Enumeration h = req.getHeaderNames();
        while (h.hasMoreElements()) {
            String key = (String)h.nextElement();
            Enumeration v = req.getHeaders(key);
            while (v.hasMoreElements()) {
                con.addRequestProperty(key, (String)v.nextElement());
            }
        }
        con.setRequestMethod(req.getMethod());
        this.copyAndClose((InputStream)req.getInputStream(), con.getOutputStream());
        int code = con.getResponseCode();
        this.setStatus(con, code);
        Map<String, List<String>> rspHeaders = con.getHeaderFields();
        for (Map.Entry<String, List<String>> header : rspHeaders.entrySet()) {
            if (header.getKey() == null) continue;
            for (String value : header.getValue()) {
                this.addHeader(header.getKey(), value);
            }
        }
        this.copyAndClose(con.getInputStream(), (OutputStream)this.getOutputStream());
        return code;
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Not relevant in this situation.")
    private static HttpURLConnection openConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    private void setStatus(HttpURLConnection con, int code) throws IOException {
        this.setStatus(code, con.getResponseMessage());
    }

    @Override
    public void setJsonConfig(JsonConfig config) {
        this.jsonConfig = config;
    }

    @Override
    public JsonConfig getJsonConfig() {
        if (this.jsonConfig == null) {
            this.jsonConfig = new JsonConfig();
        }
        return this.jsonConfig;
    }

    private void copyAndClose(InputStream in, OutputStream out) throws IOException {
        IOUtils.copy((InputStream)in, (OutputStream)out);
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    @NonNull
    public static String encode(@NonNull String s) {
        try {
            boolean escaped = false;
            StringBuilder out = new StringBuilder(s.length());
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)buf, StandardCharsets.UTF_8);
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c < '\u0080' && c != ' ') {
                    out.append(c);
                    continue;
                }
                w.write(c);
                w.flush();
                for (byte b : buf.toByteArray()) {
                    out.append('%');
                    out.append(ResponseImpl.toDigit(b >> 4 & 0xF));
                    out.append(ResponseImpl.toDigit(b & 0xF));
                }
                buf.reset();
                escaped = true;
            }
            return escaped ? out.toString() : s;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private static char toDigit(int n) {
        char ch = Character.forDigit(n, 16);
        if (ch >= 'a') {
            ch = (char)(ch - 97 + 65);
        }
        return ch;
    }

    static enum OutputMode {
        BYTE,
        CHAR;

    }
}

