/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import net.sf.json.JSONArray;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.DirectoryishDispatcher;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.DispatchersFilter;
import org.kohsuke.stapler.Facet;
import org.kohsuke.stapler.Function;
import org.kohsuke.stapler.FunctionList;
import org.kohsuke.stapler.HttpDeletable;
import org.kohsuke.stapler.IndexDispatcher;
import org.kohsuke.stapler.IndexHtmlDispatcher;
import org.kohsuke.stapler.JavaScriptMethodContext;
import org.kohsuke.stapler.KlassDescriptor;
import org.kohsuke.stapler.LimitedTo;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.NameBasedDispatcher;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.SingleLinkedList;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.TearOffSupport;
import org.kohsuke.stapler.TraversalMethodContext;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.WebMethodContext;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.lang.FieldRef;
import org.kohsuke.stapler.lang.Klass;
import org.kohsuke.stapler.lang.MethodRef;

public class MetaClass
extends TearOffSupport {
    private static final Logger LOGGER = Logger.getLogger(MetaClass.class.getName());
    @Deprecated
    public final Class clazz;
    public final Klass<?> klass;
    public final MetaClassLoader classLoader;
    public final List<Dispatcher> dispatchers = new ArrayList<Dispatcher>();
    public final MetaClass baseClass;
    public final WebApp webApp;
    private volatile SingleLinkedList<MethodRef> postConstructMethods;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_REFACTORED_TO_BE_FINAL"}, justification="Legacy switch.")
    public static boolean NO_CACHE = false;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_REFACTORED_TO_BE_FINAL"}, justification="Legacy switch.")
    public static boolean LEGACY_GETTER_MODE = false;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_REFACTORED_TO_BE_FINAL"}, justification="Legacy switch.")
    public static boolean LEGACY_WEB_METHOD_MODE = false;

    MetaClass(WebApp webApp, Klass<?> klass) {
        this.clazz = klass.toJavaClass();
        this.klass = klass;
        this.webApp = webApp;
        this.baseClass = webApp.getMetaClass(klass.getSuperClass());
        this.classLoader = MetaClassLoader.get(this.clazz.getClassLoader());
        this.buildDispatchers();
    }

    void buildDispatchers() {
        FunctionList filteredGetMethods;
        this.dispatchers.clear();
        KlassDescriptor node = new KlassDescriptor(this.klass);
        this.dispatchers.add(new DirectoryishDispatcher());
        if (HttpDeletable.class.isAssignableFrom(this.clazz)) {
            this.dispatchers.add(new HttpDeletable.HttpDeletableDispatcher());
        }
        this.registerDoToken(node);
        for (Function function : node.methods.name("doIndex")) {
            this.dispatchers.add(new IndexDispatcher(function.contextualize(new WebMethodContext(""))));
        }
        for (Function function : node.methods.prefix("js")) {
            String name = MetaClass.camelize(function.getName().substring(2));
            Function function2 = function.contextualize(new JavaScriptMethodContext(name));
            this.dispatchers.add(new JavaScriptProxyMethodDispatcher(name, function2));
        }
        for (Function function : node.methods.annotated(JavaScriptMethod.class)) {
            JavaScriptMethod a = function.getAnnotation(JavaScriptMethod.class);
            String[] names = a != null && a.name().length > 0 ? a.name() : new String[]{function.getName()};
            for (String name : names) {
                this.dispatchers.add(new JavaScriptProxyMethodDispatcher(name, function.contextualize(new JavaScriptMethodContext(name))));
            }
        }
        for (Facet facet : this.webApp.facets) {
            facet.buildViewDispatchers(this, this.dispatchers);
        }
        for (Facet facet : this.webApp.facets) {
            facet.buildIndexDispatchers(this, this.dispatchers);
        }
        Dispatcher d = IndexHtmlDispatcher.make(this.webApp.getServletContext(), this.clazz);
        if (d != null) {
            this.dispatchers.add(d);
        }
        for (final FieldRef f : node.fields) {
            final boolean accepted = this.webApp.getFilterForFields().keep(f);
            this.dispatchers.add(new NameBasedDispatcher(f.getName()){
                final String role;
                {
                    super(name);
                    this.role = MetaClass.this.getProtectedRole(f);
                }

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException {
                    if (accepted) {
                        if (this.role != null && !req.isUserInRole(this.role)) {
                            throw new IllegalAccessException("Needs to be in role " + this.role);
                        }
                        Dispatcher.anonymizedTraceEval(req, rsp, node, "%s#%s", f.getName());
                        if (1.traceable()) {
                            1.traceEval(req, rsp, node, f.getName());
                        }
                        req.getStapler().invoke(req, rsp, f.get(node));
                        return true;
                    }
                    return MetaClass.this.webApp.getFilteredFieldTriggerListener().onFieldTrigger(f, req, rsp, node, f.getQualifiedName());
                }

                @Override
                public String toString() {
                    if (accepted) {
                        return String.format("%3$s %1$s for url=/%2$s/...", f.getQualifiedName(), f.getName(), f.getReturnType());
                    }
                    return String.format("BLOCKED: %3$s %1$s for url=/%2$s/...", f.getQualifiedName(), f.getName(), f.getReturnType());
                }
            });
        }
        FunctionList functionList = node.methods.prefix("get").filter(m -> !m.getSignature().equals("method java.lang.Object getClass"));
        if (LEGACY_GETTER_MODE || this.webApp.getFilterForGetMethods() == null) {
            LOGGER.log(Level.FINE, "Stapler is using the legacy GETTER_MODE");
            filteredGetMethods = functionList;
        } else {
            List<Function> excludedByNew;
            filteredGetMethods = functionList.filter(this.webApp.getFilterForGetMethods());
            if (LOGGER.isLoggable(Level.FINER) && !(excludedByNew = this.minus(functionList, filteredGetMethods)).isEmpty()) {
                for (Function excluded : excludedByNew) {
                    LOGGER.log(Level.FINER, "The following method is now blocked: {0}", excluded.getDisplayName());
                }
            }
        }
        for (final Function function : functionList.signature(new Class[0])) {
            if (function.getName().length() <= 3) continue;
            String name = MetaClass.camelize(function.getName().substring(3));
            final Function ff = function.contextualize(new TraversalMethodContext(name));
            final boolean isAccepted = filteredGetMethods.contains(function);
            this.dispatchers.add(new NameBasedDispatcher(name){

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    if (isAccepted) {
                        Dispatcher.anonymizedTraceEval(req, rsp, node, "%s#%s()", ff.getName());
                        if (2.traceable()) {
                            2.traceEval(req, rsp, node, ff.getName() + "()");
                        }
                        req.getStapler().invoke(req, rsp, ff.invoke(req, rsp, node, new Object[0]));
                        return true;
                    }
                    return MetaClass.this.webApp.getFilteredGetterTriggerListener().onGetterTrigger(function, req, rsp, node, ff.getName() + "()");
                }

                @Override
                public String toString() {
                    if (isAccepted) {
                        return String.format("%3$s %1$s() for url=/%2$s/...", ff.getQualifiedName(), this.name, ff.getReturnType().getName());
                    }
                    return String.format("BLOCKED: %3$s %1$s() for url=/%2$s/...", ff.getQualifiedName(), this.name, ff.getReturnType().getName());
                }
            });
        }
        for (final Function function : functionList.signature(StaplerRequest2.class)) {
            if (function.getName().length() <= 3) continue;
            String name = MetaClass.camelize(function.getName().substring(3));
            final Function ff = function.contextualize(new TraversalMethodContext(name));
            final boolean isAccepted = filteredGetMethods.contains(function);
            this.dispatchers.add(new NameBasedDispatcher(name){

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    if (isAccepted) {
                        Dispatcher.anonymizedTraceEval(req, rsp, node, "%s#%s(...)", ff.getName());
                        if (3.traceable()) {
                            3.traceEval(req, rsp, node, ff.getName() + "(...)");
                        }
                        req.getStapler().invoke(req, rsp, ff.invoke(req, rsp, node, req));
                        return true;
                    }
                    return MetaClass.this.webApp.getFilteredGetterTriggerListener().onGetterTrigger(function, req, rsp, node, ff.getName() + "(...)");
                }

                @Override
                public String toString() {
                    if (isAccepted) {
                        return String.format("%3$s %1$s(StaplerRequest2) for url=/%2$s/...", ff.getQualifiedName(), this.name, ff.getReturnType().getName());
                    }
                    return String.format("BLOCKED: %3$s %1$s(StaplerRequest2) for url=/%2$s/...", ff.getQualifiedName(), this.name, ff.getReturnType().getName());
                }
            });
        }
        for (final Function function : functionList.signature(StaplerRequest.class)) {
            if (function.getName().length() <= 3) continue;
            String name = MetaClass.camelize(function.getName().substring(3));
            final Function ff = function.contextualize(new TraversalMethodContext(name));
            final boolean isAccepted = filteredGetMethods.contains(function);
            this.dispatchers.add(new NameBasedDispatcher(name){

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    if (isAccepted) {
                        Dispatcher.anonymizedTraceEval(req, rsp, node, "%s#%s(...)", ff.getName());
                        if (4.traceable()) {
                            4.traceEval(req, rsp, node, ff.getName() + "(...)");
                        }
                        req.getStapler().invoke(req, rsp, ff.invoke(req, rsp, node, StaplerRequest.fromStaplerRequest2(req)));
                        return true;
                    }
                    return MetaClass.this.webApp.getFilteredGetterTriggerListener().onGetterTrigger(function, req, rsp, node, ff.getName() + "(...)");
                }

                @Override
                public String toString() {
                    if (isAccepted) {
                        return String.format("%3$s %1$s(StaplerRequest) for url=/%2$s/...", ff.getQualifiedName(), this.name, ff.getReturnType().getName());
                    }
                    return String.format("BLOCKED: %3$s %1$s(StaplerRequest) for url=/%2$s/...", ff.getQualifiedName(), this.name, ff.getReturnType().getName());
                }
            });
        }
        for (final Function function : functionList.signature(String.class)) {
            if (function.getName().length() <= 3) continue;
            String name = MetaClass.camelize(function.getName().substring(3));
            final Function ff = function.contextualize(new TraversalMethodContext(name));
            final boolean isAccepted = filteredGetMethods.contains(function);
            this.dispatchers.add(new NameBasedDispatcher(name, 1){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    if (isAccepted) {
                        String token = req.tokens.next();
                        Dispatcher.anonymizedTraceEval(req, rsp, node, "%s#%s(String)", ff.getName());
                        if (5.traceable()) {
                            5.traceEval(req, rsp, node, ff.getName() + "(\"" + token + "\")");
                        }
                        req.getStapler().invoke(req, rsp, ff.invoke(req, rsp, node, token));
                        return true;
                    }
                    String token = req.tokens.next();
                    try {
                        boolean bl = MetaClass.this.webApp.getFilteredGetterTriggerListener().onGetterTrigger(function, req, rsp, node, ff.getName() + "(\"" + token + "\")");
                        return bl;
                    }
                    finally {
                        req.tokens.prev();
                    }
                }

                @Override
                public String toString() {
                    if (isAccepted) {
                        return String.format("%3$s %1$s(String) for url=/%2$s/TOKEN/...", ff.getQualifiedName(), this.name, ff.getReturnType().getName());
                    }
                    return String.format("BLOCKED: %3$s %1$s(String) for url=/%2$s/TOKEN/...", ff.getQualifiedName(), this.name, ff.getReturnType().getName());
                }
            });
        }
        for (final Function function : functionList.signature(Integer.TYPE)) {
            if (function.getName().length() <= 3) continue;
            String name = MetaClass.camelize(function.getName().substring(3));
            final Function ff = function.contextualize(new TraversalMethodContext(name));
            final boolean isAccepted = filteredGetMethods.contains(function);
            this.dispatchers.add(new NameBasedDispatcher(name, 1){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    if (isAccepted) {
                        int idx = req.tokens.nextAsInt();
                        Dispatcher.anonymizedTraceEval(req, rsp, node, "%s#%s(int)", ff.getName());
                        if (6.traceable()) {
                            6.traceEval(req, rsp, node, ff.getName() + "(" + idx + ")");
                        }
                        req.getStapler().invoke(req, rsp, ff.invoke(req, rsp, node, idx));
                        return true;
                    }
                    int idx = req.tokens.nextAsInt();
                    try {
                        boolean bl = MetaClass.this.webApp.getFilteredGetterTriggerListener().onGetterTrigger(function, req, rsp, node, ff.getName() + "(" + idx + ")");
                        return bl;
                    }
                    finally {
                        req.tokens.prev();
                    }
                }

                @Override
                public String toString() {
                    if (isAccepted) {
                        return String.format("%3$s %1$s(int) for url=/%2$s/N/...", ff.getQualifiedName(), this.name, ff.getReturnType().getName());
                    }
                    return String.format("BLOCKED: %3$s %1$s(int) for url=/%2$s/N/...", ff.getQualifiedName(), this.name, ff.getReturnType().getName());
                }
            });
        }
        for (final Function function : functionList.signature(Long.TYPE)) {
            if (function.getName().length() <= 3) continue;
            String name = MetaClass.camelize(function.getName().substring(3));
            final Function ff = function.contextualize(new TraversalMethodContext(name));
            final boolean isAccepted = filteredGetMethods.contains(function);
            this.dispatchers.add(new NameBasedDispatcher(name, 1){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    if (isAccepted) {
                        long idx = req.tokens.nextAsLong();
                        Dispatcher.anonymizedTraceEval(req, rsp, node, "%s#%s(long)", ff.getName());
                        if (7.traceable()) {
                            7.traceEval(req, rsp, node, ff.getName() + "(" + idx + ")");
                        }
                        req.getStapler().invoke(req, rsp, ff.invoke(req, rsp, node, idx));
                        return true;
                    }
                    long idx = req.tokens.nextAsLong();
                    try {
                        boolean bl = MetaClass.this.webApp.getFilteredGetterTriggerListener().onGetterTrigger(function, req, rsp, node, ff.getName() + "(" + idx + ")");
                        return bl;
                    }
                    finally {
                        req.tokens.prev();
                    }
                }

                @Override
                public String toString() {
                    if (isAccepted) {
                        return String.format("%3$s %1$s(long) for url=/%2$s/N/...", ff.getQualifiedName(), this.name, ff.getReturnType().getName());
                    }
                    return String.format("BLOCKED: %3$s %1$s(long) for url=/%2$s/N/...", ff.getQualifiedName(), this.name, ff.getReturnType().getName());
                }
            });
        }
        if (this.klass.isArray()) {
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    try {
                        int index = req.tokens.nextAsInt();
                        Dispatcher.anonymizedTraceEval(req, rsp, node, "%s[idx]", new String[0]);
                        if (8.traceable()) {
                            8.traceEval(req, rsp, node, "", "[" + index + "]");
                        }
                        req.getStapler().invoke(req, rsp, MetaClass.this.klass.getArrayElement(node, index));
                        return true;
                    }
                    catch (IndexOutOfBoundsException e) {
                        if (8.traceable()) {
                            8.trace(req, rsp, "-> IndexOutOfRange");
                        }
                        rsp.sendError(404);
                        return true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }

                @Override
                public String toString() {
                    return "Array look-up for url=/N/...";
                }
            });
        }
        if (this.klass.isMap()) {
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    try {
                        Object item;
                        String key = req.tokens.peek();
                        Dispatcher.anonymizedTraceEval(req, rsp, node, "%s: Map access", new String[0]);
                        if (9.traceable()) {
                            9.traceEval(req, rsp, "", ".get(\"" + key + "\")");
                        }
                        if ((item = MetaClass.this.klass.getMapElement(node, key)) != null) {
                            req.tokens.next();
                            req.getStapler().invoke(req, rsp, item);
                            return true;
                        }
                        if (9.traceable()) {
                            9.trace(req, rsp, "Map.get(\"" + key + "\")==null. Back tracking.");
                        }
                        return false;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }

                @Override
                public String toString() {
                    return "Map.get(String) look-up for url=/TOKEN/...";
                }
            });
        }
        for (Facet facet : this.webApp.facets) {
            facet.buildFallbackDispatchers(this, this.dispatchers);
        }
        for (Function function : functionList.signatureStartsWith(String.class).name("getDynamic")) {
            final Function ff = function.contextualize(new TraversalMethodContext("\u0000"));
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, IOException, ServletException {
                    Object target;
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    String token = req.tokens.next();
                    Dispatcher.anonymizedTraceEval(req, rsp, node, "%s#getDynamic(...)", new String[0]);
                    if (10.traceable()) {
                        10.traceEval(req, rsp, node, "getDynamic(\"" + token + "\",...)");
                    }
                    if ((target = ff.bindAndInvoke(node, req, rsp, token)) != null) {
                        req.getStapler().invoke(req, rsp, target);
                        return true;
                    }
                    if (10.traceable()) {
                        10.trace(req, rsp, "            %s.getDynamic(\"%s\",...)==null. Back tracking.", node, token);
                    }
                    req.tokens.prev();
                    return false;
                }

                @Override
                public String toString() {
                    return String.format("%2$s %s(String,StaplerRequest[2],StaplerResponse[2]) for url=/TOKEN/...", ff.getQualifiedName(), ff.getReturnType().getName());
                }
            });
        }
        for (Function function : node.methods.name("doDynamic")) {
            final Function ff = function.contextualize(new WebMethodContext("\u0000"));
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, ServletException, IOException {
                    Dispatcher.anonymizedTraceEval(req, rsp, node, "%s#doDynamic(...)", new String[0]);
                    if (11.traceable()) {
                        11.trace(req, rsp, "-> <%s>.doDynamic(...)", node);
                    }
                    return ff.bindAndInvokeAndServeResponse(node, req, rsp, new Object[0]);
                }

                @Override
                public String toString() {
                    return String.format("%s(StaplerRequest[2],StaplerResponse[2]) for any URL", ff.getQualifiedName());
                }
            });
        }
        DispatchersFilter dispatchersFilter = this.webApp.getDispatchersFilter();
        if (dispatchersFilter != null) {
            dispatchersFilter.applyOn(this, node.methods, this.dispatchers);
        }
    }

    private void registerDoToken(KlassDescriptor<?> node) {
        FunctionList filteredFunctions;
        FunctionList functions;
        if (LEGACY_WEB_METHOD_MODE || this.webApp.getFilterForDoActions() == null) {
            filteredFunctions = functions = node.methods.webMethodsLegacy();
            LOGGER.log(Level.FINE, "Stapler is using the legacy METHOD_MODE");
        } else {
            List<Function> excludedByNew;
            functions = node.methods.webMethodsLegacy();
            filteredFunctions = functions.filter(this.webApp.getFilterForDoActions());
            if (LOGGER.isLoggable(Level.FINER) && !(excludedByNew = this.minus(functions, filteredFunctions)).isEmpty()) {
                for (Function excluded : excludedByNew) {
                    LOGGER.log(Level.FINER, "The following method is now blocked: {0}", excluded.getDisplayName());
                }
            }
        }
        for (final Function f : functions) {
            WebMethod a = f.getAnnotation(WebMethod.class);
            String[] names = a != null && a.name().length > 0 ? a.name() : new String[]{MetaClass.camelize(f.getName().substring(2))};
            for (String name : names) {
                final Function ff = f.contextualize(new WebMethodContext(name));
                if (name.isEmpty()) {
                    this.dispatchers.add(new IndexDispatcher(ff));
                    continue;
                }
                final boolean isAccepted = filteredFunctions.contains(f);
                this.dispatchers.add(new NameBasedDispatcher(name){

                    @Override
                    public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, ServletException, IOException {
                        if (isAccepted) {
                            Dispatcher.anonymizedTraceEval(req, rsp, node, "%s#%s", ff.getName());
                            if (12.traceable()) {
                                12.trace(req, rsp, "-> <%s>.%s(...)", node, ff.getName());
                            }
                            return ff.bindAndInvokeAndServeResponse(node, req, rsp, new Object[0]);
                        }
                        return MetaClass.this.webApp.getFilteredDoActionTriggerListener().onDoActionTrigger(f, req, rsp, node);
                    }

                    @Override
                    public String toString() {
                        if (isAccepted) {
                            return String.format("%1$s(...) for url=/%2$s/...", ff.getQualifiedName(), this.name);
                        }
                        return String.format("BLOCKED: %1$s(...) for url=/%2$s/...", ff.getQualifiedName(), this.name);
                    }
                });
            }
        }
    }

    private List<Function> minus(FunctionList a, FunctionList b) {
        ArrayList<Function> aMinusB = new ArrayList<Function>();
        for (Function f : a) {
            if (b.contains(f)) continue;
            aMinusB.add(f);
        }
        return aMinusB;
    }

    public SingleLinkedList<MethodRef> getPostConstructMethods() {
        if (this.postConstructMethods == null) {
            SingleLinkedList<MethodRef> l = this.baseClass == null ? SingleLinkedList.empty() : this.baseClass.getPostConstructMethods();
            for (MethodRef mr : this.klass.getDeclaredMethods()) {
                if (!mr.hasAnnotation(jakarta.annotation.PostConstruct.class) && !mr.hasAnnotation(PostConstruct.class)) continue;
                l = l.grow(mr);
            }
            this.postConstructMethods = l;
        }
        return this.postConstructMethods;
    }

    private String getProtectedRole(FieldRef f) {
        try {
            LimitedTo a = f.getAnnotation(LimitedTo.class);
            return a != null ? a.value() : null;
        }
        catch (LinkageError e) {
            return null;
        }
    }

    public String toString() {
        return "MetaClass[" + String.valueOf(this.klass) + "]";
    }

    private static String camelize(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    static {
        try {
            NO_CACHE = Boolean.getBoolean("stapler.jelly.noCache");
            LEGACY_GETTER_MODE = Boolean.getBoolean("stapler.legacyGetterDispatcherMode");
            LEGACY_WEB_METHOD_MODE = Boolean.getBoolean("stapler.legacyWebMethodDispatcherMode");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static class JavaScriptProxyMethodDispatcher
    extends NameBasedDispatcher {
        private final Function f;

        JavaScriptProxyMethodDispatcher(String name, Function f) {
            super(name, 0);
            this.f = f;
        }

        @Override
        public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, ServletException, IOException {
            if (!req.isJavaScriptProxyCall()) {
                return false;
            }
            req.stapler.getWebApp().getCrumbIssuer().validateCrumb(req, req.getHeader("Crumb"));
            Dispatcher.anonymizedTraceEval(req, rsp, node, "%s#%s", this.f.getName());
            if (JavaScriptProxyMethodDispatcher.traceable()) {
                JavaScriptProxyMethodDispatcher.trace(req, rsp, "-> <%s>.%s(...)", node, this.f.getName());
            }
            JSONArray jsargs = JSONArray.fromObject((Object)IOUtils.toString((Reader)req.getReader()));
            Object[] args = new Object[jsargs.size()];
            Class[] types = this.f.getParameterTypes();
            Object[] genericTypes = this.f.getGenericParameterTypes();
            if (args.length != types.length) {
                throw new IllegalArgumentException("argument count mismatch between " + String.valueOf(jsargs) + " and " + Arrays.toString(genericTypes));
            }
            for (int i = 0; i < args.length; ++i) {
                args[i] = req.bindJSON((Type)genericTypes[i], types[i], jsargs.get(i));
            }
            return this.f.bindAndInvokeAndServeResponse(node, req, rsp, args);
        }

        @Override
        public String toString() {
            return this.f.getQualifiedName() + "(...) for url=/" + this.name + "/...";
        }
    }
}

