/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.kohsuke.stapler.CancelRequestHandlingException;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public interface DispatchValidator {
    public static final DispatchValidator DEFAULT = new DispatchValidator(){

        @Override
        public Boolean isDispatchAllowed(@NonNull StaplerRequest2 req, @NonNull StaplerResponse2 rsp) {
            return true;
        }

        @Override
        public void allowDispatch(@NonNull StaplerRequest2 req, @NonNull StaplerResponse2 rsp) {
        }
    };

    @CheckForNull
    public Boolean isDispatchAllowed(@NonNull StaplerRequest2 var1, @NonNull StaplerResponse2 var2);

    @CheckForNull
    default public Boolean isDispatchAllowed(@NonNull StaplerRequest2 req, @NonNull StaplerResponse2 rsp, @NonNull String viewName, @CheckForNull Object node) {
        return this.isDispatchAllowed(req, rsp);
    }

    public void allowDispatch(@NonNull StaplerRequest2 var1, @NonNull StaplerResponse2 var2);

    default public void requireDispatchAllowed(@NonNull StaplerRequest2 req, @NonNull StaplerResponse2 rsp) throws CancelRequestHandlingException {
        Boolean allowed = this.isDispatchAllowed(req, rsp);
        if (allowed == null || !allowed.booleanValue()) {
            throw new CancelRequestHandlingException();
        }
    }
}

