// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The input value for token counting. The value should be either an <code>InvokeModel</code> or <code>Converse</code> request body.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub enum CountTokensInput {
    /// <p>A <code>Converse</code> request for which to count tokens. Use this field when you want to count tokens for a conversation-based input that would be sent to the <code>Converse</code> operation.</p>
    Converse(crate::types::ConverseTokensRequest),
    /// <p>An <code>InvokeModel</code> request for which to count tokens. Use this field when you want to count tokens for a raw text input that would be sent to the <code>InvokeModel</code> operation.</p>
    InvokeModel(crate::types::InvokeModelTokensRequest),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl CountTokensInput {
    /// Tries to convert the enum instance into [`Converse`](crate::types::CountTokensInput::Converse), extracting the inner [`ConverseTokensRequest`](crate::types::ConverseTokensRequest).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_converse(&self) -> ::std::result::Result<&crate::types::ConverseTokensRequest, &Self> {
        if let CountTokensInput::Converse(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Converse`](crate::types::CountTokensInput::Converse).
    pub fn is_converse(&self) -> bool {
        self.as_converse().is_ok()
    }
    /// Tries to convert the enum instance into [`InvokeModel`](crate::types::CountTokensInput::InvokeModel), extracting the inner [`InvokeModelTokensRequest`](crate::types::InvokeModelTokensRequest).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_invoke_model(&self) -> ::std::result::Result<&crate::types::InvokeModelTokensRequest, &Self> {
        if let CountTokensInput::InvokeModel(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`InvokeModel`](crate::types::CountTokensInput::InvokeModel).
    pub fn is_invoke_model(&self) -> bool {
        self.as_invoke_model().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
