RabbitMQ `3.11.27` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

This release series [is no longer covered by community support](https://www.rabbitmq.com/release-information).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25 and supports Erlang versions up to `25.3.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).


### Core Broker

#### Bug Fixes

 * Avoids a rare exception that could stop TCP socket writes on a client connection.

   GitHub issues: [#9991](https://github.com/rabbitmq/rabbitmq-server/issues/9991), [#9803](https://github.com/rabbitmq/rabbitmq-server/discussions/9803)

#### Enhancements

 * Definition files that are virtual host-specific cannot be imported on boot. Such files will now be
   detected early and the import process will terminate after logging a more informative message.

   Previous the import process would run into an obscure exception.

   GitHub issues: [#10068](https://github.com/rabbitmq/rabbitmq-server/issues/10068), [#10086](https://github.com/rabbitmq/rabbitmq-server/pull/10086)


### Shovel Plugin

#### Bug Fixes

 * Avoids two Shovels being started after an upgrade from `3.11.25` or older versions.

   Two Shovels running concurrently would still transfer messages but because they act as
   competing consumers (and publishers), this affected message ordering in the target queue.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issues: [#9965](https://github.com/rabbitmq/rabbitmq-server/pull/9965), [#10080](https://github.com/rabbitmq/rabbitmq-server/pull/10080)


### Management Plugin

#### Bug Fixes

 * `DELETE /api/policies/{vhost}/{policy}` returned a 500 response instead of a 404 one
   when target virtual host did not exist.

   GitHub issue: [#9983](https://github.com/rabbitmq/rabbitmq-server/issues/9983)


## Dependency Upgrades

 None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.27.tar.xz`
instead of the source tarball produced by GitHub.
