/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class ByteBufferUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer mapFile(File f11, long offset, ByteOrder byteOrder) throws IOException {
        try (FileInputStream dataFile = new FileInputStream(f11);){
            FileChannel fc2 = dataFile.getChannel();
            MappedByteBuffer buffer = fc2.map(FileChannel.MapMode.READ_ONLY, offset, f11.length() - offset);
            buffer.order(byteOrder);
            MappedByteBuffer mappedByteBuffer = buffer;
            return mappedByteBuffer;
        }
    }

    public static String getString(ByteBuffer buf, int len) {
        char[] data = new char[len];
        for (int i11 = 0; i11 < len; ++i11) {
            data[i11] = buf.getChar();
        }
        return new String(data);
    }

    public static void putString(ByteBuffer buf, String str) {
        int len = str.length();
        for (int i11 = 0; i11 < len; ++i11) {
            buf.putChar(str.charAt(i11));
        }
    }

    public static boolean cleanBuffer(ByteBuffer buffer) {
        if (!buffer.isDirect()) {
            return true;
        }
        try {
            Class<?> unsafeClass = ByteBufferUtil.class.getClassLoader().loadClass("sun.misc.Unsafe");
            Field f11 = unsafeClass.getDeclaredField("theUnsafe");
            f11.setAccessible(true);
            Object unsafe = f11.get(null);
            MethodType type = MethodType.methodType(Void.TYPE, ByteBuffer.class);
            MethodHandle handle = MethodHandles.lookup().findVirtual(unsafeClass, "invokeCleaner", type);
            handle.invoke(unsafeClass.cast(unsafe), buffer);
            return true;
        }
        catch (Throwable ex2) {
            Log.w("ddmlib", "ByteBufferUtil.cleanBuffer() failed " + ex2);
            return false;
        }
    }
}

