## RabbitMQ 4.1.8

RabbitMQ `4.1.8` is a maintenance release in the `4.1.x` [release series](https://www.rabbitmq.com/release-information).

It is **strongly recommended** that you read [4.1.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.1.0)
in detail if upgrading from a version prior to `4.1.0`.


### Minimum Supported Erlang Version

[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.1.x/release-notes).

### Core Server

#### Bug Fixes

 * Classic queue recovery on Windows could fail due to an OS-specific file locking behavior.
   Such failures are now retried in two more contexts.

   GitHub issue: [#15136](https://github.com/rabbitmq/rabbitmq-server/pull/15136)

  * [Default queue type](https://www.rabbitmq.com/docs/vhosts#default-queue-type) handling is now more defensive, avoiding an issue where
   attempts to declare a queue in a virtual host without any DQT set would result
   in a `PRECONDITION_FAILED` exception instead of falling back to the classic queue type
   for DQT.

   GitHub issues: [#11541](https://github.com/rabbitmq/rabbitmq-server/issues/11541), [#12109](https://github.com/rabbitmq/rabbitmq-server/issues/12109), [#12821](https://github.com/rabbitmq/rabbitmq-server/issues/12821), [#13837](https://github.com/rabbitmq/rabbitmq-server/issues/13837)

 * Topic exchange binding deletions could leave orphaned trie edges in the Khepri projection,
   potentially causing a slowly creeping memory leak.

   GitHub issue: [#15025](https://github.com/rabbitmq/rabbitmq-server/pull/15025)

 * When a client that owns an exclusive queue disconnects and immediately reconnects and redeclares the same queue
   (under the same name), RabbitMQ node could delete the new queue depending on the timing of events.

   Previously the only workaround was to use exclusive server-named queues for clients that exhibited
   this behavior. Now RabbitMQ nodes take internal owner identity into account and will remove
   the original queue but not the new one.

   GitHub issue: [#15276](https://github.com/rabbitmq/rabbitmq-server/pull/15276)

  * "Other ETS" and "Other system" memory metrics could end up being reported as negative values
    due to concurrent ETS table updates, deletion and creation on the node.

    GitHub issue: [#15289](https://github.com/rabbitmq/rabbitmq-server/pull/15289)

  * `mirrored_supervisor:child/2` could fail with a `badmatch` exception
    when a significant enough number of shovels (or federation links) was removed.

    GitHub issue: [#15229](https://github.com/rabbitmq/rabbitmq-server/pull/15229)


### Federation Plugins

#### Bug Fixes

 * Restored exchange federation compatibility in mixed 4.2.x/4.1.x multi-node clusters.

   GitHub issue: [#15252](https://github.com/rabbitmq/rabbitmq-server/pull/15252)

#### Enhancements

 * Federation links and their connections are now stopped in parallel.

   This significantly improves shutdown time for nodes with many (into thousands) federation links.

   GitHub issue: [#15271](https://github.com/rabbitmq/rabbitmq-server/pull/15271)

 * Federation links no longer restart during plugin or node shutdown.

   For nodes with hundreds or thousands of federation links, link recovery could
   significantly delay node shutdown.

   GitHub issue: [#15258](https://github.com/rabbitmq/rabbitmq-server/pull/15258)

 * Federation links use AMQP 0-9-1 connections to remote nodes (clusters).

   Previously the timeout used when those connections are closed was fixed to 10 seconds.
   Now it is configurable via `rabbitmq.conf` in milliseconds:

   ```ini
   # 3 seconds for exchange federation
   federation.exchanges.connection_close_timeout = 3000

   # 3 seconds for queue federation
   federation.queues.connection_close_timeout = 3000
   ```

   The maximum supported value is 5 seconds (5000 ms).

   GitHub issue: [#15268](https://github.com/rabbitmq/rabbitmq-server/pull/15268)


### MQTT Plugin

#### Enhancements

 * A new configuration option, `mqtt.disconnect_on_unauthorized`, controls whether
   MQTT connections are closed upon authorization failures (for example, an attempt to
   consume from a topic the client has no permission for).

   When set to `false`, the connection remains open and an appropriate protocol-level
   response is sent to the client instead.

   The default value is `true`, same as RabbitMQ MQTT implementation's historic behavior.

   GitHub issue: [#15201](https://github.com/rabbitmq/rabbitmq-server/pull/15201)
