<!--
GENERATED FILE - DO NOT EDIT
This file was generated by [MarkdownSnippets](https://github.com/SimonCropp/MarkdownSnippets).
Source File: /README.source.md
To change this file edit the source file and then run MarkdownSnippets.
-->

# EasyBuild.Tools

[![NuGet](https://img.shields.io/nuget/v/EasyBuild.Tools.svg)](https://www.nuget.org/packages/EasyBuild.Tools)

[![Sponsors badge link](https://img.shields.io/badge/Sponsors_this_project-EA4AAA?style=for-the-badge)](https://mangelmaxime.github.io/sponsors/)

Tool for generating changelog based on Git history based on [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/). It is using [EasyBuild.CommitParser](https://github.com/easybuild-org/EasyBuild.CommitParser) to parse commit messages check their documentation for more information about configuration.

<!-- toc -->
## Contents

  * [Installation](#installation)
  * [APIs](#apis)
    * [`Changelog`](#changelog)
    * [`ChangelogGen`](#changeloggen)
    * [`DotNet`](#dotnet)
    * [`Fable`](#fable)
    * [`FableCssModules`](#fablecssmodules)
    * [`Git`](#git)
    * [`Nodemon`](#nodemon)
    * [`Npm`](#npm)
    * [`PackageJson`](#packagejson)
    * [`Vercel`](#vercel)
    * [`Vite`](#vite)<!-- endToc -->

## Installation

```bash
dotnet add package EasyBuild.Tools
```

## APIs

### `Changelog`

<details>
<summary>
<code>Changelog.tryFindLastVersion</code>
- Try to find the last version in a changelog file
</summary>

<!-- snippet: Changelog.tryFindLastVersion -->
<a id='snippet-Changelog.tryFindLastVersion'></a>
```fs
(changelogFile: FileInfo)
```
<sup><a href='/src/Changelog.fs#L17-L19' title='Snippet source file'>snippet source</a> | <a href='#snippet-Changelog.tryFindLastVersion' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

<details>
<summary>
<code>Changelog.findLastVersion</code>
- Find the last version in a changelog file or throw an error if not found
</summary>

<!-- snippet: Changelog.findLastVersion -->
<a id='snippet-Changelog.findLastVersion'></a>
```fs
(changelogFile: FileInfo)
```
<sup><a href='/src/Changelog.fs#L44-L46' title='Snippet source file'>snippet source</a> | <a href='#snippet-Changelog.findLastVersion' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

### `ChangelogGen`

<details>
<summary>
<code>ChangelogGen.run</code>
- generate changelog using <a href="https://github.com/easybuild-org/EasyBuild.ChangelogGen">EasyBuild.ChangelogGen</a>
</summary>

<!-- snippet: ChangelogGen.run -->
<a id='snippet-ChangelogGen.run'></a>
```fs
(
    changelogFile: string,
    ?allowDirty: bool,
    ?allowBranch: string list,
    ?tagFilter: string list,
    ?preRelease: string,
    ?config: string,
    ?forceVersion: string,
    ?skipInvalidCommit: bool,
    ?dryRun: bool,
    ?githubRepo: string,
    ?workingDirectory: string,
    ?forwardArguments: string list
)
: string
```
<sup><a href='/src/ChangelogGen.fs#L15-L31' title='Snippet source file'>snippet source</a> | <a href='#snippet-ChangelogGen.run' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

**Example**

```fs
open EasyBuild.Tools.ChangelogGen

let newVersion = ChangelogGen.run "CHANGELOG.md"
```

</details>

<details>
<summary>
<code>ChangelogGen.tryRun</code>
- generate changelog using <a href="https://github.com/easybuild-org/EasyBuild.ChangelogGen">EasyBuild.ChangelogGen</a>
</summary>

<!-- snippet: ChangelogGen.tryRun -->
<a id='snippet-ChangelogGen.tryRun'></a>
```fs
(
    changelogFile: string,
    ?allowDirty: bool,
    ?allowBranch: string list,
    ?tagFilter: string list,
    ?preRelease: string,
    ?config: string,
    ?forceVersion: string,
    ?skipInvalidCommit: bool,
    ?dryRun: bool,
    ?githubRepo: string,
    ?workingDirectory: string,
    ?forwardArguments: string list
)
: ChangelogGenResult
```
<sup><a href='/src/ChangelogGen.fs#L58-L74' title='Snippet source file'>snippet source</a> | <a href='#snippet-ChangelogGen.tryRun' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

**Example**

```fs
open EasyBuild.Tools.ChangelogGen

match ChangelogGen.tryRun "CHANGELOG.md" with
| ChangelogGenResult.NoVersionBump ->
    printfn "Nothing to deploy"
| ChangelogGenResult.Error error ->
    failwithf "Error while generating changelog:\n%s" error
| ChangelogGenResult.NewVersion newVersion ->
    // Continue release process
```

</details>

### `DotNet`

<details>
<summary>
<code>DotNet.pack</code>
- create a NuGet package
</summary>

<!-- snippet: DotNet.pack -->
<a id='snippet-DotNet.pack'></a>
```fs
(?workingDirectory : string, ?projectFile: FileInfo, ?configuration: Configuration)
: FileInfo
```
<sup><a href='/src/DotNet.fs#L17-L20' title='Snippet source file'>snippet source</a> | <a href='#snippet-DotNet.pack' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

**Example**

```fs
open EasyBuild.Tools.DotNet

let nupkgFile = DotNet.pack()
```

</details>

<details>
<summary>
<code>DotNet.nugetPush</code>
- push a NuGet package to a NuGet server
</summary>

<!-- snippet: DotNet.nugetPush -->
<a id='snippet-DotNet.nugetPush'></a>
```fs
(
    nupkgPath: FileInfo,
    ?forceEnglishOutput: bool,
    ?source: string,
    ?symbolSource: string,
    ?timeout: int,
    ?apiKey: string,
    ?symbolApiKey: string,
    ?disableBuffering: bool,
    ?noSymbols: bool,
    ?interactive: bool,
    ?skipDuplicate: bool,
    ?forceEcho: bool
)
```
<sup><a href='/src/DotNet.fs#L58-L73' title='Snippet source file'>snippet source</a> | <a href='#snippet-DotNet.nugetPush' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

If `apiKey` is not provided, `NUGET_KEY` environment variable will be used.

If `symbolApiKey` is not provided, `NUGET_SYMBOL_KEY` environment variable will be used.

</details>

generate changelog using <a href="https://github.com/easybuild-org/EasyBuild.ChangelogGen">EasyBuild.ChangelogGen</a>

### `Fable`

<details>
<summary>
<code>Fable.build</code>
- run Fable compiler in build mode
</summary>

<!-- snippet: Fable.build -->
<a id='snippet-Fable.build'></a>
```fs
(
    ?projFileOrDir: string,
    ?outDir: string,
    ?extension: string,
    ?sourceMaps: bool,
    ?sourceMapsRoot: string,
    ?define: string list,
    ?configuration: string,
    ?verbose: bool,
    ?silent: bool,
    ?typedArrays: bool,
    ?run: string,
    ?runFast: string,
    ?runScript: bool,
    ?noRestore: bool,
    ?noCache: bool,
    ?exclude: string list,
    ?lang: Fable.Lang,
    ?workingDirectory: string
)
: unit
```
<sup><a href='/src/Fable.fs#L21-L43' title='Snippet source file'>snippet source</a> | <a href='#snippet-Fable.build' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

<details>
<summary>
<code>Fable.watch</code>
- run Fable compiler in watch mode
</summary>

<!-- snippet: Fable.watch -->
<a id='snippet-Fable.watch'></a>
```fs
(
    ?projFileOrDir: string,
    ?outDir: string,
    ?extension: string,
    ?sourceMaps: bool,
    ?sourceMapsRoot: string,
    ?define: string list,
    ?configuration: string,
    ?verbose: bool,
    ?silent: bool,
    ?typedArrays: bool,
    ?run: string,
    ?runFast: string,
    ?runScript: bool,
    ?runWatch: string,
    ?noRestore: bool,
    ?noCache: bool,
    ?exclude: string list,
    ?lang: Fable.Lang,
    ?workingDirectory: string
)
: Task
```
<sup><a href='/src/Fable.fs#L82-L105' title='Snippet source file'>snippet source</a> | <a href='#snippet-Fable.watch' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

### `FableCssModules`

<details>
<summary>
<code>FableCssModules.runAsync</code>
- run <a href="https://www.npmjs.com/package/fable-css-modules">fable-css-modules</a> in async mode
</summary>

<!-- snippet: FableCssModules.runAsync -->
<a id='snippet-FableCssModules.runAsync'></a>
```fs
(?outFile: string, ?``internal``: bool, ?camelCase: bool, ?workingDirectory: string)
: Task
```
<sup><a href='/src/FableCssModules.fs#L10-L13' title='Snippet source file'>snippet source</a> | <a href='#snippet-FableCssModules.runAsync' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

<details>
<summary>
<code>FableCssModules.run</code>
- run <a href="https://www.npmjs.com/package/fable-css-modules">fable-css-modules</a>
</summary>

<!-- snippet: FableCssModules.run -->
<a id='snippet-FableCssModules.run'></a>
```fs
(?outFile: string, ?``internal``: bool, ?camelCase: bool, ?workingDirectory: string)
: unit
```
<sup><a href='/src/FableCssModules.fs#L28-L31' title='Snippet source file'>snippet source</a> | <a href='#snippet-FableCssModules.run' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

### `Git`

<details>
<summary>
<code>Git.addAll</code>
- add all files to staging area
</summary>

<!-- snippet: Git.addAll -->
<a id='snippet-Git.addAll'></a>
```fs
()
```
<sup><a href='/src/Git.fs#L9-L11' title='Snippet source file'>snippet source</a> | <a href='#snippet-Git.addAll' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

<details>
<summary>
<code>Git.commitRelease</code>
- commit staged files with release message using conventional commit
</summary>

<!-- snippet: Git.commitRelease -->
<a id='snippet-Git.commitRelease'></a>
```fs
(newVersion: string)
```
<sup><a href='/src/Git.fs#L16-L18' title='Snippet source file'>snippet source</a> | <a href='#snippet-Git.commitRelease' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

<details>
<summary>
<code>Git.push</code>
- push to the remote repository
</summary>

<!-- snippet: Git.push -->
<a id='snippet-Git.push'></a>
```fs
(?force: bool)
```
<sup><a href='/src/Git.fs#L29-L31' title='Snippet source file'>snippet source</a> | <a href='#snippet-Git.push' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

### `Nodemon`

<details>
<summary>
<code>Nodemon.runAsync</code>
- run <a href="https://www.npmjs.com/package/nodemon">nodemon</a> in async mode
</summary>

<!-- snippet: Nodemon.runAsync -->
<a id='snippet-Nodemon.runAsync'></a>
```fs
(
    // Configuration
    ?config: string,
    ?exitCrash: bool,
    ?ignore: string list,
    ?noColors: bool,
    ?signal: string,
    ?watch: string list,
    ?noUpdateNotifier: bool,
    // Execution
    ?onChangeOnly: bool,
    ?cwd: string,
    ?extensions: string,
    ?noStdin: bool,
    ?spawn: bool,
    ?exec: string,
    ?yourArgs: string,
    // Watching
    ?delay: string,
    ?legacyWatch: bool,
    ?pollingInterval: int,
    // Information
    ?dump: bool,
    ?verbose: bool,
    ?workingDirectory: string
)
: Task
```
<sup><a href='/src/Nodemon.fs#L11-L39' title='Snippet source file'>snippet source</a> | <a href='#snippet-Nodemon.runAsync' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

<details>
<summary>
<code>Nodemon.run</code>
- run <a href="https://www.npmjs.com/package/nodemon">nodemon</a>
</summary>

<!-- snippet: Nodemon.run -->
<a id='snippet-Nodemon.run'></a>
```fs
(
    // Configuration
    ?config: string,
    ?exitCrash: bool,
    ?ignore: string list,
    ?noColors: bool,
    ?signal: string,
    ?watch: string list,
    ?noUpdateNotifier: bool,
    // Execution
    ?onChangeOnly: bool,
    ?cwd: string,
    ?extensions: string,
    ?noStdin: bool,
    ?spawn: bool,
    ?exec: string,
    ?yourArgs: string,
    // Watching
    ?delay: string,
    ?legacyWatch: bool,
    ?pollingInterval: int,
    // Information
    ?dump: bool,
    ?verbose: bool,
    ?workingDirectory: string
)
: unit
```
<sup><a href='/src/Nodemon.fs#L87-L115' title='Snippet source file'>snippet source</a> | <a href='#snippet-Nodemon.run' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

### `Npm`

<details>
<summary>
<code>Npm.publish</code>
- publish a package to the npm registry
</summary>

<!-- snippet: Npm.publish -->
<a id='snippet-Npm.publish'></a>
```fs
(projectDir: string, ?tag: string, ?isRestricted: bool)
```
<sup><a href='/src/Npm.fs#L10-L12' title='Snippet source file'>snippet source</a> | <a href='#snippet-Npm.publish' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

<details>
<summary>
<code>Npm.install</code>
- install npm packages
</summary>

<!-- snippet: Npm.install -->
<a id='snippet-Npm.install'></a>
```fs
(?workingDirectory: string)
```
<sup><a href='/src/Npm.fs#L31-L33' title='Snippet source file'>snippet source</a> | <a href='#snippet-Npm.install' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

### `PackageJson`

<details>
<summary>
<code>PackageJson.replaceVersion</code>
- replace the version in a <code>package.json</code> file
</summary>

<!-- snippet: PackageJson.replaceVersion -->
<a id='snippet-PackageJson.replaceVersion'></a>
```fs
(file: FileInfo, newVersion: string)
```
<sup><a href='/src/PackageJson.fs#L15-L17' title='Snippet source file'>snippet source</a> | <a href='#snippet-PackageJson.replaceVersion' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

**Example**

```fs
open EasyBuild.Tools.PackageJson

let packageJsonFile = FileInfo "package.json"
PackageJson.replaceVersion packageJsonFile "1.0.0"
```

</details>

<details>
<summary>
<code>PackageJson.getName</code>
- replace the version in a <code>package.json</code> file
</summary>

<!-- snippet: PackageJson.getName -->
<a id='snippet-PackageJson.getName'></a>
```fs
(file: FileInfo)
```
<sup><a href='/src/PackageJson.fs#L35-L37' title='Snippet source file'>snippet source</a> | <a href='#snippet-PackageJson.getName' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

**Example**

```fs
open EasyBuild.Tools.PackageJson

let packageJsonFile = FileInfo "package.json"
let packageName = PackageJson.getName packageJsonFile
```

</details>

<details>
<summary>
<code>PackageJson.getVersion</code>
- replace the version in a <code>package.json</code> file
</summary>

<!-- snippet: PackageJson.getVersion -->
<a id='snippet-PackageJson.getVersion'></a>
```fs
(file: FileInfo)
```
<sup><a href='/src/PackageJson.fs#L43-L45' title='Snippet source file'>snippet source</a> | <a href='#snippet-PackageJson.getVersion' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

**Example**

```fs
open EasyBuild.Tools.PackageJson

let packageJsonFile = FileInfo "package.json"
let packageVersion = PackageJson.getVersion packageJsonFile
```

</details>

<details>
<summary>
<code>PackageJson.needPublishing</code>
- check if a package needs to be published
</summary>

<!-- snippet: PackageJson.needPublishing -->
<a id='snippet-PackageJson.needPublishing'></a>
```fs
(packageJson: FileInfo)
: bool
```
<sup><a href='/src/PackageJson.fs#L56-L59' title='Snippet source file'>snippet source</a> | <a href='#snippet-PackageJson.needPublishing' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

**Example**

```fs
open EasyBuild.Tools.PackageJson

let packageJsonFile = FileInfo "package.json"

if PackageJson.needPublishing packageJsonFile then
    // Do something
```

</details>

### `Vercel`

<details>
<summary>
<code>Vercel.pull</code>
- Pull latest environment variables and project settings from Vercel
</summary>

<!-- snippet: Vercel.pull -->
<a id='snippet-Vercel.pull'></a>
```fs
(
    ?environment: string,
    ?gitBranch: string,
    ?yes: bool,
    ?debug: bool,
    ?globalConfig: string,
    ?localConfig: string,
    ?noColor: bool,
    ?scope: string,
    ?token: string,
    ?workingDirectory: string
)
```
<sup><a href='/src/Vercel.fs#L31-L44' title='Snippet source file'>snippet source</a> | <a href='#snippet-Vercel.pull' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

<details>
<summary>
<code>Vercel.build</code>
- build the project
</summary>

<!-- snippet: Vercel.build -->
<a id='snippet-Vercel.build'></a>
```fs
(
    ?output: string,
    ?prod: bool,
    ?yes: bool,
    ?debug: bool,
    ?globalConfig: string,
    ?localConfig: string,
    ?noColor: bool,
    ?scope: string,
    ?token: string,
    ?workingDirectory: string
)
```
<sup><a href='/src/Vercel.fs#L71-L84' title='Snippet source file'>snippet source</a> | <a href='#snippet-Vercel.build' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

<details>
<summary>
<code>Vercel.deploy</code>
- deploy your project to Vercel
</summary>

<!-- snippet: Vercel.deploy -->
<a id='snippet-Vercel.deploy'></a>
```fs
(
    ?archive: string,
    ?buildEnv: string,
    ?env: string,
    ?force: bool,
    ?meta: string,
    ?noWait: bool,
    ?prebuilt: bool,
    ?prod: bool,
    ?``public``: bool,
    ?regions: string list,
    ?skipDomain: bool,
    ?withCache: bool,
    ?yes: bool,
    ?debug: bool,
    ?globalConfig: string,
    ?localConfig: string,
    ?noColor: bool,
    ?scope: string,
    ?token: string,
    ?workingDirectory: string
)
```
<sup><a href='/src/Vercel.fs#L111-L134' title='Snippet source file'>snippet source</a> | <a href='#snippet-Vercel.deploy' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

### `Vite`

<details>
<summary>
<code>Vite.build</code>
- build for production
</summary>

<!-- snippet: Vite.build -->
<a id='snippet-Vite.build'></a>
```fs
(
    ?target: string,
    ?outDir: string,
    ?assetsDir: string,
    ?assetsInlineLimit: int,
    ?ssr: string,
    ?sourcemap: Vite.Build.SourceMap,
    ?minify: Vite.Build.Minifier,
    ?manifest: Vite.Build.Manifest,
    ?ssrManifest: Vite.Build.SSRManifest,
    ?emptyOutDir: bool,
    ?watch: bool,
    ?config: string,
    ?``base``: string,
    ?logLevel: Vite.Build.LogLevel,
    ?clearScreen: bool,
    ?debug: Vite.Build.Debug,
    ?filter: string,
    ?mode: string,
    ?workingDirectory: string
)
```
<sup><a href='/src/Vite.fs#L72-L94' title='Snippet source file'>snippet source</a> | <a href='#snippet-Vite.build' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>

<details>
<summary>
<code>Vite.watch</code>
- start development server
</summary>

<!-- snippet: Vite.watch -->
<a id='snippet-Vite.watch'></a>
```fs
(
    ?host: string,
    ?port: int,
    ?``open``: Vite.Watch.Open,
    ?cors: bool,
    ?strictPort: bool,
    ?force: bool,
    ?config: string,
    ?``base``: string,
    ?logLevel: Vite.Watch.LogLevel,
    ?clearScreen: bool,
    ?debug: Vite.Watch.Debug,
    ?filter: string,
    ?mode: string,
    ?workingDirectory: string
)
: Task
```
<sup><a href='/src/Vite.fs#L191-L209' title='Snippet source file'>snippet source</a> | <a href='#snippet-Vite.watch' title='Start of snippet'>anchor</a></sup>
<!-- endSnippet -->

</details>
