// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// RUN: %clang_cc1        -triple aarch64-none-linux-gnu -target-feature +neon -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -p mem2reg | FileCheck %s
// RUN: %clang_cc1 -x c++ -triple aarch64-none-linux-gnu -target-feature +neon -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -p mem2reg | FileCheck %s -check-prefix CHECK-CXX

// RUN: %clang_cc1        -triple aarch64-none-linux-gnu -target-feature +neon -disable-O0-optnone -Werror -Wall -S -o /dev/null %s

// REQUIRES: aarch64-registered-target

#include <arm_neon.h>

// Bitcast between FP8 Neon vectors
// CHECK-LABEL: define dso_local <8 x i8> @test_f8_f8(
// CHECK-SAME: <8 x i8> [[X:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <8 x i8> [[X]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z10test_f8_f813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[X:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <8 x i8> [[X]]
//
mfloat8x8_t test_f8_f8(mfloat8x8_t x) {
    return (mfloat8x8_t) x;
}

// CHECK-LABEL: define dso_local <16 x i8> @testq_f8_f8(
// CHECK-SAME: <16 x i8> [[X:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <16 x i8> [[X]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z11testq_f8_f814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[X:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <16 x i8> [[X]]
//
mfloat8x16_t testq_f8_f8(mfloat8x16_t x) {
    return (mfloat8x16_t) x;
}

// Bitcast between FP8 and int8 Neon vectors
// CHECK-LABEL: define dso_local <8 x i8> @test_f8_s8(
// CHECK-SAME: <8 x i8> noundef [[X:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <8 x i8> [[X]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z10test_f8_s810__Int8x8_t(
// CHECK-CXX-SAME: <8 x i8> noundef [[X:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <8 x i8> [[X]]
//
mfloat8x8_t test_f8_s8(int8x8_t x) {
    return (mfloat8x8_t) x;
}

// CHECK-LABEL: define dso_local <8 x i8> @test_s8_f8(
// CHECK-SAME: <8 x i8> [[X:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <8 x i8> [[X]]
//
// CHECK-CXX-LABEL: define dso_local noundef <8 x i8> @_Z10test_s8_f813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[X:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <8 x i8> [[X]]
//
int8x8_t test_s8_f8(mfloat8x8_t x) {
    return (int8x8_t) x;
}

// CHECK-LABEL: define dso_local <16 x i8> @testq_f8_s8(
// CHECK-SAME: <16 x i8> noundef [[X:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <16 x i8> [[X]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z11testq_f8_s811__Int8x16_t(
// CHECK-CXX-SAME: <16 x i8> noundef [[X:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <16 x i8> [[X]]
//
mfloat8x16_t testq_f8_s8(int8x16_t x) {
    return (mfloat8x16_t) x;
}

// CHECK-LABEL: define dso_local <16 x i8> @testq_s8_f8(
// CHECK-SAME: <16 x i8> [[X:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <16 x i8> [[X]]
//
// CHECK-CXX-LABEL: define dso_local noundef <16 x i8> @_Z11testq_s8_f814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[X:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <16 x i8> [[X]]
//
int8x16_t testq_s8_f8(mfloat8x16_t x) {
    return (int8x16_t) x;
}

// Bitcast between FP8 and float32 Neon vectors
// CHECK-LABEL: define dso_local <8 x i8> @test_f8_f32(
// CHECK-SAME: <2 x float> noundef [[X:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[X]] to <8 x i8>
// CHECK-NEXT:    ret <8 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z11test_f8_f3213__Float32x2_t(
// CHECK-CXX-SAME: <2 x float> noundef [[X:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[X]] to <8 x i8>
// CHECK-CXX-NEXT:    ret <8 x i8> [[TMP0]]
//
mfloat8x8_t test_f8_f32(float32x2_t x) {
    return (mfloat8x8_t) x;
}

// CHECK-LABEL: define dso_local <2 x float> @test_f32_f8(
// CHECK-SAME: <8 x i8> [[X:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[X]] to <2 x float>
// CHECK-NEXT:    ret <2 x float> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <2 x float> @_Z11test_f32_f813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[X:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[X]] to <2 x float>
// CHECK-CXX-NEXT:    ret <2 x float> [[TMP0]]
//
float32x2_t test_f32_f8(mfloat8x8_t x) {
    return (float32x2_t) x;
}

// CHECK-LABEL: define dso_local <16 x i8> @testq_f8_f32(
// CHECK-SAME: <4 x float> noundef [[X:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[X]] to <16 x i8>
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z12testq_f8_f3213__Float32x4_t(
// CHECK-CXX-SAME: <4 x float> noundef [[X:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[X]] to <16 x i8>
// CHECK-CXX-NEXT:    ret <16 x i8> [[TMP0]]
//
mfloat8x16_t testq_f8_f32(float32x4_t x) {
    return (mfloat8x16_t) x;
}

// CHECK-LABEL: define dso_local <4 x float> @testq_f32_f8(
// CHECK-SAME: <16 x i8> [[X:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[X]] to <4 x float>
// CHECK-NEXT:    ret <4 x float> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <4 x float> @_Z12testq_f32_f814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[X:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[X]] to <4 x float>
// CHECK-CXX-NEXT:    ret <4 x float> [[TMP0]]
//
float32x4_t testq_f32_f8(mfloat8x16_t x) {
    return (float32x4_t) x;
}

// Bitcast between FP8 and poly128_t (which is integral)
// CHECK-LABEL: define dso_local <16 x i8> @testq_f8_p128(
// CHECK-SAME: i128 noundef [[X:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast i128 [[X]] to <16 x i8>
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z13testq_f8_p128o(
// CHECK-CXX-SAME: i128 noundef [[X:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast i128 [[X]] to <16 x i8>
// CHECK-CXX-NEXT:    ret <16 x i8> [[TMP0]]
//
mfloat8x16_t testq_f8_p128(poly128_t x) {
    return (mfloat8x16_t) x;
}

// CHECK-LABEL: define dso_local i128 @testq_p128_f8(
// CHECK-SAME: <16 x i8> [[X:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[X]] to i128
// CHECK-NEXT:    ret i128 [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef i128 @_Z13testq_p128_f814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[X:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[X]] to i128
// CHECK-CXX-NEXT:    ret i128 [[TMP0]]
//
poly128_t testq_p128_f8(mfloat8x16_t x) {
    return (poly128_t) x;
}
